/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.checkbox;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedStateListDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.autofill.AutofillManager;
import android.widget.CompoundButton;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.widget.CompoundButtonCompat;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.drawable.DrawableUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.LinkedHashSet;

public class MaterialCheckBox
extends AppCompatCheckBox {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_CompoundButton_CheckBox;
    public static final int STATE_UNCHECKED = 0;
    public static final int STATE_CHECKED = 1;
    public static final int STATE_INDETERMINATE = 2;
    private static final int[] INDETERMINATE_STATE_SET = new int[]{R.attr.state_indeterminate};
    private static final int[] ERROR_STATE_SET = new int[]{R.attr.state_error};
    private static final int[][] CHECKBOX_STATES = new int[][]{{16842910, R.attr.state_error}, {16842910, 0x10100A0}, {16842910, -16842912}, {-16842910, 0x10100A0}, {-16842910, -16842912}};
    @SuppressLint(value={"DiscouragedApi"})
    private static final int FRAMEWORK_BUTTON_DRAWABLE_RES_ID = Resources.getSystem().getIdentifier("btn_check_material_anim", "drawable", "android");
    @NonNull
    private final LinkedHashSet<OnErrorChangedListener> onErrorChangedListeners = new LinkedHashSet();
    @NonNull
    private final LinkedHashSet<OnCheckedStateChangedListener> onCheckedStateChangedListeners = new LinkedHashSet();
    @Nullable
    private ColorStateList materialThemeColorsTintList;
    private boolean useMaterialThemeColors;
    private boolean centerIfNoTextEnabled;
    private boolean errorShown;
    @Nullable
    private CharSequence errorAccessibilityLabel;
    @Nullable
    private Drawable buttonDrawable;
    @Nullable
    private Drawable buttonIconDrawable;
    private boolean usingMaterialButtonDrawable;
    @Nullable
    ColorStateList buttonTintList;
    @Nullable
    ColorStateList buttonIconTintList;
    @NonNull
    private PorterDuff.Mode buttonIconTintMode;
    private int checkedState;
    private int[] currentStateChecked;
    private boolean broadcasting;
    @Nullable
    private CharSequence customStateDescription;
    @Nullable
    private CompoundButton.OnCheckedChangeListener onCheckedChangeListener;
    @Nullable
    private final AnimatedVectorDrawableCompat transitionToUnchecked = AnimatedVectorDrawableCompat.create((Context)this.getContext(), (int)R.drawable.mtrl_checkbox_button_checked_unchecked);
    private final Animatable2Compat.AnimationCallback transitionToUncheckedCallback = new Animatable2Compat.AnimationCallback(){

        public void onAnimationStart(Drawable drawable2) {
            super.onAnimationStart(drawable2);
            if (MaterialCheckBox.this.buttonTintList != null) {
                DrawableCompat.setTint((Drawable)drawable2, (int)MaterialCheckBox.this.buttonTintList.getColorForState(MaterialCheckBox.this.currentStateChecked, MaterialCheckBox.this.buttonTintList.getDefaultColor()));
            }
        }

        public void onAnimationEnd(Drawable drawable2) {
            super.onAnimationEnd(drawable2);
            if (MaterialCheckBox.this.buttonTintList != null) {
                DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)MaterialCheckBox.this.buttonTintList);
            }
        }
    };

    public MaterialCheckBox(Context context) {
        this(context, null);
    }

    public MaterialCheckBox(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.checkboxStyle);
    }

    public MaterialCheckBox(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        this.buttonDrawable = CompoundButtonCompat.getButtonDrawable((CompoundButton)this);
        this.buttonTintList = this.getSuperButtonTintList();
        this.setSupportButtonTintList(null);
        TintTypedArray attributes = ThemeEnforcement.obtainTintedStyledAttributes(context, attrs, R.styleable.MaterialCheckBox, defStyleAttr, DEF_STYLE_RES, new int[0]);
        this.buttonIconDrawable = attributes.getDrawable(R.styleable.MaterialCheckBox_buttonIcon);
        if (this.buttonDrawable != null && ThemeEnforcement.isMaterial3Theme(context) && this.isButtonDrawableLegacy(attributes)) {
            super.setButtonDrawable(null);
            this.buttonDrawable = AppCompatResources.getDrawable((Context)context, (int)R.drawable.mtrl_checkbox_button);
            this.usingMaterialButtonDrawable = true;
            if (this.buttonIconDrawable == null) {
                this.buttonIconDrawable = AppCompatResources.getDrawable((Context)context, (int)R.drawable.mtrl_checkbox_button_icon);
            }
        }
        this.buttonIconTintList = MaterialResources.getColorStateList(context, attributes, R.styleable.MaterialCheckBox_buttonIconTint);
        this.buttonIconTintMode = ViewUtils.parseTintMode(attributes.getInt(R.styleable.MaterialCheckBox_buttonIconTintMode, -1), PorterDuff.Mode.SRC_IN);
        this.useMaterialThemeColors = attributes.getBoolean(R.styleable.MaterialCheckBox_useMaterialThemeColors, false);
        this.centerIfNoTextEnabled = attributes.getBoolean(R.styleable.MaterialCheckBox_centerIfNoTextEnabled, true);
        this.errorShown = attributes.getBoolean(R.styleable.MaterialCheckBox_errorShown, false);
        this.errorAccessibilityLabel = attributes.getText(R.styleable.MaterialCheckBox_errorAccessibilityLabel);
        if (attributes.hasValue(R.styleable.MaterialCheckBox_checkedState)) {
            this.setCheckedState(attributes.getInt(R.styleable.MaterialCheckBox_checkedState, 0));
        }
        attributes.recycle();
        this.refreshButtonDrawable();
        if (Build.VERSION.SDK_INT < 21 && this.buttonIconDrawable != null) {
            this.post(() -> this.buttonIconDrawable.jumpToCurrentState());
        }
    }

    protected void onDraw(Canvas canvas) {
        Drawable drawable2;
        if (this.centerIfNoTextEnabled && TextUtils.isEmpty((CharSequence)this.getText()) && (drawable2 = CompoundButtonCompat.getButtonDrawable((CompoundButton)this)) != null) {
            int direction = ViewUtils.isLayoutRtl((View)this) ? -1 : 1;
            int dx = (this.getWidth() - drawable2.getIntrinsicWidth()) / 2 * direction;
            int saveCount = canvas.save();
            canvas.translate((float)dx, 0.0f);
            super.onDraw(canvas);
            canvas.restoreToCount(saveCount);
            if (this.getBackground() != null) {
                Rect bounds = drawable2.getBounds();
                DrawableCompat.setHotspotBounds((Drawable)this.getBackground(), (int)(bounds.left + dx), (int)bounds.top, (int)(bounds.right + dx), (int)bounds.bottom);
            }
            return;
        }
        super.onDraw(canvas);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.useMaterialThemeColors && this.buttonTintList == null && this.buttonIconTintList == null) {
            this.setUseMaterialThemeColors(true);
        }
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableStates = super.onCreateDrawableState(extraSpace + 2);
        if (this.getCheckedState() == 2) {
            MaterialCheckBox.mergeDrawableStates((int[])drawableStates, (int[])INDETERMINATE_STATE_SET);
        }
        if (this.isErrorShown()) {
            MaterialCheckBox.mergeDrawableStates((int[])drawableStates, (int[])ERROR_STATE_SET);
        }
        this.currentStateChecked = DrawableUtils.getCheckedState(drawableStates);
        this.updateIconTintIfNeeded();
        return drawableStates;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateIconTintIfNeeded();
    }

    public void setChecked(boolean checked) {
        this.setCheckedState(checked ? 1 : 0);
    }

    public boolean isChecked() {
        return this.checkedState == 1;
    }

    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    public void setOnCheckedChangeListener(@Nullable CompoundButton.OnCheckedChangeListener listener) {
        this.onCheckedChangeListener = listener;
    }

    public void onInitializeAccessibilityNodeInfo(@Nullable AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        if (info == null) {
            return;
        }
        if (this.isErrorShown()) {
            info.setText((CharSequence)(info.getText() + ", " + this.errorAccessibilityLabel));
        }
    }

    public void setCheckedState(int checkedState) {
        if (this.checkedState != checkedState) {
            AutofillManager autofillManager;
            this.checkedState = checkedState;
            super.setChecked(this.checkedState == 1);
            this.refreshDrawableState();
            this.setDefaultStateDescription();
            if (this.broadcasting) {
                return;
            }
            this.broadcasting = true;
            if (this.onCheckedStateChangedListeners != null) {
                for (OnCheckedStateChangedListener listener : this.onCheckedStateChangedListeners) {
                    listener.onCheckedStateChangedListener(this, this.checkedState);
                }
            }
            if (this.checkedState != 2 && this.onCheckedChangeListener != null) {
                this.onCheckedChangeListener.onCheckedChanged((CompoundButton)this, this.isChecked());
            }
            if (Build.VERSION.SDK_INT >= 26 && (autofillManager = (AutofillManager)this.getContext().getSystemService(AutofillManager.class)) != null) {
                autofillManager.notifyValueChanged((View)this);
            }
            this.broadcasting = false;
            if (Build.VERSION.SDK_INT < 21 && this.buttonIconDrawable != null) {
                this.refreshDrawableState();
            }
        }
    }

    public int getCheckedState() {
        return this.checkedState;
    }

    public void addOnCheckedStateChangedListener(@NonNull OnCheckedStateChangedListener listener) {
        this.onCheckedStateChangedListeners.add(listener);
    }

    public void removeOnCheckedStateChangedListener(@NonNull OnCheckedStateChangedListener listener) {
        this.onCheckedStateChangedListeners.remove(listener);
    }

    public void clearOnCheckedStateChangedListeners() {
        this.onCheckedStateChangedListeners.clear();
    }

    public void setErrorShown(boolean errorShown) {
        if (this.errorShown == errorShown) {
            return;
        }
        this.errorShown = errorShown;
        this.refreshDrawableState();
        for (OnErrorChangedListener listener : this.onErrorChangedListeners) {
            listener.onErrorChanged(this, this.errorShown);
        }
    }

    public boolean isErrorShown() {
        return this.errorShown;
    }

    public void setErrorAccessibilityLabelResource(@StringRes int resId) {
        this.setErrorAccessibilityLabel(resId != 0 ? this.getResources().getText(resId) : null);
    }

    public void setErrorAccessibilityLabel(@Nullable CharSequence errorAccessibilityLabel) {
        this.errorAccessibilityLabel = errorAccessibilityLabel;
    }

    @Nullable
    public CharSequence getErrorAccessibilityLabel() {
        return this.errorAccessibilityLabel;
    }

    public void addOnErrorChangedListener(@NonNull OnErrorChangedListener listener) {
        this.onErrorChangedListeners.add(listener);
    }

    public void removeOnErrorChangedListener(@NonNull OnErrorChangedListener listener) {
        this.onErrorChangedListeners.remove(listener);
    }

    public void clearOnErrorChangedListeners() {
        this.onErrorChangedListeners.clear();
    }

    public void setButtonDrawable(@DrawableRes int resId) {
        this.setButtonDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)resId));
    }

    public void setButtonDrawable(@Nullable Drawable drawable2) {
        this.buttonDrawable = drawable2;
        this.usingMaterialButtonDrawable = false;
        this.refreshButtonDrawable();
    }

    @Nullable
    public Drawable getButtonDrawable() {
        return this.buttonDrawable;
    }

    public void setButtonTintList(@Nullable ColorStateList tintList) {
        if (this.buttonTintList == tintList) {
            return;
        }
        this.buttonTintList = tintList;
        this.refreshButtonDrawable();
    }

    @Nullable
    public ColorStateList getButtonTintList() {
        return this.buttonTintList;
    }

    public void setButtonTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.setSupportButtonTintMode(tintMode);
        this.refreshButtonDrawable();
    }

    public void setButtonIconDrawableResource(@DrawableRes int resId) {
        this.setButtonIconDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)resId));
    }

    public void setButtonIconDrawable(@Nullable Drawable drawable2) {
        this.buttonIconDrawable = drawable2;
        this.refreshButtonDrawable();
    }

    @Nullable
    public Drawable getButtonIconDrawable() {
        return this.buttonIconDrawable;
    }

    public void setButtonIconTintList(@Nullable ColorStateList tintList) {
        if (this.buttonIconTintList == tintList) {
            return;
        }
        this.buttonIconTintList = tintList;
        this.refreshButtonDrawable();
    }

    @Nullable
    public ColorStateList getButtonIconTintList() {
        return this.buttonIconTintList;
    }

    public void setButtonIconTintMode(@NonNull PorterDuff.Mode tintMode) {
        if (this.buttonIconTintMode == tintMode) {
            return;
        }
        this.buttonIconTintMode = tintMode;
        this.refreshButtonDrawable();
    }

    @NonNull
    public PorterDuff.Mode getButtonIconTintMode() {
        return this.buttonIconTintMode;
    }

    public void setUseMaterialThemeColors(boolean useMaterialThemeColors) {
        this.useMaterialThemeColors = useMaterialThemeColors;
        if (useMaterialThemeColors) {
            CompoundButtonCompat.setButtonTintList((CompoundButton)this, (ColorStateList)this.getMaterialThemeColorsTintList());
        } else {
            CompoundButtonCompat.setButtonTintList((CompoundButton)this, null);
        }
    }

    public boolean isUseMaterialThemeColors() {
        return this.useMaterialThemeColors;
    }

    public void setCenterIfNoTextEnabled(boolean centerIfNoTextEnabled) {
        this.centerIfNoTextEnabled = centerIfNoTextEnabled;
    }

    public boolean isCenterIfNoTextEnabled() {
        return this.centerIfNoTextEnabled;
    }

    private void refreshButtonDrawable() {
        this.buttonDrawable = DrawableUtils.createTintableMutatedDrawableIfNeeded(this.buttonDrawable, this.buttonTintList, CompoundButtonCompat.getButtonTintMode((CompoundButton)this));
        this.buttonIconDrawable = DrawableUtils.createTintableMutatedDrawableIfNeeded(this.buttonIconDrawable, this.buttonIconTintList, this.buttonIconTintMode);
        this.setUpDefaultButtonDrawableAnimationIfNeeded();
        this.updateButtonTints();
        super.setButtonDrawable(DrawableUtils.compositeTwoLayeredDrawable(this.buttonDrawable, this.buttonIconDrawable));
        this.refreshDrawableState();
    }

    private void setUpDefaultButtonDrawableAnimationIfNeeded() {
        if (!this.usingMaterialButtonDrawable) {
            return;
        }
        if (this.transitionToUnchecked != null) {
            this.transitionToUnchecked.unregisterAnimationCallback(this.transitionToUncheckedCallback);
            this.transitionToUnchecked.registerAnimationCallback(this.transitionToUncheckedCallback);
        }
        if (Build.VERSION.SDK_INT >= 24 && this.buttonDrawable instanceof AnimatedStateListDrawable && this.transitionToUnchecked != null) {
            ((AnimatedStateListDrawable)this.buttonDrawable).addTransition(R.id.checked, R.id.unchecked, (Drawable)this.transitionToUnchecked, false);
            ((AnimatedStateListDrawable)this.buttonDrawable).addTransition(R.id.indeterminate, R.id.unchecked, (Drawable)this.transitionToUnchecked, false);
        }
    }

    private void updateButtonTints() {
        if (this.buttonDrawable != null && this.buttonTintList != null) {
            DrawableCompat.setTintList((Drawable)this.buttonDrawable, (ColorStateList)this.buttonTintList);
        }
        if (this.buttonIconDrawable != null && this.buttonIconTintList != null) {
            DrawableCompat.setTintList((Drawable)this.buttonIconDrawable, (ColorStateList)this.buttonIconTintList);
        }
    }

    private void updateIconTintIfNeeded() {
        if (Build.VERSION.SDK_INT < 21 && this.buttonIconDrawable != null && this.buttonIconTintList != null) {
            this.buttonIconDrawable.setColorFilter((ColorFilter)DrawableUtils.updateTintFilter(this.buttonIconDrawable, this.buttonIconTintList, this.buttonIconTintMode));
        }
    }

    @RequiresApi(value=30)
    public void setStateDescription(@Nullable CharSequence stateDescription) {
        this.customStateDescription = stateDescription;
        if (stateDescription == null) {
            this.setDefaultStateDescription();
        } else {
            super.setStateDescription(stateDescription);
        }
    }

    private void setDefaultStateDescription() {
        if (Build.VERSION.SDK_INT >= 30 && this.customStateDescription == null) {
            super.setStateDescription((CharSequence)this.getButtonStateDescription());
        }
    }

    @NonNull
    private String getButtonStateDescription() {
        if (this.checkedState == 1) {
            return this.getResources().getString(R.string.mtrl_checkbox_state_description_checked);
        }
        if (this.checkedState == 0) {
            return this.getResources().getString(R.string.mtrl_checkbox_state_description_unchecked);
        }
        return this.getResources().getString(R.string.mtrl_checkbox_state_description_indeterminate);
    }

    @Nullable
    private ColorStateList getSuperButtonTintList() {
        if (this.buttonTintList != null) {
            return this.buttonTintList;
        }
        if (Build.VERSION.SDK_INT >= 21 && super.getButtonTintList() != null) {
            return super.getButtonTintList();
        }
        return this.getSupportButtonTintList();
    }

    private boolean isButtonDrawableLegacy(TintTypedArray attributes) {
        int buttonResourceId = attributes.getResourceId(R.styleable.MaterialCheckBox_android_button, 0);
        int buttonCompatResourceId = attributes.getResourceId(R.styleable.MaterialCheckBox_buttonCompat, 0);
        if (Build.VERSION.SDK_INT < 21) {
            return buttonResourceId == R.drawable.abc_btn_check_material && buttonCompatResourceId == R.drawable.abc_btn_check_material_anim;
        }
        return buttonResourceId == FRAMEWORK_BUTTON_DRAWABLE_RES_ID && buttonCompatResourceId == 0;
    }

    private ColorStateList getMaterialThemeColorsTintList() {
        if (this.materialThemeColorsTintList == null) {
            int[] checkBoxColorsList = new int[CHECKBOX_STATES.length];
            int colorControlActivated = MaterialColors.getColor((View)this, R.attr.colorControlActivated);
            int colorError = MaterialColors.getColor((View)this, R.attr.colorError);
            int colorSurface = MaterialColors.getColor((View)this, R.attr.colorSurface);
            int colorOnSurface = MaterialColors.getColor((View)this, R.attr.colorOnSurface);
            checkBoxColorsList[0] = MaterialColors.layer(colorSurface, colorError, 1.0f);
            checkBoxColorsList[1] = MaterialColors.layer(colorSurface, colorControlActivated, 1.0f);
            checkBoxColorsList[2] = MaterialColors.layer(colorSurface, colorOnSurface, 0.54f);
            checkBoxColorsList[3] = MaterialColors.layer(colorSurface, colorOnSurface, 0.38f);
            checkBoxColorsList[4] = MaterialColors.layer(colorSurface, colorOnSurface, 0.38f);
            this.materialThemeColorsTintList = new ColorStateList(CHECKBOX_STATES, checkBoxColorsList);
        }
        return this.materialThemeColorsTintList;
    }

    @Nullable
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.checkedState = this.getCheckedState();
        return ss;
    }

    public void onRestoreInstanceState(@Nullable Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setCheckedState(ss.checkedState);
    }

    static class SavedState
    extends View.BaseSavedState {
        int checkedState;
        @NonNull
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.checkedState = (Integer)in.readValue(((Object)((Object)this)).getClass().getClassLoader());
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeValue((Object)this.checkedState);
        }

        @NonNull
        public String toString() {
            return "MaterialCheckBox.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " CheckedState=" + this.getCheckedStateString() + "}";
        }

        @NonNull
        private String getCheckedStateString() {
            switch (this.checkedState) {
                case 1: {
                    return "checked";
                }
                case 2: {
                    return "indeterminate";
                }
            }
            return "unchecked";
        }
    }

    public static interface OnErrorChangedListener {
        public void onErrorChanged(@NonNull MaterialCheckBox var1, boolean var2);
    }

    public static interface OnCheckedStateChangedListener {
        public void onCheckedStateChangedListener(@NonNull MaterialCheckBox var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface CheckedState {
    }
}

