/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.math.MathUtils;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.R;
import com.google.android.material.carousel.Carousel;
import com.google.android.material.carousel.CarouselStrategy;
import com.google.android.material.carousel.KeylineState;

public final class MultiBrowseCarouselStrategy
extends CarouselStrategy {
    private static final float MEDIUM_ITEM_FLEX_PERCENTAGE = 0.1f;
    private static final int[] SMALL_COUNTS = new int[]{1};
    private static final int[] MEDIUM_COUNTS = new int[]{1, 0};
    private static final int[] MEDIUM_COUNTS_COMPACT = new int[]{0};
    private final boolean forceCompactArrangement;

    public MultiBrowseCarouselStrategy() {
        this(false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MultiBrowseCarouselStrategy(boolean forceCompactArrangement) {
        this.forceCompactArrangement = forceCompactArrangement;
    }

    private float getExtraSmallSize(@NonNull Context context) {
        return context.getResources().getDimension(R.dimen.m3_carousel_gone_size);
    }

    private float getSmallSizeMin(@NonNull Context context) {
        return context.getResources().getDimension(R.dimen.m3_carousel_small_item_size_min);
    }

    private float getSmallSizeMax(@NonNull Context context) {
        return context.getResources().getDimension(R.dimen.m3_carousel_small_item_size_max);
    }

    @Override
    @NonNull
    KeylineState onFirstChildMeasuredWithMargins(@NonNull Carousel carousel, @NonNull View child) {
        float availableSpace = carousel.getContainerWidth();
        RecyclerView.LayoutParams childLayoutParams = (RecyclerView.LayoutParams)child.getLayoutParams();
        float childHorizontalMargins = childLayoutParams.leftMargin + childLayoutParams.rightMargin;
        float smallChildWidthMin = this.getSmallSizeMin(child.getContext()) + childHorizontalMargins;
        float smallChildWidthMax = this.getSmallSizeMax(child.getContext()) + childHorizontalMargins;
        float measuredChildWidth = child.getMeasuredWidth();
        float targetLargeChildWidth = Math.min(measuredChildWidth + childHorizontalMargins, availableSpace);
        float targetSmallChildWidth = MathUtils.clamp((float)(measuredChildWidth / 3.0f + childHorizontalMargins), (float)(this.getSmallSizeMin(child.getContext()) + childHorizontalMargins), (float)(this.getSmallSizeMax(child.getContext()) + childHorizontalMargins));
        float targetMediumChildWidth = (targetLargeChildWidth + targetSmallChildWidth) / 2.0f;
        int[] smallCounts = SMALL_COUNTS;
        int[] mediumCounts = this.forceCompactArrangement ? MEDIUM_COUNTS_COMPACT : MEDIUM_COUNTS;
        float minAvailableLargeSpace = availableSpace - targetMediumChildWidth * (float)MultiBrowseCarouselStrategy.maxValue(mediumCounts) - smallChildWidthMax * (float)MultiBrowseCarouselStrategy.maxValue(smallCounts);
        int largeCountMin = (int)Math.max(1.0, Math.floor(minAvailableLargeSpace / targetLargeChildWidth));
        int largeCountMax = (int)Math.ceil(availableSpace / targetLargeChildWidth);
        int[] largeCounts = new int[largeCountMax - largeCountMin + 1];
        for (int i = 0; i < largeCounts.length; ++i) {
            largeCounts[i] = largeCountMax - i;
        }
        Arrangement arrangement = MultiBrowseCarouselStrategy.findLowestCostArrangement(availableSpace, targetSmallChildWidth, smallChildWidthMin, smallChildWidthMax, smallCounts, targetMediumChildWidth, mediumCounts, targetLargeChildWidth, largeCounts);
        float extraSmallChildWidth = this.getExtraSmallSize(child.getContext()) + childHorizontalMargins;
        float start = 0.0f;
        float extraSmallHeadCenterX = start - extraSmallChildWidth / 2.0f;
        float largeStartCenterX = start + arrangement.largeSize / 2.0f;
        float largeEndCenterX = largeStartCenterX + (float)Math.max(0, arrangement.largeCount - 1) * arrangement.largeSize;
        start = largeEndCenterX + arrangement.largeSize / 2.0f;
        float mediumCenterX = arrangement.mediumCount > 0 ? start + arrangement.mediumSize / 2.0f : largeEndCenterX;
        start = arrangement.mediumCount > 0 ? mediumCenterX + arrangement.mediumSize / 2.0f : start;
        float smallStartCenterX = arrangement.smallCount > 0 ? start + arrangement.smallSize / 2.0f : mediumCenterX;
        float extraSmallTailCenterX = (float)carousel.getContainerWidth() + extraSmallChildWidth / 2.0f;
        float extraSmallMask = MultiBrowseCarouselStrategy.getChildMaskPercentage(extraSmallChildWidth, arrangement.largeSize, childHorizontalMargins);
        float smallMask = MultiBrowseCarouselStrategy.getChildMaskPercentage(arrangement.smallSize, arrangement.largeSize, childHorizontalMargins);
        float mediumMask = MultiBrowseCarouselStrategy.getChildMaskPercentage(arrangement.mediumSize, arrangement.largeSize, childHorizontalMargins);
        float largeMask = 0.0f;
        KeylineState.Builder builder = new KeylineState.Builder(arrangement.largeSize).addKeyline(extraSmallHeadCenterX, extraSmallMask, extraSmallChildWidth).addKeylineRange(largeStartCenterX, largeMask, arrangement.largeSize, arrangement.largeCount, true);
        if (arrangement.mediumCount > 0) {
            builder.addKeyline(mediumCenterX, mediumMask, arrangement.mediumSize);
        }
        if (arrangement.smallCount > 0) {
            builder.addKeylineRange(smallStartCenterX, smallMask, arrangement.smallSize, arrangement.smallCount);
        }
        builder.addKeyline(extraSmallTailCenterX, extraSmallMask, extraSmallChildWidth);
        return builder.build();
    }

    private static Arrangement findLowestCostArrangement(float availableSpace, float targetSmallSize, float minSmallSize, float maxSmallSize, int[] smallCounts, float targetMediumSize, int[] mediumCounts, float targetLargeSize, int[] largeCounts) {
        Arrangement lowestCostArrangement = null;
        int priority = 1;
        for (int largeCount : largeCounts) {
            for (int mediumCount : mediumCounts) {
                for (int smallCount : smallCounts) {
                    Arrangement arrangement = new Arrangement(priority, targetSmallSize, minSmallSize, maxSmallSize, smallCount, targetMediumSize, mediumCount, targetLargeSize, largeCount, availableSpace);
                    if (lowestCostArrangement == null || arrangement.cost < lowestCostArrangement.cost) {
                        lowestCostArrangement = arrangement;
                        if (lowestCostArrangement.cost == 0.0f) {
                            return lowestCostArrangement;
                        }
                    }
                    ++priority;
                }
            }
        }
        return lowestCostArrangement;
    }

    private static int maxValue(int[] array) {
        int largest = Integer.MIN_VALUE;
        for (int j : array) {
            if (j <= largest) continue;
            largest = j;
        }
        return largest;
    }

    @VisibleForTesting
    static final class Arrangement {
        final int priority;
        float smallSize;
        final int smallCount;
        final int mediumCount;
        float mediumSize;
        float largeSize;
        final int largeCount;
        final float cost;

        Arrangement(int priority, float targetSmallSize, float minSmallSize, float maxSmallSize, int smallCount, float targetMediumSize, int mediumCount, float targetLargeSize, int largeCount, float availableSpace) {
            this.priority = priority;
            this.smallSize = MathUtils.clamp((float)targetSmallSize, (float)minSmallSize, (float)maxSmallSize);
            this.smallCount = smallCount;
            this.mediumSize = targetMediumSize;
            this.mediumCount = mediumCount;
            this.largeSize = targetLargeSize;
            this.largeCount = largeCount;
            this.fit(availableSpace, minSmallSize, maxSmallSize, targetLargeSize);
            this.cost = this.cost(targetLargeSize);
        }

        @NonNull
        public String toString() {
            return "Arrangement [priority=" + this.priority + ", smallCount=" + this.smallCount + ", smallSize=" + this.smallSize + ", mediumCount=" + this.mediumCount + ", mediumSize=" + this.mediumSize + ", largeCount=" + this.largeCount + ", largeSize=" + this.largeSize + ", cost=" + this.cost + "]";
        }

        private float getSpace() {
            return this.largeSize * (float)this.largeCount + this.mediumSize * (float)this.mediumCount + this.smallSize * (float)this.smallCount;
        }

        private void fit(float availableSpace, float minSmallSize, float maxSmallSize, float targetLargeSize) {
            float delta = availableSpace - this.getSpace();
            if (this.smallCount > 0 && delta > 0.0f) {
                this.smallSize += Math.min(delta / (float)this.smallCount, maxSmallSize - this.smallSize);
            } else if (this.smallCount > 0 && delta < 0.0f) {
                this.smallSize += Math.max(delta / (float)this.smallCount, minSmallSize - this.smallSize);
            }
            this.largeSize = this.calculateLargeSize(availableSpace, this.smallCount, this.smallSize, this.mediumCount, this.largeCount);
            this.mediumSize = (this.largeSize + this.smallSize) / 2.0f;
            if (this.mediumCount > 0 && this.largeSize != targetLargeSize) {
                float targetAdjustment = (targetLargeSize - this.largeSize) * (float)this.largeCount;
                float availableMediumFlex = this.mediumSize * 0.1f * (float)this.mediumCount;
                float distribute = Math.min(Math.abs(targetAdjustment), availableMediumFlex);
                if (targetAdjustment > 0.0f) {
                    this.mediumSize -= distribute / (float)this.mediumCount;
                    this.largeSize += distribute / (float)this.largeCount;
                } else {
                    this.mediumSize += distribute / (float)this.mediumCount;
                    this.largeSize -= distribute / (float)this.largeCount;
                }
            }
        }

        private float calculateLargeSize(float availableSpace, int smallCount, float smallSize, int mediumCount, int largeCount) {
            smallSize = smallCount > 0 ? smallSize : 0.0f;
            return (availableSpace - ((float)smallCount + (float)mediumCount / 2.0f) * smallSize) / ((float)largeCount + (float)mediumCount / 2.0f);
        }

        private boolean isValid() {
            if (this.largeCount > 0 && this.smallCount > 0 && this.mediumCount > 0) {
                return this.largeSize > this.mediumSize && this.mediumSize > this.smallSize;
            }
            if (this.largeCount > 0 && this.smallCount > 0) {
                return this.largeSize > this.smallSize;
            }
            return true;
        }

        private float cost(float targetLargeSize) {
            if (!this.isValid()) {
                return Float.MAX_VALUE;
            }
            return Math.abs(targetLargeSize - this.largeSize) * (float)this.priority;
        }
    }
}

