/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.button;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.view.View;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.ripple.RippleDrawableCompat;
import com.google.android.material.ripple.RippleUtils;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.Shapeable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class MaterialButtonHelper {
    @ChecksSdkIntAtLeast(api=21)
    private static final boolean IS_MIN_LOLLIPOP = Build.VERSION.SDK_INT >= 21;
    private static final boolean IS_LOLLIPOP = Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT <= 22;
    private final MaterialButton materialButton;
    @NonNull
    private ShapeAppearanceModel shapeAppearanceModel;
    private int insetLeft;
    private int insetRight;
    private int insetTop;
    private int insetBottom;
    private int cornerRadius;
    private int strokeWidth;
    @Nullable
    private PorterDuff.Mode backgroundTintMode;
    @Nullable
    private ColorStateList backgroundTint;
    @Nullable
    private ColorStateList strokeColor;
    @Nullable
    private ColorStateList rippleColor;
    @Nullable
    private Drawable maskDrawable;
    private boolean shouldDrawSurfaceColorStroke = false;
    private boolean backgroundOverwritten = false;
    private boolean cornerRadiusSet = false;
    private boolean checkable;
    private boolean toggleCheckedStateOnClick = true;
    private LayerDrawable rippleDrawable;
    private int elevation;

    MaterialButtonHelper(MaterialButton button, @NonNull ShapeAppearanceModel shapeAppearanceModel) {
        this.materialButton = button;
        this.shapeAppearanceModel = shapeAppearanceModel;
    }

    void loadFromAttributes(@NonNull TypedArray attributes) {
        this.insetLeft = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_insetLeft, 0);
        this.insetRight = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_insetRight, 0);
        this.insetTop = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_insetTop, 0);
        this.insetBottom = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_insetBottom, 0);
        if (attributes.hasValue(R.styleable.MaterialButton_cornerRadius)) {
            this.cornerRadius = attributes.getDimensionPixelSize(R.styleable.MaterialButton_cornerRadius, -1);
            this.setShapeAppearanceModel(this.shapeAppearanceModel.withCornerSize(this.cornerRadius));
            this.cornerRadiusSet = true;
        }
        this.strokeWidth = attributes.getDimensionPixelSize(R.styleable.MaterialButton_strokeWidth, 0);
        this.backgroundTintMode = ViewUtils.parseTintMode(attributes.getInt(R.styleable.MaterialButton_backgroundTintMode, -1), PorterDuff.Mode.SRC_IN);
        this.backgroundTint = MaterialResources.getColorStateList(this.materialButton.getContext(), attributes, R.styleable.MaterialButton_backgroundTint);
        this.strokeColor = MaterialResources.getColorStateList(this.materialButton.getContext(), attributes, R.styleable.MaterialButton_strokeColor);
        this.rippleColor = MaterialResources.getColorStateList(this.materialButton.getContext(), attributes, R.styleable.MaterialButton_rippleColor);
        this.checkable = attributes.getBoolean(R.styleable.MaterialButton_android_checkable, false);
        this.elevation = attributes.getDimensionPixelSize(R.styleable.MaterialButton_elevation, 0);
        this.toggleCheckedStateOnClick = attributes.getBoolean(R.styleable.MaterialButton_toggleCheckedStateOnClick, true);
        int paddingStart = ViewCompat.getPaddingStart((View)this.materialButton);
        int paddingTop = this.materialButton.getPaddingTop();
        int paddingEnd = ViewCompat.getPaddingEnd((View)this.materialButton);
        int paddingBottom = this.materialButton.getPaddingBottom();
        if (attributes.hasValue(R.styleable.MaterialButton_android_background)) {
            this.setBackgroundOverwritten();
        } else {
            this.updateBackground();
        }
        ViewCompat.setPaddingRelative((View)this.materialButton, (int)(paddingStart + this.insetLeft), (int)(paddingTop + this.insetTop), (int)(paddingEnd + this.insetRight), (int)(paddingBottom + this.insetBottom));
    }

    private void updateBackground() {
        this.materialButton.setInternalBackground(this.createBackground());
        MaterialShapeDrawable materialShapeDrawable = this.getMaterialShapeDrawable();
        if (materialShapeDrawable != null) {
            materialShapeDrawable.setElevation(this.elevation);
            materialShapeDrawable.setState(this.materialButton.getDrawableState());
        }
    }

    void setBackgroundOverwritten() {
        this.backgroundOverwritten = true;
        this.materialButton.setSupportBackgroundTintList(this.backgroundTint);
        this.materialButton.setSupportBackgroundTintMode(this.backgroundTintMode);
    }

    boolean isBackgroundOverwritten() {
        return this.backgroundOverwritten;
    }

    @NonNull
    private InsetDrawable wrapDrawableWithInset(Drawable drawable2) {
        return new InsetDrawable(drawable2, this.insetLeft, this.insetTop, this.insetRight, this.insetBottom);
    }

    void setSupportBackgroundTintList(@Nullable ColorStateList tintList) {
        if (this.backgroundTint != tintList) {
            this.backgroundTint = tintList;
            if (this.getMaterialShapeDrawable() != null) {
                DrawableCompat.setTintList((Drawable)this.getMaterialShapeDrawable(), (ColorStateList)this.backgroundTint);
            }
        }
    }

    ColorStateList getSupportBackgroundTintList() {
        return this.backgroundTint;
    }

    void setSupportBackgroundTintMode(@Nullable PorterDuff.Mode mode) {
        if (this.backgroundTintMode != mode) {
            this.backgroundTintMode = mode;
            if (this.getMaterialShapeDrawable() != null && this.backgroundTintMode != null) {
                DrawableCompat.setTintMode((Drawable)this.getMaterialShapeDrawable(), (PorterDuff.Mode)this.backgroundTintMode);
            }
        }
    }

    PorterDuff.Mode getSupportBackgroundTintMode() {
        return this.backgroundTintMode;
    }

    void setShouldDrawSurfaceColorStroke(boolean shouldDrawSurfaceColorStroke) {
        this.shouldDrawSurfaceColorStroke = shouldDrawSurfaceColorStroke;
        this.updateStroke();
    }

    private Drawable createBackground() {
        MaterialShapeDrawable backgroundDrawable = new MaterialShapeDrawable(this.shapeAppearanceModel);
        Context context = this.materialButton.getContext();
        backgroundDrawable.initializeElevationOverlay(context);
        DrawableCompat.setTintList((Drawable)backgroundDrawable, (ColorStateList)this.backgroundTint);
        if (this.backgroundTintMode != null) {
            DrawableCompat.setTintMode((Drawable)backgroundDrawable, (PorterDuff.Mode)this.backgroundTintMode);
        }
        backgroundDrawable.setStroke((float)this.strokeWidth, this.strokeColor);
        MaterialShapeDrawable surfaceColorStrokeDrawable = new MaterialShapeDrawable(this.shapeAppearanceModel);
        surfaceColorStrokeDrawable.setTint(0);
        surfaceColorStrokeDrawable.setStroke((float)this.strokeWidth, this.shouldDrawSurfaceColorStroke ? MaterialColors.getColor((View)this.materialButton, R.attr.colorSurface) : 0);
        if (IS_MIN_LOLLIPOP) {
            this.maskDrawable = new MaterialShapeDrawable(this.shapeAppearanceModel);
            DrawableCompat.setTint((Drawable)this.maskDrawable, (int)-1);
            this.rippleDrawable = new RippleDrawable(RippleUtils.sanitizeRippleDrawableColor(this.rippleColor), (Drawable)this.wrapDrawableWithInset((Drawable)new LayerDrawable(new Drawable[]{surfaceColorStrokeDrawable, backgroundDrawable})), this.maskDrawable);
            return this.rippleDrawable;
        }
        this.maskDrawable = new RippleDrawableCompat(this.shapeAppearanceModel);
        DrawableCompat.setTintList((Drawable)this.maskDrawable, (ColorStateList)RippleUtils.sanitizeRippleDrawableColor(this.rippleColor));
        this.rippleDrawable = new LayerDrawable(new Drawable[]{surfaceColorStrokeDrawable, backgroundDrawable, this.maskDrawable});
        return this.wrapDrawableWithInset((Drawable)this.rippleDrawable);
    }

    void updateMaskBounds(int height, int width) {
        if (this.maskDrawable != null) {
            this.maskDrawable.setBounds(this.insetLeft, this.insetTop, width - this.insetRight, height - this.insetBottom);
        }
    }

    void setBackgroundColor(int color2) {
        if (this.getMaterialShapeDrawable() != null) {
            this.getMaterialShapeDrawable().setTint(color2);
        }
    }

    void setRippleColor(@Nullable ColorStateList rippleColor) {
        if (this.rippleColor != rippleColor) {
            this.rippleColor = rippleColor;
            if (IS_MIN_LOLLIPOP && this.materialButton.getBackground() instanceof RippleDrawable) {
                ((RippleDrawable)this.materialButton.getBackground()).setColor(RippleUtils.sanitizeRippleDrawableColor(rippleColor));
            } else if (!IS_MIN_LOLLIPOP && this.materialButton.getBackground() instanceof RippleDrawableCompat) {
                ((RippleDrawableCompat)this.materialButton.getBackground()).setTintList(RippleUtils.sanitizeRippleDrawableColor(rippleColor));
            }
        }
    }

    @Nullable
    ColorStateList getRippleColor() {
        return this.rippleColor;
    }

    void setStrokeColor(@Nullable ColorStateList strokeColor) {
        if (this.strokeColor != strokeColor) {
            this.strokeColor = strokeColor;
            this.updateStroke();
        }
    }

    @Nullable
    ColorStateList getStrokeColor() {
        return this.strokeColor;
    }

    void setStrokeWidth(int strokeWidth) {
        if (this.strokeWidth != strokeWidth) {
            this.strokeWidth = strokeWidth;
            this.updateStroke();
        }
    }

    int getStrokeWidth() {
        return this.strokeWidth;
    }

    private void updateStroke() {
        MaterialShapeDrawable materialShapeDrawable = this.getMaterialShapeDrawable();
        MaterialShapeDrawable surfaceColorStrokeDrawable = this.getSurfaceColorStrokeDrawable();
        if (materialShapeDrawable != null) {
            materialShapeDrawable.setStroke((float)this.strokeWidth, this.strokeColor);
            if (surfaceColorStrokeDrawable != null) {
                surfaceColorStrokeDrawable.setStroke((float)this.strokeWidth, this.shouldDrawSurfaceColorStroke ? MaterialColors.getColor((View)this.materialButton, R.attr.colorSurface) : 0);
            }
        }
    }

    void setCornerRadius(int cornerRadius) {
        if (!this.cornerRadiusSet || this.cornerRadius != cornerRadius) {
            this.cornerRadius = cornerRadius;
            this.cornerRadiusSet = true;
            this.setShapeAppearanceModel(this.shapeAppearanceModel.withCornerSize(cornerRadius));
        }
    }

    int getCornerRadius() {
        return this.cornerRadius;
    }

    @Nullable
    private MaterialShapeDrawable getMaterialShapeDrawable(boolean getSurfaceColorStrokeDrawable) {
        if (this.rippleDrawable != null && this.rippleDrawable.getNumberOfLayers() > 0) {
            if (IS_MIN_LOLLIPOP) {
                InsetDrawable insetDrawable = (InsetDrawable)this.rippleDrawable.getDrawable(0);
                LayerDrawable layerDrawable = (LayerDrawable)insetDrawable.getDrawable();
                return (MaterialShapeDrawable)layerDrawable.getDrawable(getSurfaceColorStrokeDrawable ? 0 : 1);
            }
            return (MaterialShapeDrawable)this.rippleDrawable.getDrawable(getSurfaceColorStrokeDrawable ? 0 : 1);
        }
        return null;
    }

    @Nullable
    MaterialShapeDrawable getMaterialShapeDrawable() {
        return this.getMaterialShapeDrawable(false);
    }

    void setCheckable(boolean checkable) {
        this.checkable = checkable;
    }

    boolean isCheckable() {
        return this.checkable;
    }

    boolean isToggleCheckedStateOnClick() {
        return this.toggleCheckedStateOnClick;
    }

    void setToggleCheckedStateOnClick(boolean toggleCheckedStateOnClick) {
        this.toggleCheckedStateOnClick = toggleCheckedStateOnClick;
    }

    @Nullable
    private MaterialShapeDrawable getSurfaceColorStrokeDrawable() {
        return this.getMaterialShapeDrawable(true);
    }

    private void updateButtonShape(@NonNull ShapeAppearanceModel shapeAppearanceModel) {
        if (IS_LOLLIPOP && !this.backgroundOverwritten) {
            int paddingStart = ViewCompat.getPaddingStart((View)this.materialButton);
            int paddingTop = this.materialButton.getPaddingTop();
            int paddingEnd = ViewCompat.getPaddingEnd((View)this.materialButton);
            int paddingBottom = this.materialButton.getPaddingBottom();
            this.updateBackground();
            ViewCompat.setPaddingRelative((View)this.materialButton, (int)paddingStart, (int)paddingTop, (int)paddingEnd, (int)paddingBottom);
        } else {
            if (this.getMaterialShapeDrawable() != null) {
                this.getMaterialShapeDrawable().setShapeAppearanceModel(shapeAppearanceModel);
            }
            if (this.getSurfaceColorStrokeDrawable() != null) {
                this.getSurfaceColorStrokeDrawable().setShapeAppearanceModel(shapeAppearanceModel);
            }
            if (this.getMaskDrawable() != null) {
                this.getMaskDrawable().setShapeAppearanceModel(shapeAppearanceModel);
            }
        }
    }

    @Nullable
    public Shapeable getMaskDrawable() {
        if (this.rippleDrawable != null && this.rippleDrawable.getNumberOfLayers() > 1) {
            if (this.rippleDrawable.getNumberOfLayers() > 2) {
                return (Shapeable)this.rippleDrawable.getDrawable(2);
            }
            return (Shapeable)this.rippleDrawable.getDrawable(1);
        }
        return null;
    }

    void setShapeAppearanceModel(@NonNull ShapeAppearanceModel shapeAppearanceModel) {
        this.shapeAppearanceModel = shapeAppearanceModel;
        this.updateButtonShape(shapeAppearanceModel);
    }

    @NonNull
    ShapeAppearanceModel getShapeAppearanceModel() {
        return this.shapeAppearanceModel;
    }

    public void setInsetBottom(@Dimension int newInsetBottom) {
        this.setVerticalInsets(this.insetTop, newInsetBottom);
    }

    public int getInsetBottom() {
        return this.insetBottom;
    }

    public void setInsetTop(@Dimension int newInsetTop) {
        this.setVerticalInsets(newInsetTop, this.insetBottom);
    }

    private void setVerticalInsets(@Dimension int newInsetTop, @Dimension int newInsetBottom) {
        int paddingStart = ViewCompat.getPaddingStart((View)this.materialButton);
        int paddingTop = this.materialButton.getPaddingTop();
        int paddingEnd = ViewCompat.getPaddingEnd((View)this.materialButton);
        int paddingBottom = this.materialButton.getPaddingBottom();
        int oldInsetTop = this.insetTop;
        int oldInsetBottom = this.insetBottom;
        this.insetBottom = newInsetBottom;
        this.insetTop = newInsetTop;
        if (!this.backgroundOverwritten) {
            this.updateBackground();
        }
        ViewCompat.setPaddingRelative((View)this.materialButton, (int)paddingStart, (int)(paddingTop + newInsetTop - oldInsetTop), (int)paddingEnd, (int)(paddingBottom + newInsetBottom - oldInsetBottom));
    }

    public int getInsetTop() {
        return this.insetTop;
    }
}

