/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.viewsintegration;

import android.os.Build;
import android.text.InputFilter;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.SparseArray;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.util.Preconditions;
import androidx.emoji2.text.EmojiCompat;
import androidx.emoji2.viewsintegration.EmojiInputFilter;
import androidx.emoji2.viewsintegration.EmojiTransformationMethod;

public final class EmojiTextViewHelper {
    private final HelperInternal mHelper;

    public EmojiTextViewHelper(@NonNull TextView textView) {
        this(textView, true);
    }

    public EmojiTextViewHelper(@NonNull TextView textView, boolean expectInitializedEmojiCompat) {
        Preconditions.checkNotNull((Object)textView, (Object)"textView cannot be null");
        this.mHelper = Build.VERSION.SDK_INT < 19 ? new HelperInternal() : (!expectInitializedEmojiCompat ? new SkippingHelper19(textView) : new HelperInternal19(textView));
    }

    public void updateTransformationMethod() {
        this.mHelper.updateTransformationMethod();
    }

    @NonNull
    public InputFilter[] getFilters(@NonNull InputFilter[] filters) {
        return this.mHelper.getFilters(filters);
    }

    @Nullable
    public TransformationMethod wrapTransformationMethod(@Nullable TransformationMethod transformationMethod) {
        return this.mHelper.wrapTransformationMethod(transformationMethod);
    }

    public void setEnabled(boolean enabled) {
        this.mHelper.setEnabled(enabled);
    }

    public void setAllCaps(boolean allCaps) {
        this.mHelper.setAllCaps(allCaps);
    }

    public boolean isEnabled() {
        return this.mHelper.isEnabled();
    }

    static class HelperInternal {
        HelperInternal() {
        }

        void updateTransformationMethod() {
        }

        @NonNull
        InputFilter[] getFilters(@NonNull InputFilter[] filters) {
            return filters;
        }

        @Nullable
        TransformationMethod wrapTransformationMethod(@Nullable TransformationMethod transformationMethod) {
            return transformationMethod;
        }

        void setAllCaps(boolean allCaps) {
        }

        void setEnabled(boolean processEmoji) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    @RequiresApi(value=19)
    private static class SkippingHelper19
    extends HelperInternal {
        private final HelperInternal19 mHelperDelegate;

        SkippingHelper19(TextView textView) {
            this.mHelperDelegate = new HelperInternal19(textView);
        }

        private boolean skipBecauseEmojiCompatNotInitialized() {
            return !EmojiCompat.isConfigured();
        }

        @Override
        void updateTransformationMethod() {
            if (this.skipBecauseEmojiCompatNotInitialized()) {
                return;
            }
            this.mHelperDelegate.updateTransformationMethod();
        }

        @Override
        @NonNull
        InputFilter[] getFilters(@NonNull InputFilter[] filters) {
            if (this.skipBecauseEmojiCompatNotInitialized()) {
                return filters;
            }
            return this.mHelperDelegate.getFilters(filters);
        }

        @Override
        @Nullable
        TransformationMethod wrapTransformationMethod(@Nullable TransformationMethod transformationMethod) {
            if (this.skipBecauseEmojiCompatNotInitialized()) {
                return transformationMethod;
            }
            return this.mHelperDelegate.wrapTransformationMethod(transformationMethod);
        }

        @Override
        void setAllCaps(boolean allCaps) {
            if (this.skipBecauseEmojiCompatNotInitialized()) {
                return;
            }
            this.mHelperDelegate.setAllCaps(allCaps);
        }

        @Override
        void setEnabled(boolean processEmoji) {
            if (this.skipBecauseEmojiCompatNotInitialized()) {
                this.mHelperDelegate.setEnabledUnsafe(processEmoji);
            } else {
                this.mHelperDelegate.setEnabled(processEmoji);
            }
        }

        @Override
        public boolean isEnabled() {
            return this.mHelperDelegate.isEnabled();
        }
    }

    @RequiresApi(value=19)
    private static class HelperInternal19
    extends HelperInternal {
        private final TextView mTextView;
        private final EmojiInputFilter mEmojiInputFilter;
        private boolean mEnabled;

        HelperInternal19(TextView textView) {
            this.mTextView = textView;
            this.mEnabled = true;
            this.mEmojiInputFilter = new EmojiInputFilter(textView);
        }

        @Override
        void updateTransformationMethod() {
            TransformationMethod tm = this.wrapTransformationMethod(this.mTextView.getTransformationMethod());
            this.mTextView.setTransformationMethod(tm);
        }

        private void updateFilters() {
            InputFilter[] oldFilters = this.mTextView.getFilters();
            this.mTextView.setFilters(this.getFilters(oldFilters));
        }

        @Override
        @NonNull
        InputFilter[] getFilters(@NonNull InputFilter[] filters) {
            if (!this.mEnabled) {
                return this.removeEmojiInputFilterIfPresent(filters);
            }
            return this.addEmojiInputFilterIfMissing(filters);
        }

        @NonNull
        private InputFilter[] addEmojiInputFilterIfMissing(@NonNull InputFilter[] filters) {
            int count = filters.length;
            for (int i = 0; i < count; ++i) {
                if (filters[i] != this.mEmojiInputFilter) continue;
                return filters;
            }
            InputFilter[] newFilters = new InputFilter[filters.length + 1];
            System.arraycopy(filters, 0, newFilters, 0, count);
            newFilters[count] = this.mEmojiInputFilter;
            return newFilters;
        }

        @NonNull
        private InputFilter[] removeEmojiInputFilterIfPresent(@NonNull InputFilter[] filters) {
            SparseArray<InputFilter> filterSet = this.getEmojiInputFilterPositionArray(filters);
            if (filterSet.size() == 0) {
                return filters;
            }
            int inCount = filters.length;
            int outCount = filters.length - filterSet.size();
            InputFilter[] result = new InputFilter[outCount];
            int destPosition = 0;
            for (int srcPosition = 0; srcPosition < inCount; ++srcPosition) {
                if (filterSet.indexOfKey(srcPosition) >= 0) continue;
                result[destPosition] = filters[srcPosition];
                ++destPosition;
            }
            return result;
        }

        private SparseArray<InputFilter> getEmojiInputFilterPositionArray(@NonNull InputFilter[] filters) {
            SparseArray result = new SparseArray(1);
            for (int pos = 0; pos < filters.length; ++pos) {
                if (!(filters[pos] instanceof EmojiInputFilter)) continue;
                result.put(pos, (Object)filters[pos]);
            }
            return result;
        }

        @Override
        @Nullable
        TransformationMethod wrapTransformationMethod(@Nullable TransformationMethod transformationMethod) {
            if (this.mEnabled) {
                return this.wrapForEnabled(transformationMethod);
            }
            return this.unwrapForDisabled(transformationMethod);
        }

        @Nullable
        private TransformationMethod unwrapForDisabled(@Nullable TransformationMethod transformationMethod) {
            if (transformationMethod instanceof EmojiTransformationMethod) {
                EmojiTransformationMethod etm = (EmojiTransformationMethod)transformationMethod;
                return etm.getOriginalTransformationMethod();
            }
            return transformationMethod;
        }

        @NonNull
        private TransformationMethod wrapForEnabled(@Nullable TransformationMethod transformationMethod) {
            if (transformationMethod instanceof EmojiTransformationMethod) {
                return transformationMethod;
            }
            if (transformationMethod instanceof PasswordTransformationMethod) {
                return transformationMethod;
            }
            return new EmojiTransformationMethod(transformationMethod);
        }

        @Override
        void setAllCaps(boolean allCaps) {
            if (allCaps) {
                this.updateTransformationMethod();
            }
        }

        @Override
        void setEnabled(boolean enabled) {
            this.mEnabled = enabled;
            this.updateTransformationMethod();
            this.updateFilters();
        }

        @Override
        public boolean isEnabled() {
            return this.mEnabled;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        void setEnabledUnsafe(boolean processEmoji) {
            this.mEnabled = processEmoji;
        }
    }
}

