/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.R;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentContainerView;
import androidx.fragment.app.FragmentFactory;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStateManager;
import androidx.fragment.app.SpecialEffectsController;
import androidx.fragment.app.strictmode.FragmentStrictMode;

class FragmentLayoutInflaterFactory
implements LayoutInflater.Factory2 {
    private static final String TAG = "FragmentManager";
    final FragmentManager mFragmentManager;

    FragmentLayoutInflaterFactory(FragmentManager fragmentManager) {
        this.mFragmentManager = fragmentManager;
    }

    @Nullable
    public View onCreateView(@NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        return this.onCreateView(null, name, context, attrs);
    }

    @Nullable
    public View onCreateView(@Nullable View parent, @NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        FragmentStateManager fragmentStateManager;
        Fragment fragment;
        int containerId;
        if (FragmentContainerView.class.getName().equals(name)) {
            return new FragmentContainerView(context, attrs, this.mFragmentManager);
        }
        if (!"fragment".equals(name)) {
            return null;
        }
        String fname = attrs.getAttributeValue(null, "class");
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Fragment);
        if (fname == null) {
            fname = a.getString(R.styleable.Fragment_android_name);
        }
        int id2 = a.getResourceId(R.styleable.Fragment_android_id, -1);
        String tag = a.getString(R.styleable.Fragment_android_tag);
        a.recycle();
        if (fname == null || !FragmentFactory.isFragmentClass(context.getClassLoader(), fname)) {
            return null;
        }
        int n = containerId = parent != null ? parent.getId() : 0;
        if (containerId == -1 && id2 == -1 && tag == null) {
            throw new IllegalArgumentException(attrs.getPositionDescription() + ": Must specify unique android:id, android:tag, or have a parent with an id for " + fname);
        }
        Fragment fragment2 = fragment = id2 != -1 ? this.mFragmentManager.findFragmentById(id2) : null;
        if (fragment == null && tag != null) {
            fragment = this.mFragmentManager.findFragmentByTag(tag);
        }
        if (fragment == null && containerId != -1) {
            fragment = this.mFragmentManager.findFragmentById(containerId);
        }
        if (fragment == null) {
            fragment = this.mFragmentManager.getFragmentFactory().instantiate(context.getClassLoader(), fname);
            fragment.mFromLayout = true;
            fragment.mFragmentId = id2 != 0 ? id2 : containerId;
            fragment.mContainerId = containerId;
            fragment.mTag = tag;
            fragment.mInLayout = true;
            fragment.mFragmentManager = this.mFragmentManager;
            fragment.mHost = this.mFragmentManager.getHost();
            fragment.onInflate(this.mFragmentManager.getHost().getContext(), attrs, fragment.mSavedFragmentState);
            fragmentStateManager = this.mFragmentManager.addFragment(fragment);
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)("Fragment " + fragment + " has been inflated via the <fragment> tag: id=0x" + Integer.toHexString(id2)));
            }
        } else {
            if (fragment.mInLayout) {
                throw new IllegalArgumentException(attrs.getPositionDescription() + ": Duplicate id 0x" + Integer.toHexString(id2) + ", tag " + tag + ", or parent id 0x" + Integer.toHexString(containerId) + " with another fragment for " + fname);
            }
            fragment.mInLayout = true;
            fragment.mFragmentManager = this.mFragmentManager;
            fragment.mHost = this.mFragmentManager.getHost();
            fragment.onInflate(this.mFragmentManager.getHost().getContext(), attrs, fragment.mSavedFragmentState);
            fragmentStateManager = this.mFragmentManager.createOrGetFragmentStateManager(fragment);
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)("Retained Fragment " + fragment + " has been re-attached via the <fragment> tag: id=0x" + Integer.toHexString(id2)));
            }
        }
        FragmentStrictMode.onFragmentTagUsage(fragment, (ViewGroup)parent);
        fragment.mContainer = (ViewGroup)parent;
        fragmentStateManager.moveToExpectedState();
        fragmentStateManager.ensureInflatedView();
        if (fragment.mView == null) {
            throw new IllegalStateException("Fragment " + fname + " did not create a view.");
        }
        if (id2 != 0) {
            fragment.mView.setId(id2);
        }
        if (fragment.mView.getTag() == null) {
            fragment.mView.setTag((Object)tag);
        }
        fragment.mView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                Fragment fragment = fragmentStateManager.getFragment();
                fragmentStateManager.moveToExpectedState();
                SpecialEffectsController controller = SpecialEffectsController.getOrCreateController((ViewGroup)fragment.mView.getParent(), FragmentLayoutInflaterFactory.this.mFragmentManager);
                controller.forceCompleteAllOperations();
            }

            public void onViewDetachedFromWindow(View v) {
            }
        });
        return fragment.mView;
    }
}

