/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.Observable;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.Display;
import android.view.FocusFinder;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Interpolator;
import android.widget.EdgeEffect;
import android.widget.OverScroller;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.os.TraceCompat;
import androidx.core.util.Preconditions;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.MotionEventCompat;
import androidx.core.view.NestedScrollingChild2;
import androidx.core.view.NestedScrollingChild3;
import androidx.core.view.NestedScrollingChildHelper;
import androidx.core.view.ScrollingView;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewConfigurationCompat;
import androidx.core.view.accessibility.AccessibilityEventCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.EdgeEffectCompat;
import androidx.customview.poolingcontainer.PoolingContainer;
import androidx.customview.view.AbsSavedState;
import androidx.recyclerview.R;
import androidx.recyclerview.widget.AdapterHelper;
import androidx.recyclerview.widget.ChildHelper;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.FastScroller;
import androidx.recyclerview.widget.GapWorker;
import androidx.recyclerview.widget.RecyclerViewAccessibilityDelegate;
import androidx.recyclerview.widget.ViewBoundsCheck;
import androidx.recyclerview.widget.ViewInfoStore;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

public class RecyclerView
extends ViewGroup
implements ScrollingView,
NestedScrollingChild2,
NestedScrollingChild3 {
    static final String TAG = "RecyclerView";
    static final boolean DEBUG = false;
    static final boolean VERBOSE_TRACING = false;
    private static final int[] NESTED_SCROLLING_ATTRS = new int[]{16843830};
    private static final float SCROLL_FRICTION = 0.015f;
    private static final float INFLEXION = 0.35f;
    private static final float DECELERATION_RATE = (float)(Math.log(0.78) / Math.log(0.9));
    private final float mPhysicalCoef;
    static final boolean FORCE_INVALIDATE_DISPLAY_LIST = Build.VERSION.SDK_INT == 18 || Build.VERSION.SDK_INT == 19 || Build.VERSION.SDK_INT == 20;
    static final boolean ALLOW_SIZE_IN_UNSPECIFIED_SPEC = Build.VERSION.SDK_INT >= 23;
    static final boolean POST_UPDATES_ON_ANIMATION = Build.VERSION.SDK_INT >= 16;
    static final boolean ALLOW_THREAD_GAP_WORK = Build.VERSION.SDK_INT >= 21;
    private static final boolean FORCE_ABS_FOCUS_SEARCH_DIRECTION = Build.VERSION.SDK_INT <= 15;
    private static final boolean IGNORE_DETACHED_FOCUSED_CHILD = Build.VERSION.SDK_INT <= 15;
    private static final float FLING_DESTRETCH_FACTOR = 4.0f;
    static final boolean DISPATCH_TEMP_DETACH = false;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    static final int DEFAULT_ORIENTATION = 1;
    public static final int NO_POSITION = -1;
    public static final long NO_ID = -1L;
    public static final int INVALID_TYPE = -1;
    public static final int TOUCH_SLOP_DEFAULT = 0;
    public static final int TOUCH_SLOP_PAGING = 1;
    public static final int UNDEFINED_DURATION = Integer.MIN_VALUE;
    static final int MAX_SCROLL_DURATION = 2000;
    static final String TRACE_SCROLL_TAG = "RV Scroll";
    private static final String TRACE_ON_LAYOUT_TAG = "RV OnLayout";
    private static final String TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG = "RV FullInvalidate";
    private static final String TRACE_HANDLE_ADAPTER_UPDATES_TAG = "RV PartialInvalidate";
    static final String TRACE_BIND_VIEW_TAG = "RV OnBindView";
    static final String TRACE_PREFETCH_TAG = "RV Prefetch";
    static final String TRACE_NESTED_PREFETCH_TAG = "RV Nested Prefetch";
    static final String TRACE_CREATE_VIEW_TAG = "RV CreateView";
    private static final Class<?>[] LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class, AttributeSet.class, Integer.TYPE, Integer.TYPE};
    private final RecyclerViewDataObserver mObserver = new RecyclerViewDataObserver();
    final Recycler mRecycler = new Recycler();
    SavedState mPendingSavedState;
    AdapterHelper mAdapterHelper;
    ChildHelper mChildHelper;
    final ViewInfoStore mViewInfoStore = new ViewInfoStore();
    boolean mClipToPadding;
    final Runnable mUpdateChildViewsRunnable = new Runnable(){

        @Override
        public void run() {
            if (!RecyclerView.this.mFirstLayoutComplete || RecyclerView.this.isLayoutRequested()) {
                return;
            }
            if (!RecyclerView.this.mIsAttached) {
                RecyclerView.this.requestLayout();
                return;
            }
            if (RecyclerView.this.mLayoutSuppressed) {
                RecyclerView.this.mLayoutWasDefered = true;
                return;
            }
            RecyclerView.this.consumePendingUpdateOperations();
        }
    };
    final Rect mTempRect = new Rect();
    private final Rect mTempRect2 = new Rect();
    final RectF mTempRectF = new RectF();
    Adapter mAdapter;
    @VisibleForTesting
    LayoutManager mLayout;
    RecyclerListener mRecyclerListener;
    final List<RecyclerListener> mRecyclerListeners = new ArrayList<RecyclerListener>();
    final ArrayList<ItemDecoration> mItemDecorations = new ArrayList();
    private final ArrayList<OnItemTouchListener> mOnItemTouchListeners = new ArrayList();
    private OnItemTouchListener mInterceptingOnItemTouchListener;
    boolean mIsAttached;
    boolean mHasFixedSize;
    boolean mEnableFastScroller;
    @VisibleForTesting
    boolean mFirstLayoutComplete;
    private int mInterceptRequestLayoutDepth = 0;
    boolean mLayoutWasDefered;
    boolean mLayoutSuppressed;
    private boolean mIgnoreMotionEventTillDown;
    private int mEatenAccessibilityChangeFlags;
    boolean mAdapterUpdateDuringMeasure;
    private final AccessibilityManager mAccessibilityManager;
    private List<OnChildAttachStateChangeListener> mOnChildAttachStateListeners;
    boolean mDataSetHasChangedAfterLayout = false;
    boolean mDispatchItemsChangedEvent = false;
    private int mLayoutOrScrollCounter = 0;
    private int mDispatchScrollCounter = 0;
    @NonNull
    private EdgeEffectFactory mEdgeEffectFactory = sDefaultEdgeEffectFactory;
    private EdgeEffect mLeftGlow;
    private EdgeEffect mTopGlow;
    private EdgeEffect mRightGlow;
    private EdgeEffect mBottomGlow;
    ItemAnimator mItemAnimator = new DefaultItemAnimator();
    private static final int INVALID_POINTER = -1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    static final long FOREVER_NS = Long.MAX_VALUE;
    private int mScrollState = 0;
    private int mScrollPointerId = -1;
    private VelocityTracker mVelocityTracker;
    private int mInitialTouchX;
    private int mInitialTouchY;
    private int mLastTouchX;
    private int mLastTouchY;
    private int mTouchSlop;
    private OnFlingListener mOnFlingListener;
    private final int mMinFlingVelocity;
    private final int mMaxFlingVelocity;
    private float mScaledHorizontalScrollFactor = Float.MIN_VALUE;
    private float mScaledVerticalScrollFactor = Float.MIN_VALUE;
    private boolean mPreserveFocusAfterLayout = true;
    final ViewFlinger mViewFlinger = new ViewFlinger();
    GapWorker mGapWorker;
    GapWorker.LayoutPrefetchRegistryImpl mPrefetchRegistry = ALLOW_THREAD_GAP_WORK ? new GapWorker.LayoutPrefetchRegistryImpl() : null;
    final State mState = new State();
    private OnScrollListener mScrollListener;
    private List<OnScrollListener> mScrollListeners;
    boolean mItemsAddedOrRemoved = false;
    boolean mItemsChanged = false;
    private ItemAnimator.ItemAnimatorListener mItemAnimatorListener = new ItemAnimatorRestoreListener();
    boolean mPostedAnimatorRunner = false;
    RecyclerViewAccessibilityDelegate mAccessibilityDelegate;
    private ChildDrawingOrderCallback mChildDrawingOrderCallback;
    private final int[] mMinMaxLayoutPositions = new int[2];
    private NestedScrollingChildHelper mScrollingChildHelper;
    private final int[] mScrollOffset = new int[2];
    private final int[] mNestedOffsets = new int[2];
    final int[] mReusableIntPair = new int[2];
    @VisibleForTesting
    final List<ViewHolder> mPendingAccessibilityImportanceChange = new ArrayList<ViewHolder>();
    private Runnable mItemAnimatorRunner = new Runnable(){

        @Override
        public void run() {
            if (RecyclerView.this.mItemAnimator != null) {
                RecyclerView.this.mItemAnimator.runPendingAnimations();
            }
            RecyclerView.this.mPostedAnimatorRunner = false;
        }
    };
    static final Interpolator sQuinticInterpolator = new Interpolator(){

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t * t * t + 1.0f;
        }
    };
    static final StretchEdgeEffectFactory sDefaultEdgeEffectFactory = new StretchEdgeEffectFactory();
    private boolean mLastAutoMeasureSkippedDueToExact;
    private int mLastAutoMeasureNonExactMeasuredWidth = 0;
    private int mLastAutoMeasureNonExactMeasuredHeight = 0;
    private final ViewInfoStore.ProcessCallback mViewInfoProcessCallback = new ViewInfoStore.ProcessCallback(){

        @Override
        public void processDisappeared(ViewHolder viewHolder, @NonNull ItemAnimator.ItemHolderInfo info, @Nullable ItemAnimator.ItemHolderInfo postInfo) {
            RecyclerView.this.mRecycler.unscrapView(viewHolder);
            RecyclerView.this.animateDisappearance(viewHolder, info, postInfo);
        }

        @Override
        public void processAppeared(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo preInfo, ItemAnimator.ItemHolderInfo info) {
            RecyclerView.this.animateAppearance(viewHolder, preInfo, info);
        }

        @Override
        public void processPersistent(ViewHolder viewHolder, @NonNull ItemAnimator.ItemHolderInfo preInfo, @NonNull ItemAnimator.ItemHolderInfo postInfo) {
            viewHolder.setIsRecyclable(false);
            if (RecyclerView.this.mDataSetHasChangedAfterLayout) {
                if (RecyclerView.this.mItemAnimator.animateChange(viewHolder, viewHolder, preInfo, postInfo)) {
                    RecyclerView.this.postAnimationRunner();
                }
            } else if (RecyclerView.this.mItemAnimator.animatePersistence(viewHolder, preInfo, postInfo)) {
                RecyclerView.this.postAnimationRunner();
            }
        }

        @Override
        public void unused(ViewHolder viewHolder) {
            RecyclerView.this.mLayout.removeAndRecycleView(viewHolder.itemView, RecyclerView.this.mRecycler);
        }
    };

    public RecyclerView(@NonNull Context context) {
        this(context, null);
    }

    public RecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.recyclerViewStyle);
    }

    public RecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setScrollContainer(true);
        this.setFocusableInTouchMode(true);
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.mTouchSlop = vc.getScaledTouchSlop();
        this.mScaledHorizontalScrollFactor = ViewConfigurationCompat.getScaledHorizontalScrollFactor((ViewConfiguration)vc, (Context)context);
        this.mScaledVerticalScrollFactor = ViewConfigurationCompat.getScaledVerticalScrollFactor((ViewConfiguration)vc, (Context)context);
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        float ppi = context.getResources().getDisplayMetrics().density * 160.0f;
        this.mPhysicalCoef = 386.0878f * ppi * 0.84f;
        this.setWillNotDraw(this.getOverScrollMode() == 2);
        this.mItemAnimator.setListener(this.mItemAnimatorListener);
        this.initAdapterManager();
        this.initChildrenHelper();
        this.initAutofill();
        if (ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, (int)1);
        }
        this.mAccessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        this.setAccessibilityDelegateCompat(new RecyclerViewAccessibilityDelegate(this));
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RecyclerView, defStyleAttr, 0);
        ViewCompat.saveAttributeDataForStyleable((View)this, (Context)context, (int[])R.styleable.RecyclerView, (AttributeSet)attrs, (TypedArray)a, (int)defStyleAttr, (int)0);
        String layoutManagerName = a.getString(R.styleable.RecyclerView_layoutManager);
        int descendantFocusability = a.getInt(R.styleable.RecyclerView_android_descendantFocusability, -1);
        if (descendantFocusability == -1) {
            this.setDescendantFocusability(262144);
        }
        this.mClipToPadding = a.getBoolean(R.styleable.RecyclerView_android_clipToPadding, true);
        this.mEnableFastScroller = a.getBoolean(R.styleable.RecyclerView_fastScrollEnabled, false);
        if (this.mEnableFastScroller) {
            StateListDrawable verticalThumbDrawable = (StateListDrawable)a.getDrawable(R.styleable.RecyclerView_fastScrollVerticalThumbDrawable);
            Drawable verticalTrackDrawable = a.getDrawable(R.styleable.RecyclerView_fastScrollVerticalTrackDrawable);
            StateListDrawable horizontalThumbDrawable = (StateListDrawable)a.getDrawable(R.styleable.RecyclerView_fastScrollHorizontalThumbDrawable);
            Drawable horizontalTrackDrawable = a.getDrawable(R.styleable.RecyclerView_fastScrollHorizontalTrackDrawable);
            this.initFastScroller(verticalThumbDrawable, verticalTrackDrawable, horizontalThumbDrawable, horizontalTrackDrawable);
        }
        a.recycle();
        this.createLayoutManager(context, layoutManagerName, attrs, defStyleAttr, 0);
        boolean nestedScrollingEnabled = true;
        if (Build.VERSION.SDK_INT >= 21) {
            a = context.obtainStyledAttributes(attrs, NESTED_SCROLLING_ATTRS, defStyleAttr, 0);
            ViewCompat.saveAttributeDataForStyleable((View)this, (Context)context, (int[])NESTED_SCROLLING_ATTRS, (AttributeSet)attrs, (TypedArray)a, (int)defStyleAttr, (int)0);
            nestedScrollingEnabled = a.getBoolean(0, true);
            a.recycle();
        }
        this.setNestedScrollingEnabled(nestedScrollingEnabled);
        PoolingContainer.setPoolingContainer((View)this, (boolean)true);
    }

    String exceptionLabel() {
        return " " + super.toString() + ", adapter:" + this.mAdapter + ", layout:" + this.mLayout + ", context:" + this.getContext();
    }

    @SuppressLint(value={"InlinedApi"})
    private void initAutofill() {
        if (ViewCompat.getImportantForAutofill((View)this) == 0) {
            ViewCompat.setImportantForAutofill((View)this, (int)8);
        }
    }

    @Nullable
    public RecyclerViewAccessibilityDelegate getCompatAccessibilityDelegate() {
        return this.mAccessibilityDelegate;
    }

    public void setAccessibilityDelegateCompat(@Nullable RecyclerViewAccessibilityDelegate accessibilityDelegate) {
        this.mAccessibilityDelegate = accessibilityDelegate;
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)this.mAccessibilityDelegate);
    }

    public CharSequence getAccessibilityClassName() {
        return "androidx.recyclerview.widget.RecyclerView";
    }

    private void createLayoutManager(Context context, String className, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (className != null && !(className = className.trim()).isEmpty()) {
            className = this.getFullClassName(context, className);
            try {
                Constructor<LayoutManager> constructor;
                ClassLoader classLoader = this.isInEditMode() ? ((Object)((Object)this)).getClass().getClassLoader() : context.getClassLoader();
                Class<LayoutManager> layoutManagerClass = Class.forName(className, false, classLoader).asSubclass(LayoutManager.class);
                Object[] constructorArgs = null;
                try {
                    constructor = layoutManagerClass.getConstructor(LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE);
                    constructorArgs = new Object[]{context, attrs, defStyleAttr, defStyleRes};
                }
                catch (NoSuchMethodException e) {
                    try {
                        constructor = layoutManagerClass.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        e1.initCause(e);
                        throw new IllegalStateException(attrs.getPositionDescription() + ": Error creating LayoutManager " + className, e1);
                    }
                }
                constructor.setAccessible(true);
                this.setLayoutManager(constructor.newInstance(constructorArgs));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Unable to find LayoutManager " + className, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Could not instantiate the LayoutManager: " + className, e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Could not instantiate the LayoutManager: " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Cannot access non-public constructor " + className, e);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Class is not a LayoutManager " + className, e);
            }
        }
    }

    private String getFullClassName(Context context, String className) {
        if (className.charAt(0) == '.') {
            return context.getPackageName() + className;
        }
        if (className.contains(".")) {
            return className;
        }
        return RecyclerView.class.getPackage().getName() + '.' + className;
    }

    private void initChildrenHelper() {
        this.mChildHelper = new ChildHelper(new ChildHelper.Callback(){

            @Override
            public int getChildCount() {
                return RecyclerView.this.getChildCount();
            }

            @Override
            public void addView(View child, int index) {
                RecyclerView.this.addView(child, index);
                RecyclerView.this.dispatchChildAttached(child);
            }

            @Override
            public int indexOfChild(View view) {
                return RecyclerView.this.indexOfChild(view);
            }

            @Override
            public void removeViewAt(int index) {
                View child = RecyclerView.this.getChildAt(index);
                if (child != null) {
                    RecyclerView.this.dispatchChildDetached(child);
                    child.clearAnimation();
                }
                RecyclerView.this.removeViewAt(index);
            }

            @Override
            public View getChildAt(int offset) {
                return RecyclerView.this.getChildAt(offset);
            }

            @Override
            public void removeAllViews() {
                int count = this.getChildCount();
                for (int i = 0; i < count; ++i) {
                    View child = this.getChildAt(i);
                    RecyclerView.this.dispatchChildDetached(child);
                    child.clearAnimation();
                }
                RecyclerView.this.removeAllViews();
            }

            @Override
            public ViewHolder getChildViewHolder(View view) {
                return RecyclerView.getChildViewHolderInt(view);
            }

            @Override
            public void attachViewToParent(View child, int index, ViewGroup.LayoutParams layoutParams) {
                ViewHolder vh = RecyclerView.getChildViewHolderInt(child);
                if (vh != null) {
                    if (!vh.isTmpDetached() && !vh.shouldIgnore()) {
                        throw new IllegalArgumentException("Called attach on a child which is not detached: " + vh + RecyclerView.this.exceptionLabel());
                    }
                    vh.clearTmpDetachFlag();
                }
                RecyclerView.this.attachViewToParent(child, index, layoutParams);
            }

            @Override
            public void detachViewFromParent(int offset) {
                ViewHolder vh;
                View view = this.getChildAt(offset);
                if (view != null && (vh = RecyclerView.getChildViewHolderInt(view)) != null) {
                    if (vh.isTmpDetached() && !vh.shouldIgnore()) {
                        throw new IllegalArgumentException("called detach on an already detached child " + vh + RecyclerView.this.exceptionLabel());
                    }
                    vh.addFlags(256);
                }
                RecyclerView.this.detachViewFromParent(offset);
            }

            @Override
            public void onEnteredHiddenState(View child) {
                ViewHolder vh = RecyclerView.getChildViewHolderInt(child);
                if (vh != null) {
                    vh.onEnteredHiddenState(RecyclerView.this);
                }
            }

            @Override
            public void onLeftHiddenState(View child) {
                ViewHolder vh = RecyclerView.getChildViewHolderInt(child);
                if (vh != null) {
                    vh.onLeftHiddenState(RecyclerView.this);
                }
            }
        });
    }

    void initAdapterManager() {
        this.mAdapterHelper = new AdapterHelper(new AdapterHelper.Callback(){

            @Override
            public ViewHolder findViewHolder(int position) {
                ViewHolder vh = RecyclerView.this.findViewHolderForPosition(position, true);
                if (vh == null) {
                    return null;
                }
                if (RecyclerView.this.mChildHelper.isHidden(vh.itemView)) {
                    return null;
                }
                return vh;
            }

            @Override
            public void offsetPositionsForRemovingInvisible(int start, int count) {
                RecyclerView.this.offsetPositionRecordsForRemove(start, count, true);
                RecyclerView.this.mItemsAddedOrRemoved = true;
                RecyclerView.this.mState.mDeletedInvisibleItemCountSincePreviousLayout += count;
            }

            @Override
            public void offsetPositionsForRemovingLaidOutOrNewView(int positionStart, int itemCount) {
                RecyclerView.this.offsetPositionRecordsForRemove(positionStart, itemCount, false);
                RecyclerView.this.mItemsAddedOrRemoved = true;
            }

            @Override
            public void markViewHoldersUpdated(int positionStart, int itemCount, Object payload) {
                RecyclerView.this.viewRangeUpdate(positionStart, itemCount, payload);
                RecyclerView.this.mItemsChanged = true;
            }

            @Override
            public void onDispatchFirstPass(AdapterHelper.UpdateOp op) {
                this.dispatchUpdate(op);
            }

            void dispatchUpdate(AdapterHelper.UpdateOp op) {
                switch (op.cmd) {
                    case 1: {
                        RecyclerView.this.mLayout.onItemsAdded(RecyclerView.this, op.positionStart, op.itemCount);
                        break;
                    }
                    case 2: {
                        RecyclerView.this.mLayout.onItemsRemoved(RecyclerView.this, op.positionStart, op.itemCount);
                        break;
                    }
                    case 4: {
                        RecyclerView.this.mLayout.onItemsUpdated(RecyclerView.this, op.positionStart, op.itemCount, op.payload);
                        break;
                    }
                    case 8: {
                        RecyclerView.this.mLayout.onItemsMoved(RecyclerView.this, op.positionStart, op.itemCount, 1);
                    }
                }
            }

            @Override
            public void onDispatchSecondPass(AdapterHelper.UpdateOp op) {
                this.dispatchUpdate(op);
            }

            @Override
            public void offsetPositionsForAdd(int positionStart, int itemCount) {
                RecyclerView.this.offsetPositionRecordsForInsert(positionStart, itemCount);
                RecyclerView.this.mItemsAddedOrRemoved = true;
            }

            @Override
            public void offsetPositionsForMove(int from, int to) {
                RecyclerView.this.offsetPositionRecordsForMove(from, to);
                RecyclerView.this.mItemsAddedOrRemoved = true;
            }
        });
    }

    public void setHasFixedSize(boolean hasFixedSize) {
        this.mHasFixedSize = hasFixedSize;
    }

    public boolean hasFixedSize() {
        return this.mHasFixedSize;
    }

    public void setClipToPadding(boolean clipToPadding) {
        if (clipToPadding != this.mClipToPadding) {
            this.invalidateGlows();
        }
        this.mClipToPadding = clipToPadding;
        super.setClipToPadding(clipToPadding);
        if (this.mFirstLayoutComplete) {
            this.requestLayout();
        }
    }

    public boolean getClipToPadding() {
        return this.mClipToPadding;
    }

    public void setScrollingTouchSlop(int slopConstant) {
        ViewConfiguration vc = ViewConfiguration.get((Context)this.getContext());
        switch (slopConstant) {
            default: {
                Log.w((String)TAG, (String)("setScrollingTouchSlop(): bad argument constant " + slopConstant + "; using default value"));
            }
            case 0: {
                this.mTouchSlop = vc.getScaledTouchSlop();
                break;
            }
            case 1: {
                this.mTouchSlop = vc.getScaledPagingTouchSlop();
            }
        }
    }

    public void swapAdapter(@Nullable Adapter adapter, boolean removeAndRecycleExistingViews) {
        this.setLayoutFrozen(false);
        this.setAdapterInternal(adapter, true, removeAndRecycleExistingViews);
        this.processDataSetCompletelyChanged(true);
        this.requestLayout();
    }

    public void setAdapter(@Nullable Adapter adapter) {
        this.setLayoutFrozen(false);
        this.setAdapterInternal(adapter, false, true);
        this.processDataSetCompletelyChanged(false);
        this.requestLayout();
    }

    void removeAndRecycleViews() {
        if (this.mItemAnimator != null) {
            this.mItemAnimator.endAnimations();
        }
        if (this.mLayout != null) {
            this.mLayout.removeAndRecycleAllViews(this.mRecycler);
            this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
        }
        this.mRecycler.clear();
    }

    private void setAdapterInternal(@Nullable Adapter<?> adapter, boolean compatibleWithPrevious, boolean removeAndRecycleViews) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterAdapterDataObserver(this.mObserver);
            this.mAdapter.onDetachedFromRecyclerView(this);
        }
        if (!compatibleWithPrevious || removeAndRecycleViews) {
            this.removeAndRecycleViews();
        }
        this.mAdapterHelper.reset();
        Adapter oldAdapter = this.mAdapter;
        this.mAdapter = adapter;
        if (adapter != null) {
            adapter.registerAdapterDataObserver(this.mObserver);
            adapter.onAttachedToRecyclerView(this);
        }
        if (this.mLayout != null) {
            this.mLayout.onAdapterChanged(oldAdapter, this.mAdapter);
        }
        this.mRecycler.onAdapterChanged(oldAdapter, this.mAdapter, compatibleWithPrevious);
        this.mState.mStructureChanged = true;
    }

    @Nullable
    public Adapter getAdapter() {
        return this.mAdapter;
    }

    @Deprecated
    public void setRecyclerListener(@Nullable RecyclerListener listener) {
        this.mRecyclerListener = listener;
    }

    public void addRecyclerListener(@NonNull RecyclerListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"'listener' arg cannot be null.");
        this.mRecyclerListeners.add(listener);
    }

    public void removeRecyclerListener(@NonNull RecyclerListener listener) {
        this.mRecyclerListeners.remove(listener);
    }

    public int getBaseline() {
        if (this.mLayout != null) {
            return this.mLayout.getBaseline();
        }
        return super.getBaseline();
    }

    public void addOnChildAttachStateChangeListener(@NonNull OnChildAttachStateChangeListener listener) {
        if (this.mOnChildAttachStateListeners == null) {
            this.mOnChildAttachStateListeners = new ArrayList<OnChildAttachStateChangeListener>();
        }
        this.mOnChildAttachStateListeners.add(listener);
    }

    public void removeOnChildAttachStateChangeListener(@NonNull OnChildAttachStateChangeListener listener) {
        if (this.mOnChildAttachStateListeners == null) {
            return;
        }
        this.mOnChildAttachStateListeners.remove(listener);
    }

    public void clearOnChildAttachStateChangeListeners() {
        if (this.mOnChildAttachStateListeners != null) {
            this.mOnChildAttachStateListeners.clear();
        }
    }

    public void setLayoutManager(@Nullable LayoutManager layout) {
        if (layout == this.mLayout) {
            return;
        }
        this.stopScroll();
        if (this.mLayout != null) {
            if (this.mItemAnimator != null) {
                this.mItemAnimator.endAnimations();
            }
            this.mLayout.removeAndRecycleAllViews(this.mRecycler);
            this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
            this.mRecycler.clear();
            if (this.mIsAttached) {
                this.mLayout.dispatchDetachedFromWindow(this, this.mRecycler);
            }
            this.mLayout.setRecyclerView(null);
            this.mLayout = null;
        } else {
            this.mRecycler.clear();
        }
        this.mChildHelper.removeAllViewsUnfiltered();
        this.mLayout = layout;
        if (layout != null) {
            if (layout.mRecyclerView != null) {
                throw new IllegalArgumentException("LayoutManager " + layout + " is already attached to a RecyclerView:" + layout.mRecyclerView.exceptionLabel());
            }
            this.mLayout.setRecyclerView(this);
            if (this.mIsAttached) {
                this.mLayout.dispatchAttachedToWindow(this);
            }
        }
        this.mRecycler.updateViewCacheSize();
        this.requestLayout();
    }

    public void setOnFlingListener(@Nullable OnFlingListener onFlingListener) {
        this.mOnFlingListener = onFlingListener;
    }

    @Nullable
    public OnFlingListener getOnFlingListener() {
        return this.mOnFlingListener;
    }

    protected Parcelable onSaveInstanceState() {
        SavedState state = new SavedState(super.onSaveInstanceState());
        if (this.mPendingSavedState != null) {
            state.copyFrom(this.mPendingSavedState);
        } else {
            state.mLayoutState = this.mLayout != null ? this.mLayout.onSaveInstanceState() : null;
        }
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        this.mPendingSavedState = (SavedState)state;
        super.onRestoreInstanceState(this.mPendingSavedState.getSuperState());
        this.requestLayout();
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        this.dispatchFreezeSelfOnly(container);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    private void addAnimatingView(ViewHolder viewHolder) {
        View view = viewHolder.itemView;
        boolean alreadyParented = view.getParent() == this;
        this.mRecycler.unscrapView(this.getChildViewHolder(view));
        if (viewHolder.isTmpDetached()) {
            this.mChildHelper.attachViewToParent(view, -1, view.getLayoutParams(), true);
        } else if (!alreadyParented) {
            this.mChildHelper.addView(view, true);
        } else {
            this.mChildHelper.hide(view);
        }
    }

    boolean removeAnimatingView(View view) {
        this.startInterceptRequestLayout();
        boolean removed = this.mChildHelper.removeViewIfHidden(view);
        if (removed) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            this.mRecycler.unscrapView(viewHolder);
            this.mRecycler.recycleViewHolderInternal(viewHolder);
        }
        this.stopInterceptRequestLayout(!removed);
        return removed;
    }

    @Nullable
    public LayoutManager getLayoutManager() {
        return this.mLayout;
    }

    @NonNull
    public RecycledViewPool getRecycledViewPool() {
        return this.mRecycler.getRecycledViewPool();
    }

    public void setRecycledViewPool(@Nullable RecycledViewPool pool) {
        this.mRecycler.setRecycledViewPool(pool);
    }

    public void setViewCacheExtension(@Nullable ViewCacheExtension extension) {
        this.mRecycler.setViewCacheExtension(extension);
    }

    public void setItemViewCacheSize(int size) {
        this.mRecycler.setViewCacheSize(size);
    }

    public int getScrollState() {
        return this.mScrollState;
    }

    void setScrollState(int state) {
        if (state == this.mScrollState) {
            return;
        }
        this.mScrollState = state;
        if (state != 2) {
            this.stopScrollersInternal();
        }
        this.dispatchOnScrollStateChanged(state);
    }

    public void addItemDecoration(@NonNull ItemDecoration decor, int index) {
        if (this.mLayout != null) {
            this.mLayout.assertNotInLayoutOrScroll("Cannot add item decoration during a scroll  or layout");
        }
        if (this.mItemDecorations.isEmpty()) {
            this.setWillNotDraw(false);
        }
        if (index < 0) {
            this.mItemDecorations.add(decor);
        } else {
            this.mItemDecorations.add(index, decor);
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    public void addItemDecoration(@NonNull ItemDecoration decor) {
        this.addItemDecoration(decor, -1);
    }

    @NonNull
    public ItemDecoration getItemDecorationAt(int index) {
        int size = this.getItemDecorationCount();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(index + " is an invalid index for size " + size);
        }
        return this.mItemDecorations.get(index);
    }

    public int getItemDecorationCount() {
        return this.mItemDecorations.size();
    }

    public void removeItemDecorationAt(int index) {
        int size = this.getItemDecorationCount();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(index + " is an invalid index for size " + size);
        }
        this.removeItemDecoration(this.getItemDecorationAt(index));
    }

    public void removeItemDecoration(@NonNull ItemDecoration decor) {
        if (this.mLayout != null) {
            this.mLayout.assertNotInLayoutOrScroll("Cannot remove item decoration during a scroll  or layout");
        }
        this.mItemDecorations.remove(decor);
        if (this.mItemDecorations.isEmpty()) {
            this.setWillNotDraw(this.getOverScrollMode() == 2);
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    public void setChildDrawingOrderCallback(@Nullable ChildDrawingOrderCallback childDrawingOrderCallback) {
        if (childDrawingOrderCallback == this.mChildDrawingOrderCallback) {
            return;
        }
        this.mChildDrawingOrderCallback = childDrawingOrderCallback;
        this.setChildrenDrawingOrderEnabled(this.mChildDrawingOrderCallback != null);
    }

    @Deprecated
    public void setOnScrollListener(@Nullable OnScrollListener listener) {
        this.mScrollListener = listener;
    }

    public void addOnScrollListener(@NonNull OnScrollListener listener) {
        if (this.mScrollListeners == null) {
            this.mScrollListeners = new ArrayList<OnScrollListener>();
        }
        this.mScrollListeners.add(listener);
    }

    public void removeOnScrollListener(@NonNull OnScrollListener listener) {
        if (this.mScrollListeners != null) {
            this.mScrollListeners.remove(listener);
        }
    }

    public void clearOnScrollListeners() {
        if (this.mScrollListeners != null) {
            this.mScrollListeners.clear();
        }
    }

    public void scrollToPosition(int position) {
        if (this.mLayoutSuppressed) {
            return;
        }
        this.stopScroll();
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot scroll to position a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        this.mLayout.scrollToPosition(position);
        this.awakenScrollBars();
    }

    void jumpToPositionForSmoothScroller(int position) {
        if (this.mLayout == null) {
            return;
        }
        this.setScrollState(2);
        this.mLayout.scrollToPosition(position);
        this.awakenScrollBars();
    }

    public void smoothScrollToPosition(int position) {
        if (this.mLayoutSuppressed) {
            return;
        }
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        this.mLayout.smoothScrollToPosition(this, this.mState, position);
    }

    public void scrollTo(int x, int y) {
        Log.w((String)TAG, (String)"RecyclerView does not support scrolling to an absolute position. Use scrollToPosition instead");
    }

    public void scrollBy(int x, int y) {
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        if (this.mLayoutSuppressed) {
            return;
        }
        boolean canScrollHorizontal = this.mLayout.canScrollHorizontally();
        boolean canScrollVertical = this.mLayout.canScrollVertically();
        if (canScrollHorizontal || canScrollVertical) {
            this.scrollByInternal(canScrollHorizontal ? x : 0, canScrollVertical ? y : 0, null, 0);
        }
    }

    public void nestedScrollBy(int x, int y) {
        this.nestedScrollByInternal(x, y, null, 1);
    }

    private void nestedScrollByInternal(int x, int y, @Nullable MotionEvent motionEvent, int type) {
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        if (this.mLayoutSuppressed) {
            return;
        }
        this.mReusableIntPair[0] = 0;
        this.mReusableIntPair[1] = 0;
        boolean canScrollHorizontal = this.mLayout.canScrollHorizontally();
        boolean canScrollVertical = this.mLayout.canScrollVertically();
        int nestedScrollAxis = 0;
        if (canScrollHorizontal) {
            nestedScrollAxis |= 1;
        }
        if (canScrollVertical) {
            nestedScrollAxis |= 2;
        }
        float verticalDisplacement = motionEvent == null ? (float)this.getHeight() / 2.0f : motionEvent.getY();
        float horizontalDisplacement = motionEvent == null ? (float)this.getWidth() / 2.0f : motionEvent.getX();
        x -= this.releaseHorizontalGlow(x, verticalDisplacement);
        y -= this.releaseVerticalGlow(y, horizontalDisplacement);
        this.startNestedScroll(nestedScrollAxis, type);
        if (this.dispatchNestedPreScroll(canScrollHorizontal ? x : 0, canScrollVertical ? y : 0, this.mReusableIntPair, this.mScrollOffset, type)) {
            x -= this.mReusableIntPair[0];
            y -= this.mReusableIntPair[1];
        }
        this.scrollByInternal(canScrollHorizontal ? x : 0, canScrollVertical ? y : 0, motionEvent, type);
        if (this.mGapWorker != null && (x != 0 || y != 0)) {
            this.mGapWorker.postFromTraversal(this, x, y);
        }
        this.stopNestedScroll(type);
    }

    void scrollStep(int dx, int dy, @Nullable int[] consumed) {
        this.startInterceptRequestLayout();
        this.onEnterLayoutOrScroll();
        TraceCompat.beginSection((String)TRACE_SCROLL_TAG);
        this.fillRemainingScrollValues(this.mState);
        int consumedX = 0;
        int consumedY = 0;
        if (dx != 0) {
            consumedX = this.mLayout.scrollHorizontallyBy(dx, this.mRecycler, this.mState);
        }
        if (dy != 0) {
            consumedY = this.mLayout.scrollVerticallyBy(dy, this.mRecycler, this.mState);
        }
        TraceCompat.endSection();
        this.repositionShadowingViews();
        this.onExitLayoutOrScroll();
        this.stopInterceptRequestLayout(false);
        if (consumed != null) {
            consumed[0] = consumedX;
            consumed[1] = consumedY;
        }
    }

    void consumePendingUpdateOperations() {
        if (!this.mFirstLayoutComplete || this.mDataSetHasChangedAfterLayout) {
            TraceCompat.beginSection((String)TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG);
            this.dispatchLayout();
            TraceCompat.endSection();
            return;
        }
        if (!this.mAdapterHelper.hasPendingUpdates()) {
            return;
        }
        if (this.mAdapterHelper.hasAnyUpdateTypes(4) && !this.mAdapterHelper.hasAnyUpdateTypes(11)) {
            TraceCompat.beginSection((String)TRACE_HANDLE_ADAPTER_UPDATES_TAG);
            this.startInterceptRequestLayout();
            this.onEnterLayoutOrScroll();
            this.mAdapterHelper.preProcess();
            if (!this.mLayoutWasDefered) {
                if (this.hasUpdatedView()) {
                    this.dispatchLayout();
                } else {
                    this.mAdapterHelper.consumePostponedUpdates();
                }
            }
            this.stopInterceptRequestLayout(true);
            this.onExitLayoutOrScroll();
            TraceCompat.endSection();
        } else if (this.mAdapterHelper.hasPendingUpdates()) {
            TraceCompat.beginSection((String)TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG);
            this.dispatchLayout();
            TraceCompat.endSection();
        }
    }

    private boolean hasUpdatedView() {
        int childCount = this.mChildHelper.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
            if (holder == null || holder.shouldIgnore() || !holder.isUpdated()) continue;
            return true;
        }
        return false;
    }

    boolean scrollByInternal(int x, int y, MotionEvent ev, int type) {
        int unconsumedX = 0;
        int unconsumedY = 0;
        int consumedX = 0;
        int consumedY = 0;
        this.consumePendingUpdateOperations();
        if (this.mAdapter != null) {
            this.mReusableIntPair[0] = 0;
            this.mReusableIntPair[1] = 0;
            this.scrollStep(x, y, this.mReusableIntPair);
            consumedX = this.mReusableIntPair[0];
            consumedY = this.mReusableIntPair[1];
            unconsumedX = x - consumedX;
            unconsumedY = y - consumedY;
        }
        if (!this.mItemDecorations.isEmpty()) {
            this.invalidate();
        }
        this.mReusableIntPair[0] = 0;
        this.mReusableIntPair[1] = 0;
        this.dispatchNestedScroll(consumedX, consumedY, unconsumedX, unconsumedY, this.mScrollOffset, type, this.mReusableIntPair);
        unconsumedX -= this.mReusableIntPair[0];
        unconsumedY -= this.mReusableIntPair[1];
        boolean consumedNestedScroll = this.mReusableIntPair[0] != 0 || this.mReusableIntPair[1] != 0;
        this.mLastTouchX -= this.mScrollOffset[0];
        this.mLastTouchY -= this.mScrollOffset[1];
        this.mNestedOffsets[0] = this.mNestedOffsets[0] + this.mScrollOffset[0];
        this.mNestedOffsets[1] = this.mNestedOffsets[1] + this.mScrollOffset[1];
        if (this.getOverScrollMode() != 2) {
            if (ev != null && !MotionEventCompat.isFromSource((MotionEvent)ev, (int)8194)) {
                this.pullGlows(ev.getX(), unconsumedX, ev.getY(), unconsumedY);
            }
            this.considerReleasingGlowsOnScroll(x, y);
        }
        if (consumedX != 0 || consumedY != 0) {
            this.dispatchOnScrolled(consumedX, consumedY);
        }
        if (!this.awakenScrollBars()) {
            this.invalidate();
        }
        return consumedNestedScroll || consumedX != 0 || consumedY != 0;
    }

    private int releaseHorizontalGlow(int deltaX, float y) {
        float consumed = 0.0f;
        float displacement = y / (float)this.getHeight();
        float pullDistance = (float)deltaX / (float)this.getWidth();
        if (this.mLeftGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)this.mLeftGlow) != 0.0f) {
            if (this.canScrollHorizontally(-1)) {
                this.mLeftGlow.onRelease();
            } else {
                consumed = -EdgeEffectCompat.onPullDistance((EdgeEffect)this.mLeftGlow, (float)(-pullDistance), (float)(1.0f - displacement));
                if (EdgeEffectCompat.getDistance((EdgeEffect)this.mLeftGlow) == 0.0f) {
                    this.mLeftGlow.onRelease();
                }
            }
            this.invalidate();
        } else if (this.mRightGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)this.mRightGlow) != 0.0f) {
            if (this.canScrollHorizontally(1)) {
                this.mRightGlow.onRelease();
            } else {
                consumed = EdgeEffectCompat.onPullDistance((EdgeEffect)this.mRightGlow, (float)pullDistance, (float)displacement);
                if (EdgeEffectCompat.getDistance((EdgeEffect)this.mRightGlow) == 0.0f) {
                    this.mRightGlow.onRelease();
                }
            }
            this.invalidate();
        }
        return Math.round(consumed * (float)this.getWidth());
    }

    private int releaseVerticalGlow(int deltaY, float x) {
        float consumed = 0.0f;
        float displacement = x / (float)this.getWidth();
        float pullDistance = (float)deltaY / (float)this.getHeight();
        if (this.mTopGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)this.mTopGlow) != 0.0f) {
            if (this.canScrollVertically(-1)) {
                this.mTopGlow.onRelease();
            } else {
                consumed = -EdgeEffectCompat.onPullDistance((EdgeEffect)this.mTopGlow, (float)(-pullDistance), (float)displacement);
                if (EdgeEffectCompat.getDistance((EdgeEffect)this.mTopGlow) == 0.0f) {
                    this.mTopGlow.onRelease();
                }
            }
            this.invalidate();
        } else if (this.mBottomGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)this.mBottomGlow) != 0.0f) {
            if (this.canScrollVertically(1)) {
                this.mBottomGlow.onRelease();
            } else {
                consumed = EdgeEffectCompat.onPullDistance((EdgeEffect)this.mBottomGlow, (float)pullDistance, (float)(1.0f - displacement));
                if (EdgeEffectCompat.getDistance((EdgeEffect)this.mBottomGlow) == 0.0f) {
                    this.mBottomGlow.onRelease();
                }
            }
            this.invalidate();
        }
        return Math.round(consumed * (float)this.getHeight());
    }

    public int computeHorizontalScrollOffset() {
        if (this.mLayout == null) {
            return 0;
        }
        return this.mLayout.canScrollHorizontally() ? this.mLayout.computeHorizontalScrollOffset(this.mState) : 0;
    }

    public int computeHorizontalScrollExtent() {
        if (this.mLayout == null) {
            return 0;
        }
        return this.mLayout.canScrollHorizontally() ? this.mLayout.computeHorizontalScrollExtent(this.mState) : 0;
    }

    public int computeHorizontalScrollRange() {
        if (this.mLayout == null) {
            return 0;
        }
        return this.mLayout.canScrollHorizontally() ? this.mLayout.computeHorizontalScrollRange(this.mState) : 0;
    }

    public int computeVerticalScrollOffset() {
        if (this.mLayout == null) {
            return 0;
        }
        return this.mLayout.canScrollVertically() ? this.mLayout.computeVerticalScrollOffset(this.mState) : 0;
    }

    public int computeVerticalScrollExtent() {
        if (this.mLayout == null) {
            return 0;
        }
        return this.mLayout.canScrollVertically() ? this.mLayout.computeVerticalScrollExtent(this.mState) : 0;
    }

    public int computeVerticalScrollRange() {
        if (this.mLayout == null) {
            return 0;
        }
        return this.mLayout.canScrollVertically() ? this.mLayout.computeVerticalScrollRange(this.mState) : 0;
    }

    void startInterceptRequestLayout() {
        ++this.mInterceptRequestLayoutDepth;
        if (this.mInterceptRequestLayoutDepth == 1 && !this.mLayoutSuppressed) {
            this.mLayoutWasDefered = false;
        }
    }

    void stopInterceptRequestLayout(boolean performLayoutChildren) {
        if (this.mInterceptRequestLayoutDepth < 1) {
            this.mInterceptRequestLayoutDepth = 1;
        }
        if (!performLayoutChildren && !this.mLayoutSuppressed) {
            this.mLayoutWasDefered = false;
        }
        if (this.mInterceptRequestLayoutDepth == 1) {
            if (performLayoutChildren && this.mLayoutWasDefered && !this.mLayoutSuppressed && this.mLayout != null && this.mAdapter != null) {
                this.dispatchLayout();
            }
            if (!this.mLayoutSuppressed) {
                this.mLayoutWasDefered = false;
            }
        }
        --this.mInterceptRequestLayoutDepth;
    }

    public final void suppressLayout(boolean suppress) {
        if (suppress != this.mLayoutSuppressed) {
            this.assertNotInLayoutOrScroll("Do not suppressLayout in layout or scroll");
            if (!suppress) {
                this.mLayoutSuppressed = false;
                if (this.mLayoutWasDefered && this.mLayout != null && this.mAdapter != null) {
                    this.requestLayout();
                }
                this.mLayoutWasDefered = false;
            } else {
                long now = SystemClock.uptimeMillis();
                MotionEvent cancelEvent = MotionEvent.obtain((long)now, (long)now, (int)3, (float)0.0f, (float)0.0f, (int)0);
                this.onTouchEvent(cancelEvent);
                this.mLayoutSuppressed = true;
                this.mIgnoreMotionEventTillDown = true;
                this.stopScroll();
            }
        }
    }

    public final boolean isLayoutSuppressed() {
        return this.mLayoutSuppressed;
    }

    @Deprecated
    public void setLayoutFrozen(boolean frozen) {
        this.suppressLayout(frozen);
    }

    @Deprecated
    public boolean isLayoutFrozen() {
        return this.isLayoutSuppressed();
    }

    @Deprecated
    public void setLayoutTransition(LayoutTransition transition) {
        if (Build.VERSION.SDK_INT < 18) {
            if (transition == null) {
                this.suppressLayout(false);
                return;
            }
            int layoutTransitionChanging = 4;
            if (transition.getAnimator(0) == null && transition.getAnimator(1) == null && transition.getAnimator(2) == null && transition.getAnimator(3) == null && transition.getAnimator(layoutTransitionChanging) == null) {
                this.suppressLayout(true);
                return;
            }
        }
        if (transition != null) {
            throw new IllegalArgumentException("Providing a LayoutTransition into RecyclerView is not supported. Please use setItemAnimator() instead for animating changes to the items in this RecyclerView");
        }
        super.setLayoutTransition(null);
    }

    public void smoothScrollBy(@Px int dx, @Px int dy) {
        this.smoothScrollBy(dx, dy, null);
    }

    public void smoothScrollBy(@Px int dx, @Px int dy, @Nullable Interpolator interpolator) {
        this.smoothScrollBy(dx, dy, interpolator, Integer.MIN_VALUE);
    }

    public void smoothScrollBy(@Px int dx, @Px int dy, @Nullable Interpolator interpolator, int duration) {
        this.smoothScrollBy(dx, dy, interpolator, duration, false);
    }

    void smoothScrollBy(@Px int dx, @Px int dy, @Nullable Interpolator interpolator, int duration, boolean withNestedScrolling) {
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        if (this.mLayoutSuppressed) {
            return;
        }
        if (!this.mLayout.canScrollHorizontally()) {
            dx = 0;
        }
        if (!this.mLayout.canScrollVertically()) {
            dy = 0;
        }
        if (dx != 0 || dy != 0) {
            boolean durationSuggestsAnimation;
            boolean bl = durationSuggestsAnimation = duration == Integer.MIN_VALUE || duration > 0;
            if (durationSuggestsAnimation) {
                if (withNestedScrolling) {
                    int nestedScrollAxis = 0;
                    if (dx != 0) {
                        nestedScrollAxis |= 1;
                    }
                    if (dy != 0) {
                        nestedScrollAxis |= 2;
                    }
                    this.startNestedScroll(nestedScrollAxis, 1);
                }
                this.mViewFlinger.smoothScrollBy(dx, dy, duration, interpolator);
            } else {
                this.scrollBy(dx, dy);
            }
        }
    }

    public boolean fling(int velocityX, int velocityY) {
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot fling without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return false;
        }
        if (this.mLayoutSuppressed) {
            return false;
        }
        boolean canScrollHorizontal = this.mLayout.canScrollHorizontally();
        boolean canScrollVertical = this.mLayout.canScrollVertically();
        if (!canScrollHorizontal || Math.abs(velocityX) < this.mMinFlingVelocity) {
            velocityX = 0;
        }
        if (!canScrollVertical || Math.abs(velocityY) < this.mMinFlingVelocity) {
            velocityY = 0;
        }
        if (velocityX == 0 && velocityY == 0) {
            return false;
        }
        int flingX = 0;
        int flingY = 0;
        if (velocityX != 0) {
            if (this.mLeftGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)this.mLeftGlow) != 0.0f) {
                if (this.shouldAbsorb(this.mLeftGlow, -velocityX, this.getWidth())) {
                    this.mLeftGlow.onAbsorb(-velocityX);
                } else {
                    flingX = velocityX;
                }
                velocityX = 0;
            } else if (this.mRightGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)this.mRightGlow) != 0.0f) {
                if (this.shouldAbsorb(this.mRightGlow, velocityX, this.getWidth())) {
                    this.mRightGlow.onAbsorb(velocityX);
                } else {
                    flingX = velocityX;
                }
                velocityX = 0;
            }
        }
        if (velocityY != 0) {
            if (this.mTopGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)this.mTopGlow) != 0.0f) {
                if (this.shouldAbsorb(this.mTopGlow, -velocityY, this.getHeight())) {
                    this.mTopGlow.onAbsorb(-velocityY);
                } else {
                    flingY = velocityY;
                }
                velocityY = 0;
            } else if (this.mBottomGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)this.mBottomGlow) != 0.0f) {
                if (this.shouldAbsorb(this.mBottomGlow, velocityY, this.getHeight())) {
                    this.mBottomGlow.onAbsorb(velocityY);
                } else {
                    flingY = velocityY;
                }
                velocityY = 0;
            }
        }
        if (flingX != 0 || flingY != 0) {
            flingX = Math.max(-this.mMaxFlingVelocity, Math.min(flingX, this.mMaxFlingVelocity));
            flingY = Math.max(-this.mMaxFlingVelocity, Math.min(flingY, this.mMaxFlingVelocity));
            this.mViewFlinger.fling(flingX, flingY);
        }
        if (velocityX == 0 && velocityY == 0) {
            return flingX != 0 || flingY != 0;
        }
        if (!this.dispatchNestedPreFling(velocityX, velocityY)) {
            boolean canScroll = canScrollHorizontal || canScrollVertical;
            this.dispatchNestedFling(velocityX, velocityY, canScroll);
            if (this.mOnFlingListener != null && this.mOnFlingListener.onFling(velocityX, velocityY)) {
                return true;
            }
            if (canScroll) {
                int nestedScrollAxis = 0;
                if (canScrollHorizontal) {
                    nestedScrollAxis |= 1;
                }
                if (canScrollVertical) {
                    nestedScrollAxis |= 2;
                }
                this.startNestedScroll(nestedScrollAxis, 1);
                velocityX = Math.max(-this.mMaxFlingVelocity, Math.min(velocityX, this.mMaxFlingVelocity));
                velocityY = Math.max(-this.mMaxFlingVelocity, Math.min(velocityY, this.mMaxFlingVelocity));
                this.mViewFlinger.fling(velocityX, velocityY);
                return true;
            }
        }
        return false;
    }

    private boolean shouldAbsorb(@NonNull EdgeEffect edgeEffect, int velocity, int size) {
        if (velocity > 0) {
            return true;
        }
        float distance = EdgeEffectCompat.getDistance((EdgeEffect)edgeEffect) * (float)size;
        float flingDistance = this.getSplineFlingDistance(-velocity);
        return flingDistance < distance;
    }

    int consumeFlingInHorizontalStretch(int unconsumedX) {
        return this.consumeFlingInStretch(unconsumedX, this.mLeftGlow, this.mRightGlow, this.getWidth());
    }

    int consumeFlingInVerticalStretch(int unconsumedY) {
        return this.consumeFlingInStretch(unconsumedY, this.mTopGlow, this.mBottomGlow, this.getHeight());
    }

    private int consumeFlingInStretch(int unconsumed, EdgeEffect startGlow, EdgeEffect endGlow, int size) {
        if (unconsumed > 0 && startGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)startGlow) != 0.0f) {
            float deltaDistance = (float)(-unconsumed) * 4.0f / (float)size;
            int consumed = Math.round((float)(-size) / 4.0f * EdgeEffectCompat.onPullDistance((EdgeEffect)startGlow, (float)deltaDistance, (float)0.5f));
            if (consumed != unconsumed) {
                startGlow.finish();
            }
            return unconsumed - consumed;
        }
        if (unconsumed < 0 && endGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)endGlow) != 0.0f) {
            float deltaDistance = (float)unconsumed * 4.0f / (float)size;
            int consumed = Math.round((float)size / 4.0f * EdgeEffectCompat.onPullDistance((EdgeEffect)endGlow, (float)deltaDistance, (float)0.5f));
            if (consumed != unconsumed) {
                endGlow.finish();
            }
            return unconsumed - consumed;
        }
        return unconsumed;
    }

    public void stopScroll() {
        this.setScrollState(0);
        this.stopScrollersInternal();
    }

    private void stopScrollersInternal() {
        this.mViewFlinger.stop();
        if (this.mLayout != null) {
            this.mLayout.stopSmoothScroller();
        }
    }

    public int getMinFlingVelocity() {
        return this.mMinFlingVelocity;
    }

    public int getMaxFlingVelocity() {
        return this.mMaxFlingVelocity;
    }

    private void pullGlows(float x, float overscrollX, float y, float overscrollY) {
        boolean invalidate = false;
        if (overscrollX < 0.0f) {
            this.ensureLeftGlow();
            EdgeEffectCompat.onPullDistance((EdgeEffect)this.mLeftGlow, (float)(-overscrollX / (float)this.getWidth()), (float)(1.0f - y / (float)this.getHeight()));
            invalidate = true;
        } else if (overscrollX > 0.0f) {
            this.ensureRightGlow();
            EdgeEffectCompat.onPullDistance((EdgeEffect)this.mRightGlow, (float)(overscrollX / (float)this.getWidth()), (float)(y / (float)this.getHeight()));
            invalidate = true;
        }
        if (overscrollY < 0.0f) {
            this.ensureTopGlow();
            EdgeEffectCompat.onPullDistance((EdgeEffect)this.mTopGlow, (float)(-overscrollY / (float)this.getHeight()), (float)(x / (float)this.getWidth()));
            invalidate = true;
        } else if (overscrollY > 0.0f) {
            this.ensureBottomGlow();
            EdgeEffectCompat.onPullDistance((EdgeEffect)this.mBottomGlow, (float)(overscrollY / (float)this.getHeight()), (float)(1.0f - x / (float)this.getWidth()));
            invalidate = true;
        }
        if (invalidate || overscrollX != 0.0f || overscrollY != 0.0f) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private void releaseGlows() {
        boolean needsInvalidate = false;
        if (this.mLeftGlow != null) {
            this.mLeftGlow.onRelease();
            needsInvalidate = this.mLeftGlow.isFinished();
        }
        if (this.mTopGlow != null) {
            this.mTopGlow.onRelease();
            needsInvalidate |= this.mTopGlow.isFinished();
        }
        if (this.mRightGlow != null) {
            this.mRightGlow.onRelease();
            needsInvalidate |= this.mRightGlow.isFinished();
        }
        if (this.mBottomGlow != null) {
            this.mBottomGlow.onRelease();
            needsInvalidate |= this.mBottomGlow.isFinished();
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    void considerReleasingGlowsOnScroll(int dx, int dy) {
        boolean needsInvalidate = false;
        if (this.mLeftGlow != null && !this.mLeftGlow.isFinished() && dx > 0) {
            this.mLeftGlow.onRelease();
            needsInvalidate = this.mLeftGlow.isFinished();
        }
        if (this.mRightGlow != null && !this.mRightGlow.isFinished() && dx < 0) {
            this.mRightGlow.onRelease();
            needsInvalidate |= this.mRightGlow.isFinished();
        }
        if (this.mTopGlow != null && !this.mTopGlow.isFinished() && dy > 0) {
            this.mTopGlow.onRelease();
            needsInvalidate |= this.mTopGlow.isFinished();
        }
        if (this.mBottomGlow != null && !this.mBottomGlow.isFinished() && dy < 0) {
            this.mBottomGlow.onRelease();
            needsInvalidate |= this.mBottomGlow.isFinished();
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    void absorbGlows(int velocityX, int velocityY) {
        if (velocityX < 0) {
            this.ensureLeftGlow();
            if (this.mLeftGlow.isFinished()) {
                this.mLeftGlow.onAbsorb(-velocityX);
            }
        } else if (velocityX > 0) {
            this.ensureRightGlow();
            if (this.mRightGlow.isFinished()) {
                this.mRightGlow.onAbsorb(velocityX);
            }
        }
        if (velocityY < 0) {
            this.ensureTopGlow();
            if (this.mTopGlow.isFinished()) {
                this.mTopGlow.onAbsorb(-velocityY);
            }
        } else if (velocityY > 0) {
            this.ensureBottomGlow();
            if (this.mBottomGlow.isFinished()) {
                this.mBottomGlow.onAbsorb(velocityY);
            }
        }
        if (velocityX != 0 || velocityY != 0) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    void ensureLeftGlow() {
        if (this.mLeftGlow != null) {
            return;
        }
        this.mLeftGlow = this.mEdgeEffectFactory.createEdgeEffect(this, 0);
        if (this.mClipToPadding) {
            this.mLeftGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
        } else {
            this.mLeftGlow.setSize(this.getMeasuredHeight(), this.getMeasuredWidth());
        }
    }

    void ensureRightGlow() {
        if (this.mRightGlow != null) {
            return;
        }
        this.mRightGlow = this.mEdgeEffectFactory.createEdgeEffect(this, 2);
        if (this.mClipToPadding) {
            this.mRightGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
        } else {
            this.mRightGlow.setSize(this.getMeasuredHeight(), this.getMeasuredWidth());
        }
    }

    void ensureTopGlow() {
        if (this.mTopGlow != null) {
            return;
        }
        this.mTopGlow = this.mEdgeEffectFactory.createEdgeEffect(this, 1);
        if (this.mClipToPadding) {
            this.mTopGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
        } else {
            this.mTopGlow.setSize(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    void ensureBottomGlow() {
        if (this.mBottomGlow != null) {
            return;
        }
        this.mBottomGlow = this.mEdgeEffectFactory.createEdgeEffect(this, 3);
        if (this.mClipToPadding) {
            this.mBottomGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
        } else {
            this.mBottomGlow.setSize(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    void invalidateGlows() {
        this.mBottomGlow = null;
        this.mTopGlow = null;
        this.mRightGlow = null;
        this.mLeftGlow = null;
    }

    public void setEdgeEffectFactory(@NonNull EdgeEffectFactory edgeEffectFactory) {
        Preconditions.checkNotNull((Object)edgeEffectFactory);
        this.mEdgeEffectFactory = edgeEffectFactory;
        this.invalidateGlows();
    }

    @NonNull
    public EdgeEffectFactory getEdgeEffectFactory() {
        return this.mEdgeEffectFactory;
    }

    public View focusSearch(View focused, int direction) {
        View result = this.mLayout.onInterceptFocusSearch(focused, direction);
        if (result != null) {
            return result;
        }
        boolean canRunFocusFailure = this.mAdapter != null && this.mLayout != null && !this.isComputingLayout() && !this.mLayoutSuppressed;
        FocusFinder ff = FocusFinder.getInstance();
        if (canRunFocusFailure && (direction == 2 || direction == 1)) {
            boolean needsFocusFailureLayout = false;
            if (this.mLayout.canScrollVertically()) {
                int absDir = direction == 2 ? 130 : 33;
                View found = ff.findNextFocus((ViewGroup)this, focused, absDir);
                boolean bl = needsFocusFailureLayout = found == null;
                if (FORCE_ABS_FOCUS_SEARCH_DIRECTION) {
                    direction = absDir;
                }
            }
            if (!needsFocusFailureLayout && this.mLayout.canScrollHorizontally()) {
                boolean rtl = this.mLayout.getLayoutDirection() == 1;
                int absDir = direction == 2 ^ rtl ? 66 : 17;
                View found = ff.findNextFocus((ViewGroup)this, focused, absDir);
                boolean bl = needsFocusFailureLayout = found == null;
                if (FORCE_ABS_FOCUS_SEARCH_DIRECTION) {
                    direction = absDir;
                }
            }
            if (needsFocusFailureLayout) {
                this.consumePendingUpdateOperations();
                View focusedItemView = this.findContainingItemView(focused);
                if (focusedItemView == null) {
                    return null;
                }
                this.startInterceptRequestLayout();
                this.mLayout.onFocusSearchFailed(focused, direction, this.mRecycler, this.mState);
                this.stopInterceptRequestLayout(false);
            }
            result = ff.findNextFocus((ViewGroup)this, focused, direction);
        } else {
            result = ff.findNextFocus((ViewGroup)this, focused, direction);
            if (result == null && canRunFocusFailure) {
                this.consumePendingUpdateOperations();
                View focusedItemView = this.findContainingItemView(focused);
                if (focusedItemView == null) {
                    return null;
                }
                this.startInterceptRequestLayout();
                result = this.mLayout.onFocusSearchFailed(focused, direction, this.mRecycler, this.mState);
                this.stopInterceptRequestLayout(false);
            }
        }
        if (result != null && !result.hasFocusable()) {
            if (this.getFocusedChild() == null) {
                return super.focusSearch(focused, direction);
            }
            this.requestChildOnScreen(result, null);
            return focused;
        }
        return this.isPreferredNextFocus(focused, result, direction) ? result : super.focusSearch(focused, direction);
    }

    private boolean isPreferredNextFocus(View focused, View next, int direction) {
        if (next == null || next == this || next == focused) {
            return false;
        }
        if (this.findContainingItemView(next) == null) {
            return false;
        }
        if (focused == null) {
            return true;
        }
        if (this.findContainingItemView(focused) == null) {
            return true;
        }
        this.mTempRect.set(0, 0, focused.getWidth(), focused.getHeight());
        this.mTempRect2.set(0, 0, next.getWidth(), next.getHeight());
        this.offsetDescendantRectToMyCoords(focused, this.mTempRect);
        this.offsetDescendantRectToMyCoords(next, this.mTempRect2);
        int rtl = this.mLayout.getLayoutDirection() == 1 ? -1 : 1;
        int rightness = 0;
        if ((this.mTempRect.left < this.mTempRect2.left || this.mTempRect.right <= this.mTempRect2.left) && this.mTempRect.right < this.mTempRect2.right) {
            rightness = 1;
        } else if ((this.mTempRect.right > this.mTempRect2.right || this.mTempRect.left >= this.mTempRect2.right) && this.mTempRect.left > this.mTempRect2.left) {
            rightness = -1;
        }
        int downness = 0;
        if ((this.mTempRect.top < this.mTempRect2.top || this.mTempRect.bottom <= this.mTempRect2.top) && this.mTempRect.bottom < this.mTempRect2.bottom) {
            downness = 1;
        } else if ((this.mTempRect.bottom > this.mTempRect2.bottom || this.mTempRect.top >= this.mTempRect2.bottom) && this.mTempRect.top > this.mTempRect2.top) {
            downness = -1;
        }
        switch (direction) {
            case 17: {
                return rightness < 0;
            }
            case 66: {
                return rightness > 0;
            }
            case 33: {
                return downness < 0;
            }
            case 130: {
                return downness > 0;
            }
            case 2: {
                return downness > 0 || downness == 0 && rightness * rtl > 0;
            }
            case 1: {
                return downness < 0 || downness == 0 && rightness * rtl < 0;
            }
        }
        throw new IllegalArgumentException("Invalid direction: " + direction + this.exceptionLabel());
    }

    public void requestChildFocus(View child, View focused) {
        if (!this.mLayout.onRequestChildFocus(this, this.mState, child, focused) && focused != null) {
            this.requestChildOnScreen(child, focused);
        }
        super.requestChildFocus(child, focused);
    }

    private void requestChildOnScreen(@NonNull View child, @Nullable View focused) {
        View rectView = focused != null ? focused : child;
        this.mTempRect.set(0, 0, rectView.getWidth(), rectView.getHeight());
        ViewGroup.LayoutParams focusedLayoutParams = rectView.getLayoutParams();
        if (focusedLayoutParams instanceof LayoutParams) {
            LayoutParams lp = (LayoutParams)focusedLayoutParams;
            if (!lp.mInsetsDirty) {
                Rect insets = lp.mDecorInsets;
                this.mTempRect.left -= insets.left;
                this.mTempRect.right += insets.right;
                this.mTempRect.top -= insets.top;
                this.mTempRect.bottom += insets.bottom;
            }
        }
        if (focused != null) {
            this.offsetDescendantRectToMyCoords(focused, this.mTempRect);
            this.offsetRectIntoDescendantCoords(child, this.mTempRect);
        }
        this.mLayout.requestChildRectangleOnScreen(this, child, this.mTempRect, !this.mFirstLayoutComplete, focused == null);
    }

    public boolean requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        return this.mLayout.requestChildRectangleOnScreen(this, child, rect, immediate);
    }

    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        if (this.mLayout == null || !this.mLayout.onAddFocusables(this, views, direction, focusableMode)) {
            super.addFocusables(views, direction, focusableMode);
        }
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        if (this.isComputingLayout()) {
            return false;
        }
        return super.onRequestFocusInDescendants(direction, previouslyFocusedRect);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mLayoutOrScrollCounter = 0;
        this.mIsAttached = true;
        this.mFirstLayoutComplete = this.mFirstLayoutComplete && !this.isLayoutRequested();
        this.mRecycler.onAttachedToWindow();
        if (this.mLayout != null) {
            this.mLayout.dispatchAttachedToWindow(this);
        }
        this.mPostedAnimatorRunner = false;
        if (ALLOW_THREAD_GAP_WORK) {
            this.mGapWorker = GapWorker.sGapWorker.get();
            if (this.mGapWorker == null) {
                float displayRefreshRate;
                this.mGapWorker = new GapWorker();
                Display display = ViewCompat.getDisplay((View)this);
                float refreshRate = 60.0f;
                if (!this.isInEditMode() && display != null && (displayRefreshRate = display.getRefreshRate()) >= 30.0f) {
                    refreshRate = displayRefreshRate;
                }
                this.mGapWorker.mFrameIntervalNs = (long)(1.0E9f / refreshRate);
                GapWorker.sGapWorker.set(this.mGapWorker);
            }
            this.mGapWorker.add(this);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mItemAnimator != null) {
            this.mItemAnimator.endAnimations();
        }
        this.stopScroll();
        this.mIsAttached = false;
        if (this.mLayout != null) {
            this.mLayout.dispatchDetachedFromWindow(this, this.mRecycler);
        }
        this.mPendingAccessibilityImportanceChange.clear();
        this.removeCallbacks(this.mItemAnimatorRunner);
        this.mViewInfoStore.onDetach();
        this.mRecycler.onDetachedFromWindow();
        PoolingContainer.callPoolingContainerOnReleaseForChildren((ViewGroup)this);
        if (ALLOW_THREAD_GAP_WORK && this.mGapWorker != null) {
            this.mGapWorker.remove(this);
            this.mGapWorker = null;
        }
    }

    public boolean isAttachedToWindow() {
        return this.mIsAttached;
    }

    void assertInLayoutOrScroll(String message) {
        if (!this.isComputingLayout()) {
            if (message == null) {
                throw new IllegalStateException("Cannot call this method unless RecyclerView is computing a layout or scrolling" + this.exceptionLabel());
            }
            throw new IllegalStateException(message + this.exceptionLabel());
        }
    }

    void assertNotInLayoutOrScroll(String message) {
        if (this.isComputingLayout()) {
            if (message == null) {
                throw new IllegalStateException("Cannot call this method while RecyclerView is computing a layout or scrolling" + this.exceptionLabel());
            }
            throw new IllegalStateException(message);
        }
        if (this.mDispatchScrollCounter > 0) {
            Log.w((String)TAG, (String)"Cannot call this method in a scroll callback. Scroll callbacks mightbe run during a measure & layout pass where you cannot change theRecyclerView data. Any method call that might change the structureof the RecyclerView or the adapter contents should be postponed tothe next frame.", (Throwable)new IllegalStateException("" + this.exceptionLabel()));
        }
    }

    public void addOnItemTouchListener(@NonNull OnItemTouchListener listener) {
        this.mOnItemTouchListeners.add(listener);
    }

    public void removeOnItemTouchListener(@NonNull OnItemTouchListener listener) {
        this.mOnItemTouchListeners.remove(listener);
        if (this.mInterceptingOnItemTouchListener == listener) {
            this.mInterceptingOnItemTouchListener = null;
        }
    }

    private boolean dispatchToOnItemTouchListeners(MotionEvent e) {
        if (this.mInterceptingOnItemTouchListener == null) {
            if (e.getAction() == 0) {
                return false;
            }
            return this.findInterceptingOnItemTouchListener(e);
        }
        this.mInterceptingOnItemTouchListener.onTouchEvent(this, e);
        int action = e.getAction();
        if (action == 3 || action == 1) {
            this.mInterceptingOnItemTouchListener = null;
        }
        return true;
    }

    private boolean findInterceptingOnItemTouchListener(MotionEvent e) {
        int action = e.getAction();
        int listenerCount = this.mOnItemTouchListeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            OnItemTouchListener listener = this.mOnItemTouchListeners.get(i);
            if (!listener.onInterceptTouchEvent(this, e) || action == 3) continue;
            this.mInterceptingOnItemTouchListener = listener;
            return true;
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        if (this.mLayoutSuppressed) {
            return false;
        }
        this.mInterceptingOnItemTouchListener = null;
        if (this.findInterceptingOnItemTouchListener(e)) {
            this.cancelScroll();
            return true;
        }
        if (this.mLayout == null) {
            return false;
        }
        boolean canScrollHorizontally = this.mLayout.canScrollHorizontally();
        boolean canScrollVertically = this.mLayout.canScrollVertically();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(e);
        int action = e.getActionMasked();
        int actionIndex = e.getActionIndex();
        switch (action) {
            case 0: {
                if (this.mIgnoreMotionEventTillDown) {
                    this.mIgnoreMotionEventTillDown = false;
                }
                this.mScrollPointerId = e.getPointerId(0);
                this.mInitialTouchX = this.mLastTouchX = (int)(e.getX() + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(e.getY() + 0.5f);
                if (this.stopGlowAnimations(e) || this.mScrollState == 2) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                    this.stopNestedScroll(1);
                }
                this.mNestedOffsets[1] = 0;
                this.mNestedOffsets[0] = 0;
                int nestedScrollAxis = 0;
                if (canScrollHorizontally) {
                    nestedScrollAxis |= 1;
                }
                if (canScrollVertically) {
                    nestedScrollAxis |= 2;
                }
                this.startNestedScroll(nestedScrollAxis, 0);
                break;
            }
            case 5: {
                this.mScrollPointerId = e.getPointerId(actionIndex);
                this.mInitialTouchX = this.mLastTouchX = (int)(e.getX(actionIndex) + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(e.getY(actionIndex) + 0.5f);
                break;
            }
            case 2: {
                int index = e.findPointerIndex(this.mScrollPointerId);
                if (index < 0) {
                    Log.e((String)TAG, (String)("Error processing scroll; pointer index for id " + this.mScrollPointerId + " not found. Did any MotionEvents get skipped?"));
                    return false;
                }
                int x = (int)(e.getX(index) + 0.5f);
                int y = (int)(e.getY(index) + 0.5f);
                if (this.mScrollState == 1) break;
                int dx = x - this.mInitialTouchX;
                int dy = y - this.mInitialTouchY;
                boolean startScroll = false;
                if (canScrollHorizontally && Math.abs(dx) > this.mTouchSlop) {
                    this.mLastTouchX = x;
                    startScroll = true;
                }
                if (canScrollVertically && Math.abs(dy) > this.mTouchSlop) {
                    this.mLastTouchY = y;
                    startScroll = true;
                }
                if (!startScroll) break;
                this.setScrollState(1);
                break;
            }
            case 6: {
                this.onPointerUp(e);
                break;
            }
            case 1: {
                this.mVelocityTracker.clear();
                this.stopNestedScroll(0);
                break;
            }
            case 3: {
                this.cancelScroll();
            }
        }
        return this.mScrollState == 1;
    }

    private boolean stopGlowAnimations(MotionEvent e) {
        boolean stopped = false;
        if (this.mLeftGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)this.mLeftGlow) != 0.0f && !this.canScrollHorizontally(-1)) {
            EdgeEffectCompat.onPullDistance((EdgeEffect)this.mLeftGlow, (float)0.0f, (float)(1.0f - e.getY() / (float)this.getHeight()));
            stopped = true;
        }
        if (this.mRightGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)this.mRightGlow) != 0.0f && !this.canScrollHorizontally(1)) {
            EdgeEffectCompat.onPullDistance((EdgeEffect)this.mRightGlow, (float)0.0f, (float)(e.getY() / (float)this.getHeight()));
            stopped = true;
        }
        if (this.mTopGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)this.mTopGlow) != 0.0f && !this.canScrollVertically(-1)) {
            EdgeEffectCompat.onPullDistance((EdgeEffect)this.mTopGlow, (float)0.0f, (float)(e.getX() / (float)this.getWidth()));
            stopped = true;
        }
        if (this.mBottomGlow != null && EdgeEffectCompat.getDistance((EdgeEffect)this.mBottomGlow) != 0.0f && !this.canScrollVertically(1)) {
            EdgeEffectCompat.onPullDistance((EdgeEffect)this.mBottomGlow, (float)0.0f, (float)(1.0f - e.getX() / (float)this.getWidth()));
            stopped = true;
        }
        return stopped;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        int listenerCount = this.mOnItemTouchListeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            OnItemTouchListener listener = this.mOnItemTouchListeners.get(i);
            listener.onRequestDisallowInterceptTouchEvent(disallowIntercept);
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (this.mLayoutSuppressed || this.mIgnoreMotionEventTillDown) {
            return false;
        }
        if (this.dispatchToOnItemTouchListeners(e)) {
            this.cancelScroll();
            return true;
        }
        if (this.mLayout == null) {
            return false;
        }
        boolean canScrollHorizontally = this.mLayout.canScrollHorizontally();
        boolean canScrollVertically = this.mLayout.canScrollVertically();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        boolean eventAddedToVelocityTracker = false;
        int action = e.getActionMasked();
        int actionIndex = e.getActionIndex();
        if (action == 0) {
            this.mNestedOffsets[1] = 0;
            this.mNestedOffsets[0] = 0;
        }
        MotionEvent vtev = MotionEvent.obtain((MotionEvent)e);
        vtev.offsetLocation((float)this.mNestedOffsets[0], (float)this.mNestedOffsets[1]);
        switch (action) {
            case 0: {
                this.mScrollPointerId = e.getPointerId(0);
                this.mInitialTouchX = this.mLastTouchX = (int)(e.getX() + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(e.getY() + 0.5f);
                int nestedScrollAxis = 0;
                if (canScrollHorizontally) {
                    nestedScrollAxis |= 1;
                }
                if (canScrollVertically) {
                    nestedScrollAxis |= 2;
                }
                this.startNestedScroll(nestedScrollAxis, 0);
                break;
            }
            case 5: {
                this.mScrollPointerId = e.getPointerId(actionIndex);
                this.mInitialTouchX = this.mLastTouchX = (int)(e.getX(actionIndex) + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(e.getY(actionIndex) + 0.5f);
                break;
            }
            case 2: {
                int index = e.findPointerIndex(this.mScrollPointerId);
                if (index < 0) {
                    Log.e((String)TAG, (String)("Error processing scroll; pointer index for id " + this.mScrollPointerId + " not found. Did any MotionEvents get skipped?"));
                    return false;
                }
                int x = (int)(e.getX(index) + 0.5f);
                int y = (int)(e.getY(index) + 0.5f);
                int dx = this.mLastTouchX - x;
                int dy = this.mLastTouchY - y;
                if (this.mScrollState != 1) {
                    boolean startScroll = false;
                    if (canScrollHorizontally && (dx = dx > 0 ? Math.max(0, dx - this.mTouchSlop) : Math.min(0, dx + this.mTouchSlop)) != 0) {
                        startScroll = true;
                    }
                    if (canScrollVertically && (dy = dy > 0 ? Math.max(0, dy - this.mTouchSlop) : Math.min(0, dy + this.mTouchSlop)) != 0) {
                        startScroll = true;
                    }
                    if (startScroll) {
                        this.setScrollState(1);
                    }
                }
                if (this.mScrollState != 1) break;
                this.mReusableIntPair[0] = 0;
                this.mReusableIntPair[1] = 0;
                dx -= this.releaseHorizontalGlow(dx, e.getY());
                dy -= this.releaseVerticalGlow(dy, e.getX());
                if (this.dispatchNestedPreScroll(canScrollHorizontally ? dx : 0, canScrollVertically ? dy : 0, this.mReusableIntPair, this.mScrollOffset, 0)) {
                    dx -= this.mReusableIntPair[0];
                    dy -= this.mReusableIntPair[1];
                    this.mNestedOffsets[0] = this.mNestedOffsets[0] + this.mScrollOffset[0];
                    this.mNestedOffsets[1] = this.mNestedOffsets[1] + this.mScrollOffset[1];
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                this.mLastTouchX = x - this.mScrollOffset[0];
                this.mLastTouchY = y - this.mScrollOffset[1];
                if (this.scrollByInternal(canScrollHorizontally ? dx : 0, canScrollVertically ? dy : 0, e, 0)) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (this.mGapWorker == null || dx == 0 && dy == 0) break;
                this.mGapWorker.postFromTraversal(this, dx, dy);
                break;
            }
            case 6: {
                this.onPointerUp(e);
                break;
            }
            case 1: {
                float yvel;
                this.mVelocityTracker.addMovement(vtev);
                eventAddedToVelocityTracker = true;
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxFlingVelocity);
                float xvel = canScrollHorizontally ? -this.mVelocityTracker.getXVelocity(this.mScrollPointerId) : 0.0f;
                float f = yvel = canScrollVertically ? -this.mVelocityTracker.getYVelocity(this.mScrollPointerId) : 0.0f;
                if (xvel == 0.0f && yvel == 0.0f || !this.fling((int)xvel, (int)yvel)) {
                    this.setScrollState(0);
                }
                this.resetScroll();
                break;
            }
            case 3: {
                this.cancelScroll();
            }
        }
        if (!eventAddedToVelocityTracker) {
            this.mVelocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    private void resetScroll() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.clear();
        }
        this.stopNestedScroll(0);
        this.releaseGlows();
    }

    private void cancelScroll() {
        this.resetScroll();
        this.setScrollState(0);
    }

    private void onPointerUp(MotionEvent e) {
        int actionIndex = e.getActionIndex();
        if (e.getPointerId(actionIndex) == this.mScrollPointerId) {
            int newIndex = actionIndex == 0 ? 1 : 0;
            this.mScrollPointerId = e.getPointerId(newIndex);
            this.mInitialTouchX = this.mLastTouchX = (int)(e.getX(newIndex) + 0.5f);
            this.mInitialTouchY = this.mLastTouchY = (int)(e.getY(newIndex) + 0.5f);
        }
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        if (this.mLayout == null) {
            return false;
        }
        if (this.mLayoutSuppressed) {
            return false;
        }
        if (event.getAction() == 8) {
            float hScroll;
            float vScroll;
            if ((event.getSource() & 2) != 0) {
                vScroll = this.mLayout.canScrollVertically() ? -event.getAxisValue(9) : 0.0f;
                hScroll = this.mLayout.canScrollHorizontally() ? event.getAxisValue(10) : 0.0f;
            } else if ((event.getSource() & 0x400000) != 0) {
                float axisScroll = event.getAxisValue(26);
                if (this.mLayout.canScrollVertically()) {
                    vScroll = -axisScroll;
                    hScroll = 0.0f;
                } else if (this.mLayout.canScrollHorizontally()) {
                    vScroll = 0.0f;
                    hScroll = axisScroll;
                } else {
                    vScroll = 0.0f;
                    hScroll = 0.0f;
                }
            } else {
                vScroll = 0.0f;
                hScroll = 0.0f;
            }
            if (vScroll != 0.0f || hScroll != 0.0f) {
                this.nestedScrollByInternal((int)(hScroll * this.mScaledHorizontalScrollFactor), (int)(vScroll * this.mScaledVerticalScrollFactor), event, 1);
            }
        }
        return false;
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        if (this.mLayout == null) {
            this.defaultOnMeasure(widthSpec, heightSpec);
            return;
        }
        if (this.mLayout.isAutoMeasureEnabled()) {
            int widthMode = View.MeasureSpec.getMode((int)widthSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightSpec);
            this.mLayout.onMeasure(this.mRecycler, this.mState, widthSpec, heightSpec);
            boolean bl = this.mLastAutoMeasureSkippedDueToExact = widthMode == 0x40000000 && heightMode == 0x40000000;
            if (this.mLastAutoMeasureSkippedDueToExact || this.mAdapter == null) {
                return;
            }
            if (this.mState.mLayoutStep == 1) {
                this.dispatchLayoutStep1();
            }
            this.mLayout.setMeasureSpecs(widthSpec, heightSpec);
            this.mState.mIsMeasuring = true;
            this.dispatchLayoutStep2();
            this.mLayout.setMeasuredDimensionFromChildren(widthSpec, heightSpec);
            if (this.mLayout.shouldMeasureTwice()) {
                this.mLayout.setMeasureSpecs(View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000));
                this.mState.mIsMeasuring = true;
                this.dispatchLayoutStep2();
                this.mLayout.setMeasuredDimensionFromChildren(widthSpec, heightSpec);
            }
            this.mLastAutoMeasureNonExactMeasuredWidth = this.getMeasuredWidth();
            this.mLastAutoMeasureNonExactMeasuredHeight = this.getMeasuredHeight();
        } else {
            if (this.mHasFixedSize) {
                this.mLayout.onMeasure(this.mRecycler, this.mState, widthSpec, heightSpec);
                return;
            }
            if (this.mAdapterUpdateDuringMeasure) {
                this.startInterceptRequestLayout();
                this.onEnterLayoutOrScroll();
                this.processAdapterUpdatesAndSetAnimationFlags();
                this.onExitLayoutOrScroll();
                if (this.mState.mRunPredictiveAnimations) {
                    this.mState.mInPreLayout = true;
                } else {
                    this.mAdapterHelper.consumeUpdatesInOnePass();
                    this.mState.mInPreLayout = false;
                }
                this.mAdapterUpdateDuringMeasure = false;
                this.stopInterceptRequestLayout(false);
            } else if (this.mState.mRunPredictiveAnimations) {
                this.setMeasuredDimension(this.getMeasuredWidth(), this.getMeasuredHeight());
                return;
            }
            this.mState.mItemCount = this.mAdapter != null ? this.mAdapter.getItemCount() : 0;
            this.startInterceptRequestLayout();
            this.mLayout.onMeasure(this.mRecycler, this.mState, widthSpec, heightSpec);
            this.stopInterceptRequestLayout(false);
            this.mState.mInPreLayout = false;
        }
    }

    void defaultOnMeasure(int widthSpec, int heightSpec) {
        int width = LayoutManager.chooseSize(widthSpec, this.getPaddingLeft() + this.getPaddingRight(), ViewCompat.getMinimumWidth((View)this));
        int height = LayoutManager.chooseSize(heightSpec, this.getPaddingTop() + this.getPaddingBottom(), ViewCompat.getMinimumHeight((View)this));
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw || h != oldh) {
            this.invalidateGlows();
        }
    }

    public void setItemAnimator(@Nullable ItemAnimator animator) {
        if (this.mItemAnimator != null) {
            this.mItemAnimator.endAnimations();
            this.mItemAnimator.setListener(null);
        }
        this.mItemAnimator = animator;
        if (this.mItemAnimator != null) {
            this.mItemAnimator.setListener(this.mItemAnimatorListener);
        }
    }

    void onEnterLayoutOrScroll() {
        ++this.mLayoutOrScrollCounter;
    }

    void onExitLayoutOrScroll() {
        this.onExitLayoutOrScroll(true);
    }

    void onExitLayoutOrScroll(boolean enableChangeEvents) {
        --this.mLayoutOrScrollCounter;
        if (this.mLayoutOrScrollCounter < 1) {
            this.mLayoutOrScrollCounter = 0;
            if (enableChangeEvents) {
                this.dispatchContentChangedIfNecessary();
                this.dispatchPendingImportantForAccessibilityChanges();
            }
        }
    }

    boolean isAccessibilityEnabled() {
        return this.mAccessibilityManager != null && this.mAccessibilityManager.isEnabled();
    }

    private void dispatchContentChangedIfNecessary() {
        int flags = this.mEatenAccessibilityChangeFlags;
        this.mEatenAccessibilityChangeFlags = 0;
        if (flags != 0 && this.isAccessibilityEnabled()) {
            AccessibilityEvent event = AccessibilityEvent.obtain();
            event.setEventType(2048);
            AccessibilityEventCompat.setContentChangeTypes((AccessibilityEvent)event, (int)flags);
            this.sendAccessibilityEventUnchecked(event);
        }
    }

    public boolean isComputingLayout() {
        return this.mLayoutOrScrollCounter > 0;
    }

    boolean shouldDeferAccessibilityEvent(AccessibilityEvent event) {
        if (this.isComputingLayout()) {
            int type = 0;
            if (event != null) {
                type = AccessibilityEventCompat.getContentChangeTypes((AccessibilityEvent)event);
            }
            if (type == 0) {
                type = 0;
            }
            this.mEatenAccessibilityChangeFlags |= type;
            return true;
        }
        return false;
    }

    public void sendAccessibilityEventUnchecked(AccessibilityEvent event) {
        if (this.shouldDeferAccessibilityEvent(event)) {
            return;
        }
        super.sendAccessibilityEventUnchecked(event);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    @Nullable
    public ItemAnimator getItemAnimator() {
        return this.mItemAnimator;
    }

    void postAnimationRunner() {
        if (!this.mPostedAnimatorRunner && this.mIsAttached) {
            ViewCompat.postOnAnimation((View)this, (Runnable)this.mItemAnimatorRunner);
            this.mPostedAnimatorRunner = true;
        }
    }

    private boolean predictiveItemAnimationsEnabled() {
        return this.mItemAnimator != null && this.mLayout.supportsPredictiveItemAnimations();
    }

    private void processAdapterUpdatesAndSetAnimationFlags() {
        if (this.mDataSetHasChangedAfterLayout) {
            this.mAdapterHelper.reset();
            if (this.mDispatchItemsChangedEvent) {
                this.mLayout.onItemsChanged(this);
            }
        }
        if (this.predictiveItemAnimationsEnabled()) {
            this.mAdapterHelper.preProcess();
        } else {
            this.mAdapterHelper.consumeUpdatesInOnePass();
        }
        boolean animationTypeSupported = this.mItemsAddedOrRemoved || this.mItemsChanged;
        this.mState.mRunSimpleAnimations = !(!this.mFirstLayoutComplete || this.mItemAnimator == null || !this.mDataSetHasChangedAfterLayout && !animationTypeSupported && !this.mLayout.mRequestedSimpleAnimations || this.mDataSetHasChangedAfterLayout && !this.mAdapter.hasStableIds());
        this.mState.mRunPredictiveAnimations = this.mState.mRunSimpleAnimations && animationTypeSupported && !this.mDataSetHasChangedAfterLayout && this.predictiveItemAnimationsEnabled();
    }

    void dispatchLayout() {
        if (this.mAdapter == null) {
            Log.w((String)TAG, (String)"No adapter attached; skipping layout");
            return;
        }
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"No layout manager attached; skipping layout");
            return;
        }
        this.mState.mIsMeasuring = false;
        boolean needsRemeasureDueToExactSkip = this.mLastAutoMeasureSkippedDueToExact && (this.mLastAutoMeasureNonExactMeasuredWidth != this.getWidth() || this.mLastAutoMeasureNonExactMeasuredHeight != this.getHeight());
        this.mLastAutoMeasureNonExactMeasuredWidth = 0;
        this.mLastAutoMeasureNonExactMeasuredHeight = 0;
        this.mLastAutoMeasureSkippedDueToExact = false;
        if (this.mState.mLayoutStep == 1) {
            this.dispatchLayoutStep1();
            this.mLayout.setExactMeasureSpecsFrom(this);
            this.dispatchLayoutStep2();
        } else if (this.mAdapterHelper.hasUpdates() || needsRemeasureDueToExactSkip || this.mLayout.getWidth() != this.getWidth() || this.mLayout.getHeight() != this.getHeight()) {
            this.mLayout.setExactMeasureSpecsFrom(this);
            this.dispatchLayoutStep2();
        } else {
            this.mLayout.setExactMeasureSpecsFrom(this);
        }
        this.dispatchLayoutStep3();
    }

    private void saveFocusInfo() {
        ViewHolder focusedVh;
        View child = null;
        if (this.mPreserveFocusAfterLayout && this.hasFocus() && this.mAdapter != null) {
            child = this.getFocusedChild();
        }
        ViewHolder viewHolder = focusedVh = child == null ? null : this.findContainingViewHolder(child);
        if (focusedVh == null) {
            this.resetFocusInfo();
        } else {
            long l = this.mState.mFocusedItemId = this.mAdapter.hasStableIds() ? focusedVh.getItemId() : -1L;
            this.mState.mFocusedItemPosition = this.mDataSetHasChangedAfterLayout ? -1 : (focusedVh.isRemoved() ? focusedVh.mOldPosition : focusedVh.getAbsoluteAdapterPosition());
            this.mState.mFocusedSubChildId = this.getDeepestFocusedViewWithId(focusedVh.itemView);
        }
    }

    private void resetFocusInfo() {
        this.mState.mFocusedItemId = -1L;
        this.mState.mFocusedItemPosition = -1;
        this.mState.mFocusedSubChildId = -1;
    }

    @Nullable
    private View findNextViewToFocus() {
        ViewHolder nextFocus;
        int startFocusSearchIndex = this.mState.mFocusedItemPosition != -1 ? this.mState.mFocusedItemPosition : 0;
        int itemCount = this.mState.getItemCount();
        for (int i = startFocusSearchIndex; i < itemCount && (nextFocus = this.findViewHolderForAdapterPosition(i)) != null; ++i) {
            if (!nextFocus.itemView.hasFocusable()) continue;
            return nextFocus.itemView;
        }
        int limit = Math.min(itemCount, startFocusSearchIndex);
        for (int i = limit - 1; i >= 0; --i) {
            nextFocus = this.findViewHolderForAdapterPosition(i);
            if (nextFocus == null) {
                return null;
            }
            if (!nextFocus.itemView.hasFocusable()) continue;
            return nextFocus.itemView;
        }
        return null;
    }

    private void recoverFocusFromState() {
        if (!this.mPreserveFocusAfterLayout || this.mAdapter == null || !this.hasFocus() || this.getDescendantFocusability() == 393216 || this.getDescendantFocusability() == 131072 && this.isFocused()) {
            return;
        }
        if (!this.isFocused()) {
            View focusedChild = this.getFocusedChild();
            if (IGNORE_DETACHED_FOCUSED_CHILD && (focusedChild.getParent() == null || !focusedChild.hasFocus())) {
                if (this.mChildHelper.getChildCount() == 0) {
                    this.requestFocus();
                    return;
                }
            } else if (!this.mChildHelper.isHidden(focusedChild)) {
                return;
            }
        }
        ViewHolder focusTarget = null;
        if (this.mState.mFocusedItemId != -1L && this.mAdapter.hasStableIds()) {
            focusTarget = this.findViewHolderForItemId(this.mState.mFocusedItemId);
        }
        View viewToFocus = null;
        if (focusTarget == null || this.mChildHelper.isHidden(focusTarget.itemView) || !focusTarget.itemView.hasFocusable()) {
            if (this.mChildHelper.getChildCount() > 0) {
                viewToFocus = this.findNextViewToFocus();
            }
        } else {
            viewToFocus = focusTarget.itemView;
        }
        if (viewToFocus != null) {
            View child;
            if ((long)this.mState.mFocusedSubChildId != -1L && (child = viewToFocus.findViewById(this.mState.mFocusedSubChildId)) != null && child.isFocusable()) {
                viewToFocus = child;
            }
            viewToFocus.requestFocus();
        }
    }

    private int getDeepestFocusedViewWithId(View view) {
        int lastKnownId = view.getId();
        while (!view.isFocused() && view instanceof ViewGroup && view.hasFocus()) {
            int id2 = (view = ((ViewGroup)view).getFocusedChild()).getId();
            if (id2 == -1) continue;
            lastKnownId = view.getId();
        }
        return lastKnownId;
    }

    final void fillRemainingScrollValues(State state) {
        if (this.getScrollState() == 2) {
            OverScroller scroller = this.mViewFlinger.mOverScroller;
            state.mRemainingScrollHorizontal = scroller.getFinalX() - scroller.getCurrX();
            state.mRemainingScrollVertical = scroller.getFinalY() - scroller.getCurrY();
        } else {
            state.mRemainingScrollHorizontal = 0;
            state.mRemainingScrollVertical = 0;
        }
    }

    private void dispatchLayoutStep1() {
        int i;
        this.mState.assertLayoutStep(1);
        this.fillRemainingScrollValues(this.mState);
        this.mState.mIsMeasuring = false;
        this.startInterceptRequestLayout();
        this.mViewInfoStore.clear();
        this.onEnterLayoutOrScroll();
        this.processAdapterUpdatesAndSetAnimationFlags();
        this.saveFocusInfo();
        this.mState.mTrackOldChangeHolders = this.mState.mRunSimpleAnimations && this.mItemsChanged;
        this.mItemsChanged = false;
        this.mItemsAddedOrRemoved = false;
        this.mState.mInPreLayout = this.mState.mRunPredictiveAnimations;
        this.mState.mItemCount = this.mAdapter.getItemCount();
        this.findMinMaxChildLayoutPositions(this.mMinMaxLayoutPositions);
        if (this.mState.mRunSimpleAnimations) {
            int count = this.mChildHelper.getChildCount();
            for (i = 0; i < count; ++i) {
                ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
                if (holder.shouldIgnore() || holder.isInvalid() && !this.mAdapter.hasStableIds()) continue;
                ItemAnimator.ItemHolderInfo animationInfo = this.mItemAnimator.recordPreLayoutInformation(this.mState, holder, ItemAnimator.buildAdapterChangeFlagsForAnimations(holder), holder.getUnmodifiedPayloads());
                this.mViewInfoStore.addToPreLayout(holder, animationInfo);
                if (!this.mState.mTrackOldChangeHolders || !holder.isUpdated() || holder.isRemoved() || holder.shouldIgnore() || holder.isInvalid()) continue;
                long key = this.getChangedHolderKey(holder);
                this.mViewInfoStore.addToOldChangeHolders(key, holder);
            }
        }
        if (this.mState.mRunPredictiveAnimations) {
            this.saveOldPositions();
            boolean didStructureChange = this.mState.mStructureChanged;
            this.mState.mStructureChanged = false;
            this.mLayout.onLayoutChildren(this.mRecycler, this.mState);
            this.mState.mStructureChanged = didStructureChange;
            for (i = 0; i < this.mChildHelper.getChildCount(); ++i) {
                View child = this.mChildHelper.getChildAt(i);
                ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(child);
                if (viewHolder.shouldIgnore() || this.mViewInfoStore.isInPreLayout(viewHolder)) continue;
                int flags = ItemAnimator.buildAdapterChangeFlagsForAnimations(viewHolder);
                boolean wasHidden = viewHolder.hasAnyOfTheFlags(8192);
                if (!wasHidden) {
                    flags |= 0x1000;
                }
                ItemAnimator.ItemHolderInfo animationInfo = this.mItemAnimator.recordPreLayoutInformation(this.mState, viewHolder, flags, viewHolder.getUnmodifiedPayloads());
                if (wasHidden) {
                    this.recordAnimationInfoIfBouncedHiddenView(viewHolder, animationInfo);
                    continue;
                }
                this.mViewInfoStore.addToAppearedInPreLayoutHolders(viewHolder, animationInfo);
            }
            this.clearOldPositions();
        } else {
            this.clearOldPositions();
        }
        this.onExitLayoutOrScroll();
        this.stopInterceptRequestLayout(false);
        this.mState.mLayoutStep = 2;
    }

    private void dispatchLayoutStep2() {
        this.startInterceptRequestLayout();
        this.onEnterLayoutOrScroll();
        this.mState.assertLayoutStep(6);
        this.mAdapterHelper.consumeUpdatesInOnePass();
        this.mState.mItemCount = this.mAdapter.getItemCount();
        this.mState.mDeletedInvisibleItemCountSincePreviousLayout = 0;
        if (this.mPendingSavedState != null && this.mAdapter.canRestoreState()) {
            if (this.mPendingSavedState.mLayoutState != null) {
                this.mLayout.onRestoreInstanceState(this.mPendingSavedState.mLayoutState);
            }
            this.mPendingSavedState = null;
        }
        this.mState.mInPreLayout = false;
        this.mLayout.onLayoutChildren(this.mRecycler, this.mState);
        this.mState.mStructureChanged = false;
        this.mState.mRunSimpleAnimations = this.mState.mRunSimpleAnimations && this.mItemAnimator != null;
        this.mState.mLayoutStep = 4;
        this.onExitLayoutOrScroll();
        this.stopInterceptRequestLayout(false);
    }

    private void dispatchLayoutStep3() {
        this.mState.assertLayoutStep(4);
        this.startInterceptRequestLayout();
        this.onEnterLayoutOrScroll();
        this.mState.mLayoutStep = 1;
        if (this.mState.mRunSimpleAnimations) {
            for (int i = this.mChildHelper.getChildCount() - 1; i >= 0; --i) {
                ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
                if (holder.shouldIgnore()) continue;
                long key = this.getChangedHolderKey(holder);
                ItemAnimator.ItemHolderInfo animationInfo = this.mItemAnimator.recordPostLayoutInformation(this.mState, holder);
                ViewHolder oldChangeViewHolder = this.mViewInfoStore.getFromOldChangeHolders(key);
                if (oldChangeViewHolder != null && !oldChangeViewHolder.shouldIgnore()) {
                    boolean oldDisappearing = this.mViewInfoStore.isDisappearing(oldChangeViewHolder);
                    boolean newDisappearing = this.mViewInfoStore.isDisappearing(holder);
                    if (oldDisappearing && oldChangeViewHolder == holder) {
                        this.mViewInfoStore.addToPostLayout(holder, animationInfo);
                        continue;
                    }
                    ItemAnimator.ItemHolderInfo preInfo = this.mViewInfoStore.popFromPreLayout(oldChangeViewHolder);
                    this.mViewInfoStore.addToPostLayout(holder, animationInfo);
                    ItemAnimator.ItemHolderInfo postInfo = this.mViewInfoStore.popFromPostLayout(holder);
                    if (preInfo == null) {
                        this.handleMissingPreInfoForChangeError(key, holder, oldChangeViewHolder);
                        continue;
                    }
                    this.animateChange(oldChangeViewHolder, holder, preInfo, postInfo, oldDisappearing, newDisappearing);
                    continue;
                }
                this.mViewInfoStore.addToPostLayout(holder, animationInfo);
            }
            this.mViewInfoStore.process(this.mViewInfoProcessCallback);
        }
        this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
        this.mState.mPreviousLayoutItemCount = this.mState.mItemCount;
        this.mDataSetHasChangedAfterLayout = false;
        this.mDispatchItemsChangedEvent = false;
        this.mState.mRunSimpleAnimations = false;
        this.mState.mRunPredictiveAnimations = false;
        this.mLayout.mRequestedSimpleAnimations = false;
        if (this.mRecycler.mChangedScrap != null) {
            this.mRecycler.mChangedScrap.clear();
        }
        if (this.mLayout.mPrefetchMaxObservedInInitialPrefetch) {
            this.mLayout.mPrefetchMaxCountObserved = 0;
            this.mLayout.mPrefetchMaxObservedInInitialPrefetch = false;
            this.mRecycler.updateViewCacheSize();
        }
        this.mLayout.onLayoutCompleted(this.mState);
        this.onExitLayoutOrScroll();
        this.stopInterceptRequestLayout(false);
        this.mViewInfoStore.clear();
        if (this.didChildRangeChange(this.mMinMaxLayoutPositions[0], this.mMinMaxLayoutPositions[1])) {
            this.dispatchOnScrolled(0, 0);
        }
        this.recoverFocusFromState();
        this.resetFocusInfo();
    }

    private void handleMissingPreInfoForChangeError(long key, ViewHolder holder, ViewHolder oldChangeViewHolder) {
        int childCount = this.mChildHelper.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            long otherKey;
            View view = this.mChildHelper.getChildAt(i);
            ViewHolder other = RecyclerView.getChildViewHolderInt(view);
            if (other == holder || (otherKey = this.getChangedHolderKey(other)) != key) continue;
            if (this.mAdapter != null && this.mAdapter.hasStableIds()) {
                throw new IllegalStateException("Two different ViewHolders have the same stable ID. Stable IDs in your adapter MUST BE unique and SHOULD NOT change.\n ViewHolder 1:" + other + " \n View Holder 2:" + holder + this.exceptionLabel());
            }
            throw new IllegalStateException("Two different ViewHolders have the same change ID. This might happen due to inconsistent Adapter update events or if the LayoutManager lays out the same View multiple times.\n ViewHolder 1:" + other + " \n View Holder 2:" + holder + this.exceptionLabel());
        }
        Log.e((String)TAG, (String)("Problem while matching changed view holders with the newones. The pre-layout information for the change holder " + oldChangeViewHolder + " cannot be found but it is necessary for " + holder + this.exceptionLabel()));
    }

    void recordAnimationInfoIfBouncedHiddenView(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo animationInfo) {
        viewHolder.setFlags(0, 8192);
        if (this.mState.mTrackOldChangeHolders && viewHolder.isUpdated() && !viewHolder.isRemoved() && !viewHolder.shouldIgnore()) {
            long key = this.getChangedHolderKey(viewHolder);
            this.mViewInfoStore.addToOldChangeHolders(key, viewHolder);
        }
        this.mViewInfoStore.addToPreLayout(viewHolder, animationInfo);
    }

    private void findMinMaxChildLayoutPositions(int[] into) {
        int count = this.mChildHelper.getChildCount();
        if (count == 0) {
            into[0] = -1;
            into[1] = -1;
            return;
        }
        int minPositionPreLayout = Integer.MAX_VALUE;
        int maxPositionPreLayout = Integer.MIN_VALUE;
        for (int i = 0; i < count; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
            if (holder.shouldIgnore()) continue;
            int pos = holder.getLayoutPosition();
            if (pos < minPositionPreLayout) {
                minPositionPreLayout = pos;
            }
            if (pos <= maxPositionPreLayout) continue;
            maxPositionPreLayout = pos;
        }
        into[0] = minPositionPreLayout;
        into[1] = maxPositionPreLayout;
    }

    private boolean didChildRangeChange(int minPositionPreLayout, int maxPositionPreLayout) {
        this.findMinMaxChildLayoutPositions(this.mMinMaxLayoutPositions);
        return this.mMinMaxLayoutPositions[0] != minPositionPreLayout || this.mMinMaxLayoutPositions[1] != maxPositionPreLayout;
    }

    protected void removeDetachedView(View child, boolean animate) {
        ViewHolder vh = RecyclerView.getChildViewHolderInt(child);
        if (vh != null) {
            if (vh.isTmpDetached()) {
                vh.clearTmpDetachFlag();
            } else if (!vh.shouldIgnore()) {
                throw new IllegalArgumentException("Called removeDetachedView with a view which is not flagged as tmp detached." + vh + this.exceptionLabel());
            }
        }
        child.clearAnimation();
        this.dispatchChildDetached(child);
        super.removeDetachedView(child, animate);
    }

    long getChangedHolderKey(ViewHolder holder) {
        return this.mAdapter.hasStableIds() ? holder.getItemId() : (long)holder.mPosition;
    }

    void animateAppearance(@NonNull ViewHolder itemHolder, @Nullable ItemAnimator.ItemHolderInfo preLayoutInfo, @NonNull ItemAnimator.ItemHolderInfo postLayoutInfo) {
        itemHolder.setIsRecyclable(false);
        if (this.mItemAnimator.animateAppearance(itemHolder, preLayoutInfo, postLayoutInfo)) {
            this.postAnimationRunner();
        }
    }

    void animateDisappearance(@NonNull ViewHolder holder, @NonNull ItemAnimator.ItemHolderInfo preLayoutInfo, @Nullable ItemAnimator.ItemHolderInfo postLayoutInfo) {
        this.addAnimatingView(holder);
        holder.setIsRecyclable(false);
        if (this.mItemAnimator.animateDisappearance(holder, preLayoutInfo, postLayoutInfo)) {
            this.postAnimationRunner();
        }
    }

    private void animateChange(@NonNull ViewHolder oldHolder, @NonNull ViewHolder newHolder, @NonNull ItemAnimator.ItemHolderInfo preInfo, @NonNull ItemAnimator.ItemHolderInfo postInfo, boolean oldHolderDisappearing, boolean newHolderDisappearing) {
        oldHolder.setIsRecyclable(false);
        if (oldHolderDisappearing) {
            this.addAnimatingView(oldHolder);
        }
        if (oldHolder != newHolder) {
            if (newHolderDisappearing) {
                this.addAnimatingView(newHolder);
            }
            oldHolder.mShadowedHolder = newHolder;
            this.addAnimatingView(oldHolder);
            this.mRecycler.unscrapView(oldHolder);
            newHolder.setIsRecyclable(false);
            newHolder.mShadowingHolder = oldHolder;
        }
        if (this.mItemAnimator.animateChange(oldHolder, newHolder, preInfo, postInfo)) {
            this.postAnimationRunner();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        TraceCompat.beginSection((String)TRACE_ON_LAYOUT_TAG);
        this.dispatchLayout();
        TraceCompat.endSection();
        this.mFirstLayoutComplete = true;
    }

    public void requestLayout() {
        if (this.mInterceptRequestLayoutDepth == 0 && !this.mLayoutSuppressed) {
            super.requestLayout();
        } else {
            this.mLayoutWasDefered = true;
        }
    }

    void markItemDecorInsetsDirty() {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.mChildHelper.getUnfilteredChildAt(i);
            ((LayoutParams)child.getLayoutParams()).mInsetsDirty = true;
        }
        this.mRecycler.markItemDecorInsetsDirty();
    }

    public void draw(Canvas c) {
        int restore;
        super.draw(c);
        int count = this.mItemDecorations.size();
        for (int i = 0; i < count; ++i) {
            this.mItemDecorations.get(i).onDrawOver(c, this, this.mState);
        }
        boolean needsInvalidate = false;
        if (this.mLeftGlow != null && !this.mLeftGlow.isFinished()) {
            restore = c.save();
            int padding = this.mClipToPadding ? this.getPaddingBottom() : 0;
            c.rotate(270.0f);
            c.translate((float)(-this.getHeight() + padding), 0.0f);
            needsInvalidate = this.mLeftGlow != null && this.mLeftGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (this.mTopGlow != null && !this.mTopGlow.isFinished()) {
            restore = c.save();
            if (this.mClipToPadding) {
                c.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            }
            needsInvalidate |= this.mTopGlow != null && this.mTopGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (this.mRightGlow != null && !this.mRightGlow.isFinished()) {
            restore = c.save();
            int width = this.getWidth();
            int padding = this.mClipToPadding ? this.getPaddingTop() : 0;
            c.rotate(90.0f);
            c.translate((float)padding, (float)(-width));
            needsInvalidate |= this.mRightGlow != null && this.mRightGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (this.mBottomGlow != null && !this.mBottomGlow.isFinished()) {
            restore = c.save();
            c.rotate(180.0f);
            if (this.mClipToPadding) {
                c.translate((float)(-this.getWidth() + this.getPaddingRight()), (float)(-this.getHeight() + this.getPaddingBottom()));
            } else {
                c.translate((float)(-this.getWidth()), (float)(-this.getHeight()));
            }
            needsInvalidate |= this.mBottomGlow != null && this.mBottomGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (!needsInvalidate && this.mItemAnimator != null && this.mItemDecorations.size() > 0 && this.mItemAnimator.isRunning()) {
            needsInvalidate = true;
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void onDraw(Canvas c) {
        super.onDraw(c);
        int count = this.mItemDecorations.size();
        for (int i = 0; i < count; ++i) {
            this.mItemDecorations.get(i).onDraw(c, this, this.mState);
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && this.mLayout.checkLayoutParams((LayoutParams)p);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager" + this.exceptionLabel());
        }
        return this.mLayout.generateDefaultLayoutParams();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager" + this.exceptionLabel());
        }
        return this.mLayout.generateLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager" + this.exceptionLabel());
        }
        return this.mLayout.generateLayoutParams(p);
    }

    public boolean isAnimating() {
        return this.mItemAnimator != null && this.mItemAnimator.isRunning();
    }

    void saveOldPositions() {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder.shouldIgnore()) continue;
            holder.saveOldPosition();
        }
    }

    void clearOldPositions() {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder.shouldIgnore()) continue;
            holder.clearOldPosition();
        }
        this.mRecycler.clearOldPositions();
    }

    void offsetPositionRecordsForMove(int from, int to) {
        int inBetweenOffset;
        int end;
        int start;
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        if (from < to) {
            start = from;
            end = to;
            inBetweenOffset = -1;
        } else {
            start = to;
            end = from;
            inBetweenOffset = 1;
        }
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.mPosition < start || holder.mPosition > end) continue;
            if (holder.mPosition == from) {
                holder.offsetPosition(to - from, false);
            } else {
                holder.offsetPosition(inBetweenOffset, false);
            }
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForMove(from, to);
        this.requestLayout();
    }

    void offsetPositionRecordsForInsert(int positionStart, int itemCount) {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.shouldIgnore() || holder.mPosition < positionStart) continue;
            holder.offsetPosition(itemCount, false);
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForInsert(positionStart, itemCount);
        this.requestLayout();
    }

    void offsetPositionRecordsForRemove(int positionStart, int itemCount, boolean applyToPreLayout) {
        int positionEnd = positionStart + itemCount;
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.shouldIgnore()) continue;
            if (holder.mPosition >= positionEnd) {
                holder.offsetPosition(-itemCount, applyToPreLayout);
                this.mState.mStructureChanged = true;
                continue;
            }
            if (holder.mPosition < positionStart) continue;
            holder.flagRemovedAndOffsetPosition(positionStart - 1, -itemCount, applyToPreLayout);
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForRemove(positionStart, itemCount, applyToPreLayout);
        this.requestLayout();
    }

    void viewRangeUpdate(int positionStart, int itemCount, Object payload) {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        int positionEnd = positionStart + itemCount;
        for (int i = 0; i < childCount; ++i) {
            View child = this.mChildHelper.getUnfilteredChildAt(i);
            ViewHolder holder = RecyclerView.getChildViewHolderInt(child);
            if (holder == null || holder.shouldIgnore() || holder.mPosition < positionStart || holder.mPosition >= positionEnd) continue;
            holder.addFlags(2);
            holder.addChangePayload(payload);
            ((LayoutParams)child.getLayoutParams()).mInsetsDirty = true;
        }
        this.mRecycler.viewRangeUpdate(positionStart, itemCount);
    }

    boolean canReuseUpdatedViewHolder(ViewHolder viewHolder) {
        return this.mItemAnimator == null || this.mItemAnimator.canReuseUpdatedViewHolder(viewHolder, viewHolder.getUnmodifiedPayloads());
    }

    void processDataSetCompletelyChanged(boolean dispatchItemsChanged) {
        this.mDispatchItemsChangedEvent |= dispatchItemsChanged;
        this.mDataSetHasChangedAfterLayout = true;
        this.markKnownViewsInvalid();
    }

    void markKnownViewsInvalid() {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.shouldIgnore()) continue;
            holder.addFlags(6);
        }
        this.markItemDecorInsetsDirty();
        this.mRecycler.markKnownViewsInvalid();
    }

    public void invalidateItemDecorations() {
        if (this.mItemDecorations.size() == 0) {
            return;
        }
        if (this.mLayout != null) {
            this.mLayout.assertNotInLayoutOrScroll("Cannot invalidate item decorations during a scroll or layout");
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    public boolean getPreserveFocusAfterLayout() {
        return this.mPreserveFocusAfterLayout;
    }

    public void setPreserveFocusAfterLayout(boolean preserveFocusAfterLayout) {
        this.mPreserveFocusAfterLayout = preserveFocusAfterLayout;
    }

    public ViewHolder getChildViewHolder(@NonNull View child) {
        ViewParent parent = child.getParent();
        if (parent != null && parent != this) {
            throw new IllegalArgumentException("View " + child + " is not a direct child of " + (Object)((Object)this));
        }
        return RecyclerView.getChildViewHolderInt(child);
    }

    @Nullable
    public View findContainingItemView(@NonNull View view) {
        ViewParent parent = view.getParent();
        while (parent != null && parent != this && parent instanceof View) {
            view = (View)parent;
            parent = view.getParent();
        }
        return parent == this ? view : null;
    }

    @Nullable
    public ViewHolder findContainingViewHolder(@NonNull View view) {
        View itemView = this.findContainingItemView(view);
        return itemView == null ? null : this.getChildViewHolder(itemView);
    }

    static ViewHolder getChildViewHolderInt(View child) {
        if (child == null) {
            return null;
        }
        return ((LayoutParams)child.getLayoutParams()).mViewHolder;
    }

    @Deprecated
    public int getChildPosition(@NonNull View child) {
        return this.getChildAdapterPosition(child);
    }

    public int getChildAdapterPosition(@NonNull View child) {
        ViewHolder holder = RecyclerView.getChildViewHolderInt(child);
        return holder != null ? holder.getAbsoluteAdapterPosition() : -1;
    }

    public int getChildLayoutPosition(@NonNull View child) {
        ViewHolder holder = RecyclerView.getChildViewHolderInt(child);
        return holder != null ? holder.getLayoutPosition() : -1;
    }

    public long getChildItemId(@NonNull View child) {
        if (this.mAdapter == null || !this.mAdapter.hasStableIds()) {
            return -1L;
        }
        ViewHolder holder = RecyclerView.getChildViewHolderInt(child);
        return holder != null ? holder.getItemId() : -1L;
    }

    @Deprecated
    @Nullable
    public ViewHolder findViewHolderForPosition(int position) {
        return this.findViewHolderForPosition(position, false);
    }

    @Nullable
    public ViewHolder findViewHolderForLayoutPosition(int position) {
        return this.findViewHolderForPosition(position, false);
    }

    @Nullable
    public ViewHolder findViewHolderForAdapterPosition(int position) {
        if (this.mDataSetHasChangedAfterLayout) {
            return null;
        }
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        ViewHolder hidden = null;
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.isRemoved() || this.getAdapterPositionInRecyclerView(holder) != position) continue;
            if (this.mChildHelper.isHidden(holder.itemView)) {
                hidden = holder;
                continue;
            }
            return holder;
        }
        return hidden;
    }

    @Nullable
    ViewHolder findViewHolderForPosition(int position, boolean checkNewPosition) {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        ViewHolder hidden = null;
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.isRemoved() || (!checkNewPosition ? holder.getLayoutPosition() != position : holder.mPosition != position)) continue;
            if (this.mChildHelper.isHidden(holder.itemView)) {
                hidden = holder;
                continue;
            }
            return holder;
        }
        return hidden;
    }

    public ViewHolder findViewHolderForItemId(long id2) {
        if (this.mAdapter == null || !this.mAdapter.hasStableIds()) {
            return null;
        }
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        ViewHolder hidden = null;
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.isRemoved() || holder.getItemId() != id2) continue;
            if (this.mChildHelper.isHidden(holder.itemView)) {
                hidden = holder;
                continue;
            }
            return holder;
        }
        return hidden;
    }

    @Nullable
    public View findChildViewUnder(float x, float y) {
        int count = this.mChildHelper.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            View child = this.mChildHelper.getChildAt(i);
            float translationX = child.getTranslationX();
            float translationY = child.getTranslationY();
            if (!(x >= (float)child.getLeft() + translationX) || !(x <= (float)child.getRight() + translationX) || !(y >= (float)child.getTop() + translationY) || !(y <= (float)child.getBottom() + translationY)) continue;
            return child;
        }
        return null;
    }

    public boolean drawChild(Canvas canvas, View child, long drawingTime) {
        return super.drawChild(canvas, child, drawingTime);
    }

    public void offsetChildrenVertical(@Px int dy) {
        int childCount = this.mChildHelper.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.mChildHelper.getChildAt(i).offsetTopAndBottom(dy);
        }
    }

    public void onChildAttachedToWindow(@NonNull View child) {
    }

    public void onChildDetachedFromWindow(@NonNull View child) {
    }

    public void offsetChildrenHorizontal(@Px int dx) {
        int childCount = this.mChildHelper.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.mChildHelper.getChildAt(i).offsetLeftAndRight(dx);
        }
    }

    public void getDecoratedBoundsWithMargins(@NonNull View view, @NonNull Rect outBounds) {
        RecyclerView.getDecoratedBoundsWithMarginsInt(view, outBounds);
    }

    static void getDecoratedBoundsWithMarginsInt(View view, Rect outBounds) {
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        Rect insets = lp.mDecorInsets;
        outBounds.set(view.getLeft() - insets.left - lp.leftMargin, view.getTop() - insets.top - lp.topMargin, view.getRight() + insets.right + lp.rightMargin, view.getBottom() + insets.bottom + lp.bottomMargin);
    }

    Rect getItemDecorInsetsForChild(View child) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (!lp.mInsetsDirty) {
            return lp.mDecorInsets;
        }
        if (this.mState.isPreLayout() && (lp.isItemChanged() || lp.isViewInvalid())) {
            return lp.mDecorInsets;
        }
        Rect insets = lp.mDecorInsets;
        insets.set(0, 0, 0, 0);
        int decorCount = this.mItemDecorations.size();
        for (int i = 0; i < decorCount; ++i) {
            this.mTempRect.set(0, 0, 0, 0);
            this.mItemDecorations.get(i).getItemOffsets(this.mTempRect, child, this, this.mState);
            insets.left += this.mTempRect.left;
            insets.top += this.mTempRect.top;
            insets.right += this.mTempRect.right;
            insets.bottom += this.mTempRect.bottom;
        }
        lp.mInsetsDirty = false;
        return insets;
    }

    public void onScrolled(@Px int dx, @Px int dy) {
    }

    void dispatchOnScrolled(int hresult, int vresult) {
        ++this.mDispatchScrollCounter;
        int scrollX = this.getScrollX();
        int scrollY = this.getScrollY();
        this.onScrollChanged(scrollX, scrollY, scrollX - hresult, scrollY - vresult);
        this.onScrolled(hresult, vresult);
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrolled(this, hresult, vresult);
        }
        if (this.mScrollListeners != null) {
            for (int i = this.mScrollListeners.size() - 1; i >= 0; --i) {
                this.mScrollListeners.get(i).onScrolled(this, hresult, vresult);
            }
        }
        --this.mDispatchScrollCounter;
    }

    public void onScrollStateChanged(int state) {
    }

    private float getSplineFlingDistance(int velocity) {
        double l = Math.log(0.35f * (float)Math.abs(velocity) / (0.015f * this.mPhysicalCoef));
        double decelMinusOne = (double)DECELERATION_RATE - 1.0;
        return (float)((double)(0.015f * this.mPhysicalCoef) * Math.exp((double)DECELERATION_RATE / decelMinusOne * l));
    }

    void dispatchOnScrollStateChanged(int state) {
        if (this.mLayout != null) {
            this.mLayout.onScrollStateChanged(state);
        }
        this.onScrollStateChanged(state);
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(this, state);
        }
        if (this.mScrollListeners != null) {
            for (int i = this.mScrollListeners.size() - 1; i >= 0; --i) {
                this.mScrollListeners.get(i).onScrollStateChanged(this, state);
            }
        }
    }

    public boolean hasPendingAdapterUpdates() {
        return !this.mFirstLayoutComplete || this.mDataSetHasChangedAfterLayout || this.mAdapterHelper.hasPendingUpdates();
    }

    void repositionShadowingViews() {
        int count = this.mChildHelper.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.mChildHelper.getChildAt(i);
            ViewHolder holder = this.getChildViewHolder(view);
            if (holder == null || holder.mShadowingHolder == null) continue;
            View shadowingView = holder.mShadowingHolder.itemView;
            int left = view.getLeft();
            int top = view.getTop();
            if (left == shadowingView.getLeft() && top == shadowingView.getTop()) continue;
            shadowingView.layout(left, top, left + shadowingView.getWidth(), top + shadowingView.getHeight());
        }
    }

    @Nullable
    static RecyclerView findNestedRecyclerView(@NonNull View view) {
        if (!(view instanceof ViewGroup)) {
            return null;
        }
        if (view instanceof RecyclerView) {
            return (RecyclerView)view;
        }
        ViewGroup parent = (ViewGroup)view;
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView descendant = RecyclerView.findNestedRecyclerView(child);
            if (descendant == null) continue;
            return descendant;
        }
        return null;
    }

    static void clearNestedRecyclerViewIfNotNested(@NonNull ViewHolder holder) {
        if (holder.mNestedRecyclerView != null) {
            View item = (View)holder.mNestedRecyclerView.get();
            while (item != null) {
                if (item == holder.itemView) {
                    return;
                }
                ViewParent parent = item.getParent();
                if (parent instanceof View) {
                    item = (View)parent;
                    continue;
                }
                item = null;
            }
            holder.mNestedRecyclerView = null;
        }
    }

    long getNanoTime() {
        if (ALLOW_THREAD_GAP_WORK) {
            return System.nanoTime();
        }
        return 0L;
    }

    void dispatchChildDetached(View child) {
        ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(child);
        this.onChildDetachedFromWindow(child);
        if (this.mAdapter != null && viewHolder != null) {
            this.mAdapter.onViewDetachedFromWindow(viewHolder);
        }
        if (this.mOnChildAttachStateListeners != null) {
            int cnt = this.mOnChildAttachStateListeners.size();
            for (int i = cnt - 1; i >= 0; --i) {
                this.mOnChildAttachStateListeners.get(i).onChildViewDetachedFromWindow(child);
            }
        }
    }

    void dispatchChildAttached(View child) {
        ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(child);
        this.onChildAttachedToWindow(child);
        if (this.mAdapter != null && viewHolder != null) {
            this.mAdapter.onViewAttachedToWindow(viewHolder);
        }
        if (this.mOnChildAttachStateListeners != null) {
            int cnt = this.mOnChildAttachStateListeners.size();
            for (int i = cnt - 1; i >= 0; --i) {
                this.mOnChildAttachStateListeners.get(i).onChildViewAttachedToWindow(child);
            }
        }
    }

    @VisibleForTesting
    boolean setChildImportantForAccessibilityInternal(ViewHolder viewHolder, int importantForAccessibility) {
        if (this.isComputingLayout()) {
            viewHolder.mPendingAccessibilityState = importantForAccessibility;
            this.mPendingAccessibilityImportanceChange.add(viewHolder);
            return false;
        }
        ViewCompat.setImportantForAccessibility((View)viewHolder.itemView, (int)importantForAccessibility);
        return true;
    }

    void dispatchPendingImportantForAccessibilityChanges() {
        for (int i = this.mPendingAccessibilityImportanceChange.size() - 1; i >= 0; --i) {
            int state;
            ViewHolder viewHolder = this.mPendingAccessibilityImportanceChange.get(i);
            if (viewHolder.itemView.getParent() != this || viewHolder.shouldIgnore() || (state = viewHolder.mPendingAccessibilityState) == -1) continue;
            ViewCompat.setImportantForAccessibility((View)viewHolder.itemView, (int)state);
            viewHolder.mPendingAccessibilityState = -1;
        }
        this.mPendingAccessibilityImportanceChange.clear();
    }

    int getAdapterPositionInRecyclerView(ViewHolder viewHolder) {
        if (viewHolder.hasAnyOfTheFlags(524) || !viewHolder.isBound()) {
            return -1;
        }
        return this.mAdapterHelper.applyPendingUpdatesToPosition(viewHolder.mPosition);
    }

    @VisibleForTesting
    void initFastScroller(StateListDrawable verticalThumbDrawable, Drawable verticalTrackDrawable, StateListDrawable horizontalThumbDrawable, Drawable horizontalTrackDrawable) {
        if (verticalThumbDrawable == null || verticalTrackDrawable == null || horizontalThumbDrawable == null || horizontalTrackDrawable == null) {
            throw new IllegalArgumentException("Trying to set fast scroller without both required drawables." + this.exceptionLabel());
        }
        Resources resources = this.getContext().getResources();
        new FastScroller(this, verticalThumbDrawable, verticalTrackDrawable, horizontalThumbDrawable, horizontalTrackDrawable, resources.getDimensionPixelSize(R.dimen.fastscroll_default_thickness), resources.getDimensionPixelSize(R.dimen.fastscroll_minimum_range), resources.getDimensionPixelOffset(R.dimen.fastscroll_margin));
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.getScrollingChildHelper().setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.getScrollingChildHelper().isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.getScrollingChildHelper().startNestedScroll(axes);
    }

    public boolean startNestedScroll(int axes, int type) {
        return this.getScrollingChildHelper().startNestedScroll(axes, type);
    }

    public void stopNestedScroll() {
        this.getScrollingChildHelper().stopNestedScroll();
    }

    public void stopNestedScroll(int type) {
        this.getScrollingChildHelper().stopNestedScroll(type);
    }

    public boolean hasNestedScrollingParent() {
        return this.getScrollingChildHelper().hasNestedScrollingParent();
    }

    public boolean hasNestedScrollingParent(int type) {
        return this.getScrollingChildHelper().hasNestedScrollingParent(type);
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.getScrollingChildHelper().dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow, int type) {
        return this.getScrollingChildHelper().dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow, type);
    }

    public final void dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow, int type, @NonNull int[] consumed) {
        this.getScrollingChildHelper().dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow, type, consumed);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.getScrollingChildHelper().dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow, int type) {
        return this.getScrollingChildHelper().dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow, type);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.getScrollingChildHelper().dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.getScrollingChildHelper().dispatchNestedPreFling(velocityX, velocityY);
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        if (this.mChildDrawingOrderCallback == null) {
            return super.getChildDrawingOrder(childCount, i);
        }
        return this.mChildDrawingOrderCallback.onGetChildDrawingOrder(childCount, i);
    }

    private NestedScrollingChildHelper getScrollingChildHelper() {
        if (this.mScrollingChildHelper == null) {
            this.mScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        }
        return this.mScrollingChildHelper;
    }

    public static interface ChildDrawingOrderCallback {
        public int onGetChildDrawingOrder(int var1, int var2);
    }

    public static abstract class ItemAnimator {
        public static final int FLAG_CHANGED = 2;
        public static final int FLAG_REMOVED = 8;
        public static final int FLAG_INVALIDATED = 4;
        public static final int FLAG_MOVED = 2048;
        public static final int FLAG_APPEARED_IN_PRE_LAYOUT = 4096;
        private ItemAnimatorListener mListener = null;
        private ArrayList<ItemAnimatorFinishedListener> mFinishedListeners = new ArrayList();
        private long mAddDuration = 120L;
        private long mRemoveDuration = 120L;
        private long mMoveDuration = 250L;
        private long mChangeDuration = 250L;

        public long getMoveDuration() {
            return this.mMoveDuration;
        }

        public void setMoveDuration(long moveDuration) {
            this.mMoveDuration = moveDuration;
        }

        public long getAddDuration() {
            return this.mAddDuration;
        }

        public void setAddDuration(long addDuration) {
            this.mAddDuration = addDuration;
        }

        public long getRemoveDuration() {
            return this.mRemoveDuration;
        }

        public void setRemoveDuration(long removeDuration) {
            this.mRemoveDuration = removeDuration;
        }

        public long getChangeDuration() {
            return this.mChangeDuration;
        }

        public void setChangeDuration(long changeDuration) {
            this.mChangeDuration = changeDuration;
        }

        void setListener(ItemAnimatorListener listener) {
            this.mListener = listener;
        }

        @NonNull
        public ItemHolderInfo recordPreLayoutInformation(@NonNull State state, @NonNull ViewHolder viewHolder, int changeFlags, @NonNull List<Object> payloads) {
            return this.obtainHolderInfo().setFrom(viewHolder);
        }

        @NonNull
        public ItemHolderInfo recordPostLayoutInformation(@NonNull State state, @NonNull ViewHolder viewHolder) {
            return this.obtainHolderInfo().setFrom(viewHolder);
        }

        public abstract boolean animateDisappearance(@NonNull ViewHolder var1, @NonNull ItemHolderInfo var2, @Nullable ItemHolderInfo var3);

        public abstract boolean animateAppearance(@NonNull ViewHolder var1, @Nullable ItemHolderInfo var2, @NonNull ItemHolderInfo var3);

        public abstract boolean animatePersistence(@NonNull ViewHolder var1, @NonNull ItemHolderInfo var2, @NonNull ItemHolderInfo var3);

        public abstract boolean animateChange(@NonNull ViewHolder var1, @NonNull ViewHolder var2, @NonNull ItemHolderInfo var3, @NonNull ItemHolderInfo var4);

        static int buildAdapterChangeFlagsForAnimations(ViewHolder viewHolder) {
            int flags = viewHolder.mFlags & 0xE;
            if (viewHolder.isInvalid()) {
                return 4;
            }
            if ((flags & 4) == 0) {
                int oldPos = viewHolder.getOldPosition();
                int pos = viewHolder.getAbsoluteAdapterPosition();
                if (oldPos != -1 && pos != -1 && oldPos != pos) {
                    flags |= 0x800;
                }
            }
            return flags;
        }

        public abstract void runPendingAnimations();

        public abstract void endAnimation(@NonNull ViewHolder var1);

        public abstract void endAnimations();

        public abstract boolean isRunning();

        public final void dispatchAnimationFinished(@NonNull ViewHolder viewHolder) {
            this.onAnimationFinished(viewHolder);
            if (this.mListener != null) {
                this.mListener.onAnimationFinished(viewHolder);
            }
        }

        public void onAnimationFinished(@NonNull ViewHolder viewHolder) {
        }

        public final void dispatchAnimationStarted(@NonNull ViewHolder viewHolder) {
            this.onAnimationStarted(viewHolder);
        }

        public void onAnimationStarted(@NonNull ViewHolder viewHolder) {
        }

        public final boolean isRunning(@Nullable ItemAnimatorFinishedListener listener) {
            boolean running = this.isRunning();
            if (listener != null) {
                if (!running) {
                    listener.onAnimationsFinished();
                } else {
                    this.mFinishedListeners.add(listener);
                }
            }
            return running;
        }

        public boolean canReuseUpdatedViewHolder(@NonNull ViewHolder viewHolder) {
            return true;
        }

        public boolean canReuseUpdatedViewHolder(@NonNull ViewHolder viewHolder, @NonNull List<Object> payloads) {
            return this.canReuseUpdatedViewHolder(viewHolder);
        }

        public final void dispatchAnimationsFinished() {
            int count = this.mFinishedListeners.size();
            for (int i = 0; i < count; ++i) {
                this.mFinishedListeners.get(i).onAnimationsFinished();
            }
            this.mFinishedListeners.clear();
        }

        @NonNull
        public ItemHolderInfo obtainHolderInfo() {
            return new ItemHolderInfo();
        }

        public static class ItemHolderInfo {
            public int left;
            public int top;
            public int right;
            public int bottom;
            public int changeFlags;

            @NonNull
            public ItemHolderInfo setFrom(@NonNull ViewHolder holder) {
                return this.setFrom(holder, 0);
            }

            @NonNull
            public ItemHolderInfo setFrom(@NonNull ViewHolder holder, int flags) {
                View view = holder.itemView;
                this.left = view.getLeft();
                this.top = view.getTop();
                this.right = view.getRight();
                this.bottom = view.getBottom();
                return this;
            }
        }

        public static interface ItemAnimatorFinishedListener {
            public void onAnimationsFinished();
        }

        static interface ItemAnimatorListener {
            public void onAnimationFinished(@NonNull ViewHolder var1);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface AdapterChanges {
        }
    }

    private class ItemAnimatorRestoreListener
    implements ItemAnimator.ItemAnimatorListener {
        ItemAnimatorRestoreListener() {
        }

        @Override
        public void onAnimationFinished(ViewHolder item) {
            item.setIsRecyclable(true);
            if (item.mShadowedHolder != null && item.mShadowingHolder == null) {
                item.mShadowedHolder = null;
            }
            item.mShadowingHolder = null;
            if (!item.shouldBeKeptAsChild() && !RecyclerView.this.removeAnimatingView(item.itemView) && item.isTmpDetached()) {
                RecyclerView.this.removeDetachedView(item.itemView, false);
            }
        }
    }

    public static abstract class OnFlingListener {
        public abstract boolean onFling(int var1, int var2);
    }

    public static class State {
        static final int STEP_START = 1;
        static final int STEP_LAYOUT = 2;
        static final int STEP_ANIMATIONS = 4;
        int mTargetPosition = -1;
        private SparseArray<Object> mData;
        int mPreviousLayoutItemCount = 0;
        int mDeletedInvisibleItemCountSincePreviousLayout = 0;
        int mLayoutStep = 1;
        int mItemCount = 0;
        boolean mStructureChanged = false;
        boolean mInPreLayout = false;
        boolean mTrackOldChangeHolders = false;
        boolean mIsMeasuring = false;
        boolean mRunSimpleAnimations = false;
        boolean mRunPredictiveAnimations = false;
        int mFocusedItemPosition;
        long mFocusedItemId;
        int mFocusedSubChildId;
        int mRemainingScrollHorizontal;
        int mRemainingScrollVertical;

        void assertLayoutStep(int accepted) {
            if ((accepted & this.mLayoutStep) == 0) {
                throw new IllegalStateException("Layout state should be one of " + Integer.toBinaryString(accepted) + " but it is " + Integer.toBinaryString(this.mLayoutStep));
            }
        }

        void prepareForNestedPrefetch(Adapter adapter) {
            this.mLayoutStep = 1;
            this.mItemCount = adapter.getItemCount();
            this.mInPreLayout = false;
            this.mTrackOldChangeHolders = false;
            this.mIsMeasuring = false;
        }

        public boolean isMeasuring() {
            return this.mIsMeasuring;
        }

        public boolean isPreLayout() {
            return this.mInPreLayout;
        }

        public boolean willRunPredictiveAnimations() {
            return this.mRunPredictiveAnimations;
        }

        public boolean willRunSimpleAnimations() {
            return this.mRunSimpleAnimations;
        }

        public void remove(int resourceId) {
            if (this.mData == null) {
                return;
            }
            this.mData.remove(resourceId);
        }

        public <T> T get(int resourceId) {
            if (this.mData == null) {
                return null;
            }
            return (T)this.mData.get(resourceId);
        }

        public void put(int resourceId, Object data) {
            if (this.mData == null) {
                this.mData = new SparseArray();
            }
            this.mData.put(resourceId, data);
        }

        public int getTargetScrollPosition() {
            return this.mTargetPosition;
        }

        public boolean hasTargetScrollPosition() {
            return this.mTargetPosition != -1;
        }

        public boolean didStructureChange() {
            return this.mStructureChanged;
        }

        public int getItemCount() {
            return this.mInPreLayout ? this.mPreviousLayoutItemCount - this.mDeletedInvisibleItemCountSincePreviousLayout : this.mItemCount;
        }

        public int getRemainingScrollHorizontal() {
            return this.mRemainingScrollHorizontal;
        }

        public int getRemainingScrollVertical() {
            return this.mRemainingScrollVertical;
        }

        public String toString() {
            return "State{mTargetPosition=" + this.mTargetPosition + ", mData=" + this.mData + ", mItemCount=" + this.mItemCount + ", mIsMeasuring=" + this.mIsMeasuring + ", mPreviousLayoutItemCount=" + this.mPreviousLayoutItemCount + ", mDeletedInvisibleItemCountSincePreviousLayout=" + this.mDeletedInvisibleItemCountSincePreviousLayout + ", mStructureChanged=" + this.mStructureChanged + ", mInPreLayout=" + this.mInPreLayout + ", mRunSimpleAnimations=" + this.mRunSimpleAnimations + ", mRunPredictiveAnimations=" + this.mRunPredictiveAnimations + '}';
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static class SavedState
    extends AbsSavedState {
        Parcelable mLayoutState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcel in, ClassLoader loader) {
            super(in, loader);
            this.mLayoutState = in.readParcelable(loader != null ? loader : LayoutManager.class.getClassLoader());
        }

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.mLayoutState, 0);
        }

        void copyFrom(SavedState other) {
            this.mLayoutState = other.mLayoutState;
        }
    }

    static class AdapterDataObservable
    extends Observable<AdapterDataObserver> {
        AdapterDataObservable() {
        }

        public boolean hasObservers() {
            return !this.mObservers.isEmpty();
        }

        public void notifyChanged() {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onChanged();
            }
        }

        public void notifyStateRestorationPolicyChanged() {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onStateRestorationPolicyChanged();
            }
        }

        public void notifyItemRangeChanged(int positionStart, int itemCount) {
            this.notifyItemRangeChanged(positionStart, itemCount, null);
        }

        public void notifyItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeChanged(positionStart, itemCount, payload);
            }
        }

        public void notifyItemRangeInserted(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeInserted(positionStart, itemCount);
            }
        }

        public void notifyItemRangeRemoved(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeRemoved(positionStart, itemCount);
            }
        }

        public void notifyItemMoved(int fromPosition, int toPosition) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeMoved(fromPosition, toPosition, 1);
            }
        }
    }

    public static abstract class SmoothScroller {
        private int mTargetPosition = -1;
        private RecyclerView mRecyclerView;
        private LayoutManager mLayoutManager;
        private boolean mPendingInitialRun;
        private boolean mRunning;
        private View mTargetView;
        private final Action mRecyclingAction = new Action(0, 0);
        private boolean mStarted;

        void start(RecyclerView recyclerView, LayoutManager layoutManager) {
            recyclerView.mViewFlinger.stop();
            if (this.mStarted) {
                Log.w((String)RecyclerView.TAG, (String)("An instance of " + this.getClass().getSimpleName() + " was started more than once. Each instance of" + this.getClass().getSimpleName() + " is intended to only be used once. You should create a new instance for each use."));
            }
            this.mRecyclerView = recyclerView;
            this.mLayoutManager = layoutManager;
            if (this.mTargetPosition == -1) {
                throw new IllegalArgumentException("Invalid target position");
            }
            this.mRecyclerView.mState.mTargetPosition = this.mTargetPosition;
            this.mRunning = true;
            this.mPendingInitialRun = true;
            this.mTargetView = this.findViewByPosition(this.getTargetPosition());
            this.onStart();
            this.mRecyclerView.mViewFlinger.postOnAnimation();
            this.mStarted = true;
        }

        public void setTargetPosition(int targetPosition) {
            this.mTargetPosition = targetPosition;
        }

        @Nullable
        public PointF computeScrollVectorForPosition(int targetPosition) {
            LayoutManager layoutManager = this.getLayoutManager();
            if (layoutManager instanceof ScrollVectorProvider) {
                return ((ScrollVectorProvider)((Object)layoutManager)).computeScrollVectorForPosition(targetPosition);
            }
            Log.w((String)RecyclerView.TAG, (String)("You should override computeScrollVectorForPosition when the LayoutManager does not implement " + ScrollVectorProvider.class.getCanonicalName()));
            return null;
        }

        @Nullable
        public LayoutManager getLayoutManager() {
            return this.mLayoutManager;
        }

        protected final void stop() {
            if (!this.mRunning) {
                return;
            }
            this.mRunning = false;
            this.onStop();
            this.mRecyclerView.mState.mTargetPosition = -1;
            this.mTargetView = null;
            this.mTargetPosition = -1;
            this.mPendingInitialRun = false;
            this.mLayoutManager.onSmoothScrollerStopped(this);
            this.mLayoutManager = null;
            this.mRecyclerView = null;
        }

        public boolean isPendingInitialRun() {
            return this.mPendingInitialRun;
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        public int getTargetPosition() {
            return this.mTargetPosition;
        }

        void onAnimation(int dx, int dy) {
            PointF pointF;
            RecyclerView recyclerView = this.mRecyclerView;
            if (this.mTargetPosition == -1 || recyclerView == null) {
                this.stop();
            }
            if (this.mPendingInitialRun && this.mTargetView == null && this.mLayoutManager != null && (pointF = this.computeScrollVectorForPosition(this.mTargetPosition)) != null && (pointF.x != 0.0f || pointF.y != 0.0f)) {
                recyclerView.scrollStep((int)Math.signum(pointF.x), (int)Math.signum(pointF.y), null);
            }
            this.mPendingInitialRun = false;
            if (this.mTargetView != null) {
                if (this.getChildPosition(this.mTargetView) == this.mTargetPosition) {
                    this.onTargetFound(this.mTargetView, recyclerView.mState, this.mRecyclingAction);
                    this.mRecyclingAction.runIfNecessary(recyclerView);
                    this.stop();
                } else {
                    Log.e((String)RecyclerView.TAG, (String)"Passed over target position while smooth scrolling.");
                    this.mTargetView = null;
                }
            }
            if (this.mRunning) {
                this.onSeekTargetStep(dx, dy, recyclerView.mState, this.mRecyclingAction);
                boolean hadJumpTarget = this.mRecyclingAction.hasJumpTarget();
                this.mRecyclingAction.runIfNecessary(recyclerView);
                if (hadJumpTarget && this.mRunning) {
                    this.mPendingInitialRun = true;
                    recyclerView.mViewFlinger.postOnAnimation();
                }
            }
        }

        public int getChildPosition(View view) {
            return this.mRecyclerView.getChildLayoutPosition(view);
        }

        public int getChildCount() {
            return this.mRecyclerView.mLayout.getChildCount();
        }

        public View findViewByPosition(int position) {
            return this.mRecyclerView.mLayout.findViewByPosition(position);
        }

        @Deprecated
        public void instantScrollToPosition(int position) {
            this.mRecyclerView.scrollToPosition(position);
        }

        protected void onChildAttachedToWindow(View child) {
            if (this.getChildPosition(child) == this.getTargetPosition()) {
                this.mTargetView = child;
            }
        }

        protected void normalize(@NonNull PointF scrollVector) {
            float magnitude = (float)Math.sqrt(scrollVector.x * scrollVector.x + scrollVector.y * scrollVector.y);
            scrollVector.x /= magnitude;
            scrollVector.y /= magnitude;
        }

        protected abstract void onStart();

        protected abstract void onStop();

        protected abstract void onSeekTargetStep(@Px int var1, @Px int var2, @NonNull State var3, @NonNull Action var4);

        protected abstract void onTargetFound(@NonNull View var1, @NonNull State var2, @NonNull Action var3);

        public static interface ScrollVectorProvider {
            @Nullable
            public PointF computeScrollVectorForPosition(int var1);
        }

        public static class Action {
            public static final int UNDEFINED_DURATION = Integer.MIN_VALUE;
            private int mDx;
            private int mDy;
            private int mDuration;
            private int mJumpToPosition = -1;
            private Interpolator mInterpolator;
            private boolean mChanged = false;
            private int mConsecutiveUpdates = 0;

            public Action(@Px int dx, @Px int dy) {
                this(dx, dy, Integer.MIN_VALUE, null);
            }

            public Action(@Px int dx, @Px int dy, int duration) {
                this(dx, dy, duration, null);
            }

            public Action(@Px int dx, @Px int dy, int duration, @Nullable Interpolator interpolator) {
                this.mDx = dx;
                this.mDy = dy;
                this.mDuration = duration;
                this.mInterpolator = interpolator;
            }

            public void jumpTo(int targetPosition) {
                this.mJumpToPosition = targetPosition;
            }

            boolean hasJumpTarget() {
                return this.mJumpToPosition >= 0;
            }

            void runIfNecessary(RecyclerView recyclerView) {
                if (this.mJumpToPosition >= 0) {
                    int position = this.mJumpToPosition;
                    this.mJumpToPosition = -1;
                    recyclerView.jumpToPositionForSmoothScroller(position);
                    this.mChanged = false;
                    return;
                }
                if (this.mChanged) {
                    this.validate();
                    recyclerView.mViewFlinger.smoothScrollBy(this.mDx, this.mDy, this.mDuration, this.mInterpolator);
                    ++this.mConsecutiveUpdates;
                    if (this.mConsecutiveUpdates > 10) {
                        Log.e((String)RecyclerView.TAG, (String)"Smooth Scroll action is being updated too frequently. Make sure you are not changing it unless necessary");
                    }
                    this.mChanged = false;
                } else {
                    this.mConsecutiveUpdates = 0;
                }
            }

            private void validate() {
                if (this.mInterpolator != null && this.mDuration < 1) {
                    throw new IllegalStateException("If you provide an interpolator, you must set a positive duration");
                }
                if (this.mDuration < 1) {
                    throw new IllegalStateException("Scroll duration must be a positive number");
                }
            }

            @Px
            public int getDx() {
                return this.mDx;
            }

            public void setDx(@Px int dx) {
                this.mChanged = true;
                this.mDx = dx;
            }

            @Px
            public int getDy() {
                return this.mDy;
            }

            public void setDy(@Px int dy) {
                this.mChanged = true;
                this.mDy = dy;
            }

            public int getDuration() {
                return this.mDuration;
            }

            public void setDuration(int duration) {
                this.mChanged = true;
                this.mDuration = duration;
            }

            @Nullable
            public Interpolator getInterpolator() {
                return this.mInterpolator;
            }

            public void setInterpolator(@Nullable Interpolator interpolator) {
                this.mChanged = true;
                this.mInterpolator = interpolator;
            }

            public void update(@Px int dx, @Px int dy, int duration, @Nullable Interpolator interpolator) {
                this.mDx = dx;
                this.mDy = dy;
                this.mDuration = duration;
                this.mInterpolator = interpolator;
                this.mChanged = true;
            }
        }
    }

    public static abstract class AdapterDataObserver {
        public void onChanged() {
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
        }

        public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            this.onItemRangeChanged(positionStart, itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
        }

        public void onStateRestorationPolicyChanged() {
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        ViewHolder mViewHolder;
        final Rect mDecorInsets = new Rect();
        boolean mInsetsDirty = true;
        boolean mPendingInvalidate = false;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.LayoutParams)source);
        }

        public boolean viewNeedsUpdate() {
            return this.mViewHolder.needsUpdate();
        }

        public boolean isViewInvalid() {
            return this.mViewHolder.isInvalid();
        }

        public boolean isItemRemoved() {
            return this.mViewHolder.isRemoved();
        }

        public boolean isItemChanged() {
            return this.mViewHolder.isUpdated();
        }

        @Deprecated
        public int getViewPosition() {
            return this.mViewHolder.getPosition();
        }

        public int getViewLayoutPosition() {
            return this.mViewHolder.getLayoutPosition();
        }

        @Deprecated
        public int getViewAdapterPosition() {
            return this.mViewHolder.getBindingAdapterPosition();
        }

        public int getAbsoluteAdapterPosition() {
            return this.mViewHolder.getAbsoluteAdapterPosition();
        }

        public int getBindingAdapterPosition() {
            return this.mViewHolder.getBindingAdapterPosition();
        }
    }

    public static abstract class ViewHolder {
        @NonNull
        public final View itemView;
        WeakReference<RecyclerView> mNestedRecyclerView;
        int mPosition = -1;
        int mOldPosition = -1;
        long mItemId = -1L;
        int mItemViewType = -1;
        int mPreLayoutPosition = -1;
        ViewHolder mShadowedHolder = null;
        ViewHolder mShadowingHolder = null;
        static final int FLAG_BOUND = 1;
        static final int FLAG_UPDATE = 2;
        static final int FLAG_INVALID = 4;
        static final int FLAG_REMOVED = 8;
        static final int FLAG_NOT_RECYCLABLE = 16;
        static final int FLAG_RETURNED_FROM_SCRAP = 32;
        static final int FLAG_IGNORE = 128;
        static final int FLAG_TMP_DETACHED = 256;
        static final int FLAG_ADAPTER_POSITION_UNKNOWN = 512;
        static final int FLAG_ADAPTER_FULLUPDATE = 1024;
        static final int FLAG_MOVED = 2048;
        static final int FLAG_APPEARED_IN_PRE_LAYOUT = 4096;
        static final int PENDING_ACCESSIBILITY_STATE_NOT_SET = -1;
        static final int FLAG_BOUNCED_FROM_HIDDEN_LIST = 8192;
        int mFlags;
        private static final List<Object> FULLUPDATE_PAYLOADS = Collections.emptyList();
        List<Object> mPayloads = null;
        List<Object> mUnmodifiedPayloads = null;
        private int mIsRecyclableCount = 0;
        Recycler mScrapContainer = null;
        boolean mInChangeScrap = false;
        private int mWasImportantForAccessibilityBeforeHidden = 0;
        @VisibleForTesting
        int mPendingAccessibilityState = -1;
        RecyclerView mOwnerRecyclerView;
        Adapter<? extends ViewHolder> mBindingAdapter;

        public ViewHolder(@NonNull View itemView) {
            if (itemView == null) {
                throw new IllegalArgumentException("itemView may not be null");
            }
            this.itemView = itemView;
        }

        void flagRemovedAndOffsetPosition(int mNewPosition, int offset, boolean applyToPreLayout) {
            this.addFlags(8);
            this.offsetPosition(offset, applyToPreLayout);
            this.mPosition = mNewPosition;
        }

        void offsetPosition(int offset, boolean applyToPreLayout) {
            if (this.mOldPosition == -1) {
                this.mOldPosition = this.mPosition;
            }
            if (this.mPreLayoutPosition == -1) {
                this.mPreLayoutPosition = this.mPosition;
            }
            if (applyToPreLayout) {
                this.mPreLayoutPosition += offset;
            }
            this.mPosition += offset;
            if (this.itemView.getLayoutParams() != null) {
                ((LayoutParams)this.itemView.getLayoutParams()).mInsetsDirty = true;
            }
        }

        void clearOldPosition() {
            this.mOldPosition = -1;
            this.mPreLayoutPosition = -1;
        }

        void saveOldPosition() {
            if (this.mOldPosition == -1) {
                this.mOldPosition = this.mPosition;
            }
        }

        boolean shouldIgnore() {
            return (this.mFlags & 0x80) != 0;
        }

        @Deprecated
        public final int getPosition() {
            return this.mPreLayoutPosition == -1 ? this.mPosition : this.mPreLayoutPosition;
        }

        public final int getLayoutPosition() {
            return this.mPreLayoutPosition == -1 ? this.mPosition : this.mPreLayoutPosition;
        }

        @Deprecated
        public final int getAdapterPosition() {
            return this.getBindingAdapterPosition();
        }

        public final int getBindingAdapterPosition() {
            if (this.mBindingAdapter == null) {
                return -1;
            }
            if (this.mOwnerRecyclerView == null) {
                return -1;
            }
            Adapter rvAdapter = this.mOwnerRecyclerView.getAdapter();
            if (rvAdapter == null) {
                return -1;
            }
            int globalPosition = this.mOwnerRecyclerView.getAdapterPositionInRecyclerView(this);
            if (globalPosition == -1) {
                return -1;
            }
            return rvAdapter.findRelativeAdapterPositionIn(this.mBindingAdapter, this, globalPosition);
        }

        public final int getAbsoluteAdapterPosition() {
            if (this.mOwnerRecyclerView == null) {
                return -1;
            }
            return this.mOwnerRecyclerView.getAdapterPositionInRecyclerView(this);
        }

        @Nullable
        public final Adapter<? extends ViewHolder> getBindingAdapter() {
            return this.mBindingAdapter;
        }

        public final int getOldPosition() {
            return this.mOldPosition;
        }

        public final long getItemId() {
            return this.mItemId;
        }

        public final int getItemViewType() {
            return this.mItemViewType;
        }

        boolean isScrap() {
            return this.mScrapContainer != null;
        }

        void unScrap() {
            this.mScrapContainer.unscrapView(this);
        }

        boolean wasReturnedFromScrap() {
            return (this.mFlags & 0x20) != 0;
        }

        void clearReturnedFromScrapFlag() {
            this.mFlags &= 0xFFFFFFDF;
        }

        void clearTmpDetachFlag() {
            this.mFlags &= 0xFFFFFEFF;
        }

        void stopIgnoring() {
            this.mFlags &= 0xFFFFFF7F;
        }

        void setScrapContainer(Recycler recycler, boolean isChangeScrap) {
            this.mScrapContainer = recycler;
            this.mInChangeScrap = isChangeScrap;
        }

        boolean isInvalid() {
            return (this.mFlags & 4) != 0;
        }

        boolean needsUpdate() {
            return (this.mFlags & 2) != 0;
        }

        boolean isBound() {
            return (this.mFlags & 1) != 0;
        }

        boolean isRemoved() {
            return (this.mFlags & 8) != 0;
        }

        boolean hasAnyOfTheFlags(int flags) {
            return (this.mFlags & flags) != 0;
        }

        boolean isTmpDetached() {
            return (this.mFlags & 0x100) != 0;
        }

        boolean isAttachedToTransitionOverlay() {
            return this.itemView.getParent() != null && this.itemView.getParent() != this.mOwnerRecyclerView;
        }

        boolean isAdapterPositionUnknown() {
            return (this.mFlags & 0x200) != 0 || this.isInvalid();
        }

        void setFlags(int flags, int mask) {
            this.mFlags = this.mFlags & ~mask | flags & mask;
        }

        void addFlags(int flags) {
            this.mFlags |= flags;
        }

        void addChangePayload(Object payload) {
            if (payload == null) {
                this.addFlags(1024);
            } else if ((this.mFlags & 0x400) == 0) {
                this.createPayloadsIfNeeded();
                this.mPayloads.add(payload);
            }
        }

        private void createPayloadsIfNeeded() {
            if (this.mPayloads == null) {
                this.mPayloads = new ArrayList<Object>();
                this.mUnmodifiedPayloads = Collections.unmodifiableList(this.mPayloads);
            }
        }

        void clearPayload() {
            if (this.mPayloads != null) {
                this.mPayloads.clear();
            }
            this.mFlags &= 0xFFFFFBFF;
        }

        List<Object> getUnmodifiedPayloads() {
            if ((this.mFlags & 0x400) == 0) {
                if (this.mPayloads == null || this.mPayloads.size() == 0) {
                    return FULLUPDATE_PAYLOADS;
                }
                return this.mUnmodifiedPayloads;
            }
            return FULLUPDATE_PAYLOADS;
        }

        void resetInternal() {
            this.mFlags = 0;
            this.mPosition = -1;
            this.mOldPosition = -1;
            this.mItemId = -1L;
            this.mPreLayoutPosition = -1;
            this.mIsRecyclableCount = 0;
            this.mShadowedHolder = null;
            this.mShadowingHolder = null;
            this.clearPayload();
            this.mWasImportantForAccessibilityBeforeHidden = 0;
            this.mPendingAccessibilityState = -1;
            RecyclerView.clearNestedRecyclerViewIfNotNested(this);
        }

        void onEnteredHiddenState(RecyclerView parent) {
            this.mWasImportantForAccessibilityBeforeHidden = this.mPendingAccessibilityState != -1 ? this.mPendingAccessibilityState : ViewCompat.getImportantForAccessibility((View)this.itemView);
            parent.setChildImportantForAccessibilityInternal(this, 4);
        }

        void onLeftHiddenState(RecyclerView parent) {
            parent.setChildImportantForAccessibilityInternal(this, this.mWasImportantForAccessibilityBeforeHidden);
            this.mWasImportantForAccessibilityBeforeHidden = 0;
        }

        public String toString() {
            String className = this.getClass().isAnonymousClass() ? "ViewHolder" : this.getClass().getSimpleName();
            StringBuilder sb = new StringBuilder(className + "{" + Integer.toHexString(this.hashCode()) + " position=" + this.mPosition + " id=" + this.mItemId + ", oldPos=" + this.mOldPosition + ", pLpos:" + this.mPreLayoutPosition);
            if (this.isScrap()) {
                sb.append(" scrap ").append(this.mInChangeScrap ? "[changeScrap]" : "[attachedScrap]");
            }
            if (this.isInvalid()) {
                sb.append(" invalid");
            }
            if (!this.isBound()) {
                sb.append(" unbound");
            }
            if (this.needsUpdate()) {
                sb.append(" update");
            }
            if (this.isRemoved()) {
                sb.append(" removed");
            }
            if (this.shouldIgnore()) {
                sb.append(" ignored");
            }
            if (this.isTmpDetached()) {
                sb.append(" tmpDetached");
            }
            if (!this.isRecyclable()) {
                sb.append(" not recyclable(" + this.mIsRecyclableCount + ")");
            }
            if (this.isAdapterPositionUnknown()) {
                sb.append(" undefined adapter position");
            }
            if (this.itemView.getParent() == null) {
                sb.append(" no parent");
            }
            sb.append("}");
            return sb.toString();
        }

        public final void setIsRecyclable(boolean recyclable) {
            int n = this.mIsRecyclableCount = recyclable ? this.mIsRecyclableCount - 1 : this.mIsRecyclableCount + 1;
            if (this.mIsRecyclableCount < 0) {
                this.mIsRecyclableCount = 0;
                Log.e((String)"View", (String)("isRecyclable decremented below 0: unmatched pair of setIsRecyable() calls for " + this));
            } else if (!recyclable && this.mIsRecyclableCount == 1) {
                this.mFlags |= 0x10;
            } else if (recyclable && this.mIsRecyclableCount == 0) {
                this.mFlags &= 0xFFFFFFEF;
            }
        }

        public final boolean isRecyclable() {
            return (this.mFlags & 0x10) == 0 && !ViewCompat.hasTransientState((View)this.itemView);
        }

        boolean shouldBeKeptAsChild() {
            return (this.mFlags & 0x10) != 0;
        }

        boolean doesTransientStatePreventRecycling() {
            return (this.mFlags & 0x10) == 0 && ViewCompat.hasTransientState((View)this.itemView);
        }

        boolean isUpdated() {
            return (this.mFlags & 2) != 0;
        }
    }

    public static interface OnChildAttachStateChangeListener {
        public void onChildViewAttachedToWindow(@NonNull View var1);

        public void onChildViewDetachedFromWindow(@NonNull View var1);
    }

    public static interface RecyclerListener {
        public void onViewRecycled(@NonNull ViewHolder var1);
    }

    public static abstract class OnScrollListener {
        public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
        }

        public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
        }
    }

    public static class SimpleOnItemTouchListener
    implements OnItemTouchListener {
        @Override
        public boolean onInterceptTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
            return false;
        }

        @Override
        public void onTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
        }

        @Override
        public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        }
    }

    public static interface OnItemTouchListener {
        public boolean onInterceptTouchEvent(@NonNull RecyclerView var1, @NonNull MotionEvent var2);

        public void onTouchEvent(@NonNull RecyclerView var1, @NonNull MotionEvent var2);

        public void onRequestDisallowInterceptTouchEvent(boolean var1);
    }

    public static abstract class ItemDecoration {
        public void onDraw(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull State state) {
            this.onDraw(c, parent);
        }

        @Deprecated
        public void onDraw(@NonNull Canvas c, @NonNull RecyclerView parent) {
        }

        public void onDrawOver(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull State state) {
            this.onDrawOver(c, parent);
        }

        @Deprecated
        public void onDrawOver(@NonNull Canvas c, @NonNull RecyclerView parent) {
        }

        @Deprecated
        public void getItemOffsets(@NonNull Rect outRect, int itemPosition, @NonNull RecyclerView parent) {
            outRect.set(0, 0, 0, 0);
        }

        public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull State state) {
            this.getItemOffsets(outRect, ((LayoutParams)view.getLayoutParams()).getViewLayoutPosition(), parent);
        }
    }

    public static abstract class LayoutManager {
        ChildHelper mChildHelper;
        RecyclerView mRecyclerView;
        private final ViewBoundsCheck.Callback mHorizontalBoundCheckCallback = new ViewBoundsCheck.Callback(){

            @Override
            public View getChildAt(int index) {
                return this.getChildAt(index);
            }

            @Override
            public int getParentStart() {
                return this.getPaddingLeft();
            }

            @Override
            public int getParentEnd() {
                return this.getWidth() - this.getPaddingRight();
            }

            @Override
            public int getChildStart(View view) {
                LayoutParams params = (LayoutParams)view.getLayoutParams();
                return this.getDecoratedLeft(view) - params.leftMargin;
            }

            @Override
            public int getChildEnd(View view) {
                LayoutParams params = (LayoutParams)view.getLayoutParams();
                return this.getDecoratedRight(view) + params.rightMargin;
            }
        };
        private final ViewBoundsCheck.Callback mVerticalBoundCheckCallback = new ViewBoundsCheck.Callback(){

            @Override
            public View getChildAt(int index) {
                return this.getChildAt(index);
            }

            @Override
            public int getParentStart() {
                return this.getPaddingTop();
            }

            @Override
            public int getParentEnd() {
                return this.getHeight() - this.getPaddingBottom();
            }

            @Override
            public int getChildStart(View view) {
                LayoutParams params = (LayoutParams)view.getLayoutParams();
                return this.getDecoratedTop(view) - params.topMargin;
            }

            @Override
            public int getChildEnd(View view) {
                LayoutParams params = (LayoutParams)view.getLayoutParams();
                return this.getDecoratedBottom(view) + params.bottomMargin;
            }
        };
        ViewBoundsCheck mHorizontalBoundCheck = new ViewBoundsCheck(this.mHorizontalBoundCheckCallback);
        ViewBoundsCheck mVerticalBoundCheck = new ViewBoundsCheck(this.mVerticalBoundCheckCallback);
        @Nullable
        SmoothScroller mSmoothScroller;
        boolean mRequestedSimpleAnimations = false;
        boolean mIsAttachedToWindow = false;
        boolean mAutoMeasure = false;
        private boolean mMeasurementCacheEnabled = true;
        private boolean mItemPrefetchEnabled = true;
        int mPrefetchMaxCountObserved;
        boolean mPrefetchMaxObservedInInitialPrefetch;
        private int mWidthMode;
        private int mHeightMode;
        private int mWidth;
        private int mHeight;

        void setRecyclerView(RecyclerView recyclerView) {
            if (recyclerView == null) {
                this.mRecyclerView = null;
                this.mChildHelper = null;
                this.mWidth = 0;
                this.mHeight = 0;
            } else {
                this.mRecyclerView = recyclerView;
                this.mChildHelper = recyclerView.mChildHelper;
                this.mWidth = recyclerView.getWidth();
                this.mHeight = recyclerView.getHeight();
            }
            this.mWidthMode = 0x40000000;
            this.mHeightMode = 0x40000000;
        }

        void setMeasureSpecs(int wSpec, int hSpec) {
            this.mWidth = View.MeasureSpec.getSize((int)wSpec);
            this.mWidthMode = View.MeasureSpec.getMode((int)wSpec);
            if (this.mWidthMode == 0 && !ALLOW_SIZE_IN_UNSPECIFIED_SPEC) {
                this.mWidth = 0;
            }
            this.mHeight = View.MeasureSpec.getSize((int)hSpec);
            this.mHeightMode = View.MeasureSpec.getMode((int)hSpec);
            if (this.mHeightMode == 0 && !ALLOW_SIZE_IN_UNSPECIFIED_SPEC) {
                this.mHeight = 0;
            }
        }

        void setMeasuredDimensionFromChildren(int widthSpec, int heightSpec) {
            int count = this.getChildCount();
            if (count == 0) {
                this.mRecyclerView.defaultOnMeasure(widthSpec, heightSpec);
                return;
            }
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                Rect bounds = this.mRecyclerView.mTempRect;
                this.getDecoratedBoundsWithMargins(child, bounds);
                if (bounds.left < minX) {
                    minX = bounds.left;
                }
                if (bounds.right > maxX) {
                    maxX = bounds.right;
                }
                if (bounds.top < minY) {
                    minY = bounds.top;
                }
                if (bounds.bottom <= maxY) continue;
                maxY = bounds.bottom;
            }
            this.mRecyclerView.mTempRect.set(minX, minY, maxX, maxY);
            this.setMeasuredDimension(this.mRecyclerView.mTempRect, widthSpec, heightSpec);
        }

        public void setMeasuredDimension(Rect childrenBounds, int wSpec, int hSpec) {
            int usedWidth = childrenBounds.width() + this.getPaddingLeft() + this.getPaddingRight();
            int usedHeight = childrenBounds.height() + this.getPaddingTop() + this.getPaddingBottom();
            int width = LayoutManager.chooseSize(wSpec, usedWidth, this.getMinimumWidth());
            int height = LayoutManager.chooseSize(hSpec, usedHeight, this.getMinimumHeight());
            this.setMeasuredDimension(width, height);
        }

        public void requestLayout() {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.requestLayout();
            }
        }

        public void assertInLayoutOrScroll(String message) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.assertInLayoutOrScroll(message);
            }
        }

        public static int chooseSize(int spec, int desired, int min) {
            int mode = View.MeasureSpec.getMode((int)spec);
            int size = View.MeasureSpec.getSize((int)spec);
            switch (mode) {
                case 0x40000000: {
                    return size;
                }
                case -2147483648: {
                    return Math.min(size, Math.max(desired, min));
                }
            }
            return Math.max(desired, min);
        }

        @SuppressLint(value={"UnknownNullness"})
        public void assertNotInLayoutOrScroll(String message) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.assertNotInLayoutOrScroll(message);
            }
        }

        @Deprecated
        public void setAutoMeasureEnabled(boolean enabled) {
            this.mAutoMeasure = enabled;
        }

        public boolean isAutoMeasureEnabled() {
            return this.mAutoMeasure;
        }

        public boolean supportsPredictiveItemAnimations() {
            return false;
        }

        public final void setItemPrefetchEnabled(boolean enabled) {
            if (enabled != this.mItemPrefetchEnabled) {
                this.mItemPrefetchEnabled = enabled;
                this.mPrefetchMaxCountObserved = 0;
                if (this.mRecyclerView != null) {
                    this.mRecyclerView.mRecycler.updateViewCacheSize();
                }
            }
        }

        public final boolean isItemPrefetchEnabled() {
            return this.mItemPrefetchEnabled;
        }

        @SuppressLint(value={"UnknownNullness"})
        public void collectAdjacentPrefetchPositions(int dx, int dy, State state, LayoutPrefetchRegistry layoutPrefetchRegistry) {
        }

        @SuppressLint(value={"UnknownNullness"})
        public void collectInitialPrefetchPositions(int adapterItemCount, LayoutPrefetchRegistry layoutPrefetchRegistry) {
        }

        void dispatchAttachedToWindow(RecyclerView view) {
            this.mIsAttachedToWindow = true;
            this.onAttachedToWindow(view);
        }

        void dispatchDetachedFromWindow(RecyclerView view, Recycler recycler) {
            this.mIsAttachedToWindow = false;
            this.onDetachedFromWindow(view, recycler);
        }

        public boolean isAttachedToWindow() {
            return this.mIsAttachedToWindow;
        }

        public void postOnAnimation(Runnable action) {
            if (this.mRecyclerView != null) {
                ViewCompat.postOnAnimation((View)this.mRecyclerView, (Runnable)action);
            }
        }

        public boolean removeCallbacks(Runnable action) {
            if (this.mRecyclerView != null) {
                return this.mRecyclerView.removeCallbacks(action);
            }
            return false;
        }

        @CallSuper
        public void onAttachedToWindow(RecyclerView view) {
        }

        @Deprecated
        public void onDetachedFromWindow(RecyclerView view) {
        }

        @CallSuper
        @SuppressLint(value={"UnknownNullness"})
        public void onDetachedFromWindow(RecyclerView view, Recycler recycler) {
            this.onDetachedFromWindow(view);
        }

        public boolean getClipToPadding() {
            return this.mRecyclerView != null && this.mRecyclerView.mClipToPadding;
        }

        @SuppressLint(value={"UnknownNullness"})
        public void onLayoutChildren(Recycler recycler, State state) {
            Log.e((String)RecyclerView.TAG, (String)"You must override onLayoutChildren(Recycler recycler, State state) ");
        }

        @SuppressLint(value={"UnknownNullness"})
        public void onLayoutCompleted(State state) {
        }

        @SuppressLint(value={"UnknownNullness"})
        public abstract LayoutParams generateDefaultLayoutParams();

        public boolean checkLayoutParams(LayoutParams lp) {
            return lp != null;
        }

        @SuppressLint(value={"UnknownNullness"})
        public LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
            if (lp instanceof LayoutParams) {
                return new LayoutParams((LayoutParams)lp);
            }
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
            }
            return new LayoutParams(lp);
        }

        @SuppressLint(value={"UnknownNullness"})
        public LayoutParams generateLayoutParams(Context c, AttributeSet attrs) {
            return new LayoutParams(c, attrs);
        }

        @SuppressLint(value={"UnknownNullness"})
        public int scrollHorizontallyBy(int dx, Recycler recycler, State state) {
            return 0;
        }

        @SuppressLint(value={"UnknownNullness"})
        public int scrollVerticallyBy(int dy, Recycler recycler, State state) {
            return 0;
        }

        public boolean canScrollHorizontally() {
            return false;
        }

        public boolean canScrollVertically() {
            return false;
        }

        public void scrollToPosition(int position) {
        }

        @SuppressLint(value={"UnknownNullness"})
        public void smoothScrollToPosition(RecyclerView recyclerView, State state, int position) {
            Log.e((String)RecyclerView.TAG, (String)"You must override smoothScrollToPosition to support smooth scrolling");
        }

        @SuppressLint(value={"UnknownNullness"})
        public void startSmoothScroll(SmoothScroller smoothScroller) {
            if (this.mSmoothScroller != null && smoothScroller != this.mSmoothScroller && this.mSmoothScroller.isRunning()) {
                this.mSmoothScroller.stop();
            }
            this.mSmoothScroller = smoothScroller;
            this.mSmoothScroller.start(this.mRecyclerView, this);
        }

        public boolean isSmoothScrolling() {
            return this.mSmoothScroller != null && this.mSmoothScroller.isRunning();
        }

        public int getLayoutDirection() {
            return ViewCompat.getLayoutDirection((View)this.mRecyclerView);
        }

        @SuppressLint(value={"UnknownNullness"})
        public void endAnimation(View view) {
            if (this.mRecyclerView.mItemAnimator != null) {
                this.mRecyclerView.mItemAnimator.endAnimation(RecyclerView.getChildViewHolderInt(view));
            }
        }

        @SuppressLint(value={"UnknownNullness"})
        public void addDisappearingView(View child) {
            this.addDisappearingView(child, -1);
        }

        @SuppressLint(value={"UnknownNullness"})
        public void addDisappearingView(View child, int index) {
            this.addViewInt(child, index, true);
        }

        @SuppressLint(value={"UnknownNullness"})
        public void addView(View child) {
            this.addView(child, -1);
        }

        @SuppressLint(value={"UnknownNullness"})
        public void addView(View child, int index) {
            this.addViewInt(child, index, false);
        }

        private void addViewInt(View child, int index, boolean disappearing) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(child);
            if (disappearing || holder.isRemoved()) {
                this.mRecyclerView.mViewInfoStore.addToDisappearedInLayout(holder);
            } else {
                this.mRecyclerView.mViewInfoStore.removeFromDisappearedInLayout(holder);
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (holder.wasReturnedFromScrap() || holder.isScrap()) {
                if (holder.isScrap()) {
                    holder.unScrap();
                } else {
                    holder.clearReturnedFromScrapFlag();
                }
                this.mChildHelper.attachViewToParent(child, index, child.getLayoutParams(), false);
            } else if (child.getParent() == this.mRecyclerView) {
                int currentIndex = this.mChildHelper.indexOfChild(child);
                if (index == -1) {
                    index = this.mChildHelper.getChildCount();
                }
                if (currentIndex == -1) {
                    throw new IllegalStateException("Added View has RecyclerView as parent but view is not a real child. Unfiltered index:" + this.mRecyclerView.indexOfChild(child) + this.mRecyclerView.exceptionLabel());
                }
                if (currentIndex != index) {
                    this.mRecyclerView.mLayout.moveView(currentIndex, index);
                }
            } else {
                this.mChildHelper.addView(child, index, false);
                lp.mInsetsDirty = true;
                if (this.mSmoothScroller != null && this.mSmoothScroller.isRunning()) {
                    this.mSmoothScroller.onChildAttachedToWindow(child);
                }
            }
            if (lp.mPendingInvalidate) {
                holder.itemView.invalidate();
                lp.mPendingInvalidate = false;
            }
        }

        @SuppressLint(value={"UnknownNullness"})
        public void removeView(View child) {
            this.mChildHelper.removeView(child);
        }

        public void removeViewAt(int index) {
            View child = this.getChildAt(index);
            if (child != null) {
                this.mChildHelper.removeViewAt(index);
            }
        }

        public void removeAllViews() {
            int childCount = this.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                this.mChildHelper.removeViewAt(i);
            }
        }

        public int getBaseline() {
            return -1;
        }

        public int getPosition(@NonNull View view) {
            return ((LayoutParams)view.getLayoutParams()).getViewLayoutPosition();
        }

        public int getItemViewType(@NonNull View view) {
            return RecyclerView.getChildViewHolderInt(view).getItemViewType();
        }

        @Nullable
        public View findContainingItemView(@NonNull View view) {
            if (this.mRecyclerView == null) {
                return null;
            }
            View found = this.mRecyclerView.findContainingItemView(view);
            if (found == null) {
                return null;
            }
            if (this.mChildHelper.isHidden(found)) {
                return null;
            }
            return found;
        }

        @Nullable
        public View findViewByPosition(int position) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                ViewHolder vh = RecyclerView.getChildViewHolderInt(child);
                if (vh == null || vh.getLayoutPosition() != position || vh.shouldIgnore() || !this.mRecyclerView.mState.isPreLayout() && vh.isRemoved()) continue;
                return child;
            }
            return null;
        }

        public void detachView(@NonNull View child) {
            int ind = this.mChildHelper.indexOfChild(child);
            if (ind >= 0) {
                this.detachViewInternal(ind, child);
            }
        }

        public void detachViewAt(int index) {
            this.detachViewInternal(index, this.getChildAt(index));
        }

        private void detachViewInternal(int index, @NonNull View view) {
            this.mChildHelper.detachViewFromParent(index);
        }

        public void attachView(@NonNull View child, int index, LayoutParams lp) {
            ViewHolder vh = RecyclerView.getChildViewHolderInt(child);
            if (vh.isRemoved()) {
                this.mRecyclerView.mViewInfoStore.addToDisappearedInLayout(vh);
            } else {
                this.mRecyclerView.mViewInfoStore.removeFromDisappearedInLayout(vh);
            }
            this.mChildHelper.attachViewToParent(child, index, (ViewGroup.LayoutParams)lp, vh.isRemoved());
        }

        public void attachView(@NonNull View child, int index) {
            this.attachView(child, index, (LayoutParams)child.getLayoutParams());
        }

        public void attachView(@NonNull View child) {
            this.attachView(child, -1);
        }

        public void removeDetachedView(@NonNull View child) {
            this.mRecyclerView.removeDetachedView(child, false);
        }

        public void moveView(int fromIndex, int toIndex) {
            View view = this.getChildAt(fromIndex);
            if (view == null) {
                throw new IllegalArgumentException("Cannot move a child from non-existing index:" + fromIndex + this.mRecyclerView.toString());
            }
            this.detachViewAt(fromIndex);
            this.attachView(view, toIndex);
        }

        public void detachAndScrapView(@NonNull View child, @NonNull Recycler recycler) {
            int index = this.mChildHelper.indexOfChild(child);
            this.scrapOrRecycleView(recycler, index, child);
        }

        public void detachAndScrapViewAt(int index, @NonNull Recycler recycler) {
            View child = this.getChildAt(index);
            this.scrapOrRecycleView(recycler, index, child);
        }

        public void removeAndRecycleView(@NonNull View child, @NonNull Recycler recycler) {
            this.removeView(child);
            recycler.recycleView(child);
        }

        public void removeAndRecycleViewAt(int index, @NonNull Recycler recycler) {
            View view = this.getChildAt(index);
            this.removeViewAt(index);
            recycler.recycleView(view);
        }

        public int getChildCount() {
            return this.mChildHelper != null ? this.mChildHelper.getChildCount() : 0;
        }

        @Nullable
        public View getChildAt(int index) {
            return this.mChildHelper != null ? this.mChildHelper.getChildAt(index) : null;
        }

        public int getWidthMode() {
            return this.mWidthMode;
        }

        public int getHeightMode() {
            return this.mHeightMode;
        }

        @Px
        public int getWidth() {
            return this.mWidth;
        }

        @Px
        public int getHeight() {
            return this.mHeight;
        }

        @Px
        public int getPaddingLeft() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingLeft() : 0;
        }

        @Px
        public int getPaddingTop() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingTop() : 0;
        }

        @Px
        public int getPaddingRight() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingRight() : 0;
        }

        @Px
        public int getPaddingBottom() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingBottom() : 0;
        }

        @Px
        public int getPaddingStart() {
            return this.mRecyclerView != null ? ViewCompat.getPaddingStart((View)this.mRecyclerView) : 0;
        }

        @Px
        public int getPaddingEnd() {
            return this.mRecyclerView != null ? ViewCompat.getPaddingEnd((View)this.mRecyclerView) : 0;
        }

        public boolean isFocused() {
            return this.mRecyclerView != null && this.mRecyclerView.isFocused();
        }

        public boolean hasFocus() {
            return this.mRecyclerView != null && this.mRecyclerView.hasFocus();
        }

        @Nullable
        public View getFocusedChild() {
            if (this.mRecyclerView == null) {
                return null;
            }
            View focused = this.mRecyclerView.getFocusedChild();
            if (focused == null || this.mChildHelper.isHidden(focused)) {
                return null;
            }
            return focused;
        }

        public int getItemCount() {
            Adapter a = this.mRecyclerView != null ? this.mRecyclerView.getAdapter() : null;
            return a != null ? a.getItemCount() : 0;
        }

        public void offsetChildrenHorizontal(@Px int dx) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.offsetChildrenHorizontal(dx);
            }
        }

        public void offsetChildrenVertical(@Px int dy) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.offsetChildrenVertical(dy);
            }
        }

        public void ignoreView(@NonNull View view) {
            if (view.getParent() != this.mRecyclerView || this.mRecyclerView.indexOfChild(view) == -1) {
                throw new IllegalArgumentException("View should be fully attached to be ignored" + this.mRecyclerView.exceptionLabel());
            }
            ViewHolder vh = RecyclerView.getChildViewHolderInt(view);
            vh.addFlags(128);
            this.mRecyclerView.mViewInfoStore.removeViewHolder(vh);
        }

        public void stopIgnoringView(@NonNull View view) {
            ViewHolder vh = RecyclerView.getChildViewHolderInt(view);
            vh.stopIgnoring();
            vh.resetInternal();
            vh.addFlags(4);
        }

        public void detachAndScrapAttachedViews(@NonNull Recycler recycler) {
            int childCount = this.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View v = this.getChildAt(i);
                this.scrapOrRecycleView(recycler, i, v);
            }
        }

        private void scrapOrRecycleView(Recycler recycler, int index, View view) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            if (viewHolder.shouldIgnore()) {
                return;
            }
            if (viewHolder.isInvalid() && !viewHolder.isRemoved() && !this.mRecyclerView.mAdapter.hasStableIds()) {
                this.removeViewAt(index);
                recycler.recycleViewHolderInternal(viewHolder);
            } else {
                this.detachViewAt(index);
                recycler.scrapView(view);
                this.mRecyclerView.mViewInfoStore.onViewDetached(viewHolder);
            }
        }

        void removeAndRecycleScrapInt(Recycler recycler) {
            int scrapCount = recycler.getScrapCount();
            for (int i = scrapCount - 1; i >= 0; --i) {
                View scrap = recycler.getScrapViewAt(i);
                ViewHolder vh = RecyclerView.getChildViewHolderInt(scrap);
                if (vh.shouldIgnore()) continue;
                vh.setIsRecyclable(false);
                if (vh.isTmpDetached()) {
                    this.mRecyclerView.removeDetachedView(scrap, false);
                }
                if (this.mRecyclerView.mItemAnimator != null) {
                    this.mRecyclerView.mItemAnimator.endAnimation(vh);
                }
                vh.setIsRecyclable(true);
                recycler.quickRecycleScrapView(scrap);
            }
            recycler.clearScrap();
            if (scrapCount > 0) {
                this.mRecyclerView.invalidate();
            }
        }

        public void measureChild(@NonNull View child, int widthUsed, int heightUsed) {
            int heightSpec;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Rect insets = this.mRecyclerView.getItemDecorInsetsForChild(child);
            int widthSpec = LayoutManager.getChildMeasureSpec(this.getWidth(), this.getWidthMode(), this.getPaddingLeft() + this.getPaddingRight() + (widthUsed += insets.left + insets.right), lp.width, this.canScrollHorizontally());
            if (this.shouldMeasureChild(child, widthSpec, heightSpec = LayoutManager.getChildMeasureSpec(this.getHeight(), this.getHeightMode(), this.getPaddingTop() + this.getPaddingBottom() + (heightUsed += insets.top + insets.bottom), lp.height, this.canScrollVertically()), lp)) {
                child.measure(widthSpec, heightSpec);
            }
        }

        boolean shouldReMeasureChild(View child, int widthSpec, int heightSpec, LayoutParams lp) {
            return !this.mMeasurementCacheEnabled || !LayoutManager.isMeasurementUpToDate(child.getMeasuredWidth(), widthSpec, lp.width) || !LayoutManager.isMeasurementUpToDate(child.getMeasuredHeight(), heightSpec, lp.height);
        }

        boolean shouldMeasureChild(View child, int widthSpec, int heightSpec, LayoutParams lp) {
            return child.isLayoutRequested() || !this.mMeasurementCacheEnabled || !LayoutManager.isMeasurementUpToDate(child.getWidth(), widthSpec, lp.width) || !LayoutManager.isMeasurementUpToDate(child.getHeight(), heightSpec, lp.height);
        }

        public boolean isMeasurementCacheEnabled() {
            return this.mMeasurementCacheEnabled;
        }

        public void setMeasurementCacheEnabled(boolean measurementCacheEnabled) {
            this.mMeasurementCacheEnabled = measurementCacheEnabled;
        }

        private static boolean isMeasurementUpToDate(int childSize, int spec, int dimension) {
            int specMode = View.MeasureSpec.getMode((int)spec);
            int specSize = View.MeasureSpec.getSize((int)spec);
            if (dimension > 0 && childSize != dimension) {
                return false;
            }
            switch (specMode) {
                case 0: {
                    return true;
                }
                case -2147483648: {
                    return specSize >= childSize;
                }
                case 0x40000000: {
                    return specSize == childSize;
                }
            }
            return false;
        }

        public void measureChildWithMargins(@NonNull View child, int widthUsed, int heightUsed) {
            int heightSpec;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Rect insets = this.mRecyclerView.getItemDecorInsetsForChild(child);
            int widthSpec = LayoutManager.getChildMeasureSpec(this.getWidth(), this.getWidthMode(), this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin + (widthUsed += insets.left + insets.right), lp.width, this.canScrollHorizontally());
            if (this.shouldMeasureChild(child, widthSpec, heightSpec = LayoutManager.getChildMeasureSpec(this.getHeight(), this.getHeightMode(), this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin + (heightUsed += insets.top + insets.bottom), lp.height, this.canScrollVertically()), lp)) {
                child.measure(widthSpec, heightSpec);
            }
        }

        @Deprecated
        public static int getChildMeasureSpec(int parentSize, int padding, int childDimension, boolean canScroll) {
            int size = Math.max(0, parentSize - padding);
            int resultSize = 0;
            int resultMode = 0;
            if (canScroll) {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                } else {
                    resultSize = 0;
                    resultMode = 0;
                }
            } else if (childDimension >= 0) {
                resultSize = childDimension;
                resultMode = 0x40000000;
            } else if (childDimension == -1) {
                resultSize = size;
                resultMode = 0x40000000;
            } else if (childDimension == -2) {
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
            }
            return View.MeasureSpec.makeMeasureSpec((int)resultSize, (int)resultMode);
        }

        public static int getChildMeasureSpec(int parentSize, int parentMode, int padding, int childDimension, boolean canScroll) {
            int size = Math.max(0, parentSize - padding);
            int resultSize = 0;
            int resultMode = 0;
            if (canScroll) {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                } else if (childDimension == -1) {
                    switch (parentMode) {
                        case -2147483648: 
                        case 0x40000000: {
                            resultSize = size;
                            resultMode = parentMode;
                            break;
                        }
                        case 0: {
                            resultSize = 0;
                            resultMode = 0;
                        }
                    }
                } else if (childDimension == -2) {
                    resultSize = 0;
                    resultMode = 0;
                }
            } else if (childDimension >= 0) {
                resultSize = childDimension;
                resultMode = 0x40000000;
            } else if (childDimension == -1) {
                resultSize = size;
                resultMode = parentMode;
            } else if (childDimension == -2) {
                resultSize = size;
                resultMode = parentMode == Integer.MIN_VALUE || parentMode == 0x40000000 ? Integer.MIN_VALUE : 0;
            }
            return View.MeasureSpec.makeMeasureSpec((int)resultSize, (int)resultMode);
        }

        public int getDecoratedMeasuredWidth(@NonNull View child) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            return child.getMeasuredWidth() + insets.left + insets.right;
        }

        public int getDecoratedMeasuredHeight(@NonNull View child) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            return child.getMeasuredHeight() + insets.top + insets.bottom;
        }

        public void layoutDecorated(@NonNull View child, int left, int top, int right, int bottom) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            child.layout(left + insets.left, top + insets.top, right - insets.right, bottom - insets.bottom);
        }

        public void layoutDecoratedWithMargins(@NonNull View child, int left, int top, int right, int bottom) {
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Rect insets = lp.mDecorInsets;
            child.layout(left + insets.left + lp.leftMargin, top + insets.top + lp.topMargin, right - insets.right - lp.rightMargin, bottom - insets.bottom - lp.bottomMargin);
        }

        public void getTransformedBoundingBox(@NonNull View child, boolean includeDecorInsets, @NonNull Rect out) {
            Matrix childMatrix;
            if (includeDecorInsets) {
                Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
                out.set(-insets.left, -insets.top, child.getWidth() + insets.right, child.getHeight() + insets.bottom);
            } else {
                out.set(0, 0, child.getWidth(), child.getHeight());
            }
            if (this.mRecyclerView != null && (childMatrix = child.getMatrix()) != null && !childMatrix.isIdentity()) {
                RectF tempRectF = this.mRecyclerView.mTempRectF;
                tempRectF.set(out);
                childMatrix.mapRect(tempRectF);
                out.set((int)Math.floor(tempRectF.left), (int)Math.floor(tempRectF.top), (int)Math.ceil(tempRectF.right), (int)Math.ceil(tempRectF.bottom));
            }
            out.offset(child.getLeft(), child.getTop());
        }

        public void getDecoratedBoundsWithMargins(@NonNull View view, @NonNull Rect outBounds) {
            RecyclerView.getDecoratedBoundsWithMarginsInt(view, outBounds);
        }

        public int getDecoratedLeft(@NonNull View child) {
            return child.getLeft() - this.getLeftDecorationWidth(child);
        }

        public int getDecoratedTop(@NonNull View child) {
            return child.getTop() - this.getTopDecorationHeight(child);
        }

        public int getDecoratedRight(@NonNull View child) {
            return child.getRight() + this.getRightDecorationWidth(child);
        }

        public int getDecoratedBottom(@NonNull View child) {
            return child.getBottom() + this.getBottomDecorationHeight(child);
        }

        public void calculateItemDecorationsForChild(@NonNull View child, @NonNull Rect outRect) {
            if (this.mRecyclerView == null) {
                outRect.set(0, 0, 0, 0);
                return;
            }
            Rect insets = this.mRecyclerView.getItemDecorInsetsForChild(child);
            outRect.set(insets);
        }

        public int getTopDecorationHeight(@NonNull View child) {
            return ((LayoutParams)child.getLayoutParams()).mDecorInsets.top;
        }

        public int getBottomDecorationHeight(@NonNull View child) {
            return ((LayoutParams)child.getLayoutParams()).mDecorInsets.bottom;
        }

        public int getLeftDecorationWidth(@NonNull View child) {
            return ((LayoutParams)child.getLayoutParams()).mDecorInsets.left;
        }

        public int getRightDecorationWidth(@NonNull View child) {
            return ((LayoutParams)child.getLayoutParams()).mDecorInsets.right;
        }

        @Nullable
        public View onFocusSearchFailed(@NonNull View focused, int direction, @NonNull Recycler recycler, @NonNull State state) {
            return null;
        }

        @Nullable
        public View onInterceptFocusSearch(@NonNull View focused, int direction) {
            return null;
        }

        private int[] getChildRectangleOnScreenScrollAmount(View child, Rect rect) {
            int[] out = new int[2];
            int parentLeft = this.getPaddingLeft();
            int parentTop = this.getPaddingTop();
            int parentRight = this.getWidth() - this.getPaddingRight();
            int parentBottom = this.getHeight() - this.getPaddingBottom();
            int childLeft = child.getLeft() + rect.left - child.getScrollX();
            int childTop = child.getTop() + rect.top - child.getScrollY();
            int childRight = childLeft + rect.width();
            int childBottom = childTop + rect.height();
            int offScreenLeft = Math.min(0, childLeft - parentLeft);
            int offScreenTop = Math.min(0, childTop - parentTop);
            int offScreenRight = Math.max(0, childRight - parentRight);
            int offScreenBottom = Math.max(0, childBottom - parentBottom);
            int dx = this.getLayoutDirection() == 1 ? (offScreenRight != 0 ? offScreenRight : Math.max(offScreenLeft, childRight - parentRight)) : (offScreenLeft != 0 ? offScreenLeft : Math.min(childLeft - parentLeft, offScreenRight));
            int dy = offScreenTop != 0 ? offScreenTop : Math.min(childTop - parentTop, offScreenBottom);
            out[0] = dx;
            out[1] = dy;
            return out;
        }

        public boolean requestChildRectangleOnScreen(@NonNull RecyclerView parent, @NonNull View child, @NonNull Rect rect, boolean immediate) {
            return this.requestChildRectangleOnScreen(parent, child, rect, immediate, false);
        }

        public boolean requestChildRectangleOnScreen(@NonNull RecyclerView parent, @NonNull View child, @NonNull Rect rect, boolean immediate, boolean focusedChildVisible) {
            int[] scrollAmount = this.getChildRectangleOnScreenScrollAmount(child, rect);
            int dx = scrollAmount[0];
            int dy = scrollAmount[1];
            if (!(focusedChildVisible && !this.isFocusedChildVisibleAfterScrolling(parent, dx, dy) || dx == 0 && dy == 0)) {
                if (immediate) {
                    parent.scrollBy(dx, dy);
                } else {
                    parent.smoothScrollBy(dx, dy);
                }
                return true;
            }
            return false;
        }

        public boolean isViewPartiallyVisible(@NonNull View child, boolean completelyVisible, boolean acceptEndPointInclusion) {
            boolean isViewFullyVisible;
            int boundsFlag = 24579;
            boolean bl = isViewFullyVisible = this.mHorizontalBoundCheck.isViewWithinBoundFlags(child, boundsFlag) && this.mVerticalBoundCheck.isViewWithinBoundFlags(child, boundsFlag);
            if (completelyVisible) {
                return isViewFullyVisible;
            }
            return !isViewFullyVisible;
        }

        private boolean isFocusedChildVisibleAfterScrolling(RecyclerView parent, int dx, int dy) {
            View focusedChild = parent.getFocusedChild();
            if (focusedChild == null) {
                return false;
            }
            int parentLeft = this.getPaddingLeft();
            int parentTop = this.getPaddingTop();
            int parentRight = this.getWidth() - this.getPaddingRight();
            int parentBottom = this.getHeight() - this.getPaddingBottom();
            Rect bounds = this.mRecyclerView.mTempRect;
            this.getDecoratedBoundsWithMargins(focusedChild, bounds);
            return bounds.left - dx < parentRight && bounds.right - dx > parentLeft && bounds.top - dy < parentBottom && bounds.bottom - dy > parentTop;
        }

        @Deprecated
        public boolean onRequestChildFocus(@NonNull RecyclerView parent, @NonNull View child, @Nullable View focused) {
            return this.isSmoothScrolling() || parent.isComputingLayout();
        }

        public boolean onRequestChildFocus(@NonNull RecyclerView parent, @NonNull State state, @NonNull View child, @Nullable View focused) {
            return this.onRequestChildFocus(parent, child, focused);
        }

        public void onAdapterChanged(@Nullable Adapter oldAdapter, @Nullable Adapter newAdapter) {
        }

        public boolean onAddFocusables(@NonNull RecyclerView recyclerView, @NonNull ArrayList<View> views, int direction, int focusableMode) {
            return false;
        }

        public void onItemsChanged(@NonNull RecyclerView recyclerView) {
        }

        public void onItemsAdded(@NonNull RecyclerView recyclerView, int positionStart, int itemCount) {
        }

        public void onItemsRemoved(@NonNull RecyclerView recyclerView, int positionStart, int itemCount) {
        }

        public void onItemsUpdated(@NonNull RecyclerView recyclerView, int positionStart, int itemCount) {
        }

        public void onItemsUpdated(@NonNull RecyclerView recyclerView, int positionStart, int itemCount, @Nullable Object payload) {
            this.onItemsUpdated(recyclerView, positionStart, itemCount);
        }

        public void onItemsMoved(@NonNull RecyclerView recyclerView, int from, int to, int itemCount) {
        }

        public int computeHorizontalScrollExtent(@NonNull State state) {
            return 0;
        }

        public int computeHorizontalScrollOffset(@NonNull State state) {
            return 0;
        }

        public int computeHorizontalScrollRange(@NonNull State state) {
            return 0;
        }

        public int computeVerticalScrollExtent(@NonNull State state) {
            return 0;
        }

        public int computeVerticalScrollOffset(@NonNull State state) {
            return 0;
        }

        public int computeVerticalScrollRange(@NonNull State state) {
            return 0;
        }

        public void onMeasure(@NonNull Recycler recycler, @NonNull State state, int widthSpec, int heightSpec) {
            this.mRecyclerView.defaultOnMeasure(widthSpec, heightSpec);
        }

        public void setMeasuredDimension(int widthSize, int heightSize) {
            this.mRecyclerView.setMeasuredDimension(widthSize, heightSize);
        }

        @Px
        public int getMinimumWidth() {
            return ViewCompat.getMinimumWidth((View)this.mRecyclerView);
        }

        @Px
        public int getMinimumHeight() {
            return ViewCompat.getMinimumHeight((View)this.mRecyclerView);
        }

        @Nullable
        public Parcelable onSaveInstanceState() {
            return null;
        }

        @SuppressLint(value={"UnknownNullness"})
        public void onRestoreInstanceState(Parcelable state) {
        }

        void stopSmoothScroller() {
            if (this.mSmoothScroller != null) {
                this.mSmoothScroller.stop();
            }
        }

        void onSmoothScrollerStopped(SmoothScroller smoothScroller) {
            if (this.mSmoothScroller == smoothScroller) {
                this.mSmoothScroller = null;
            }
        }

        public void onScrollStateChanged(int state) {
        }

        public void removeAndRecycleAllViews(@NonNull Recycler recycler) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                View view = this.getChildAt(i);
                if (RecyclerView.getChildViewHolderInt(view).shouldIgnore()) continue;
                this.removeAndRecycleViewAt(i, recycler);
            }
        }

        void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfoCompat info) {
            this.onInitializeAccessibilityNodeInfo(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, info);
        }

        public void onInitializeAccessibilityNodeInfo(@NonNull Recycler recycler, @NonNull State state, @NonNull AccessibilityNodeInfoCompat info) {
            if (this.mRecyclerView.canScrollVertically(-1) || this.mRecyclerView.canScrollHorizontally(-1)) {
                info.addAction(8192);
                info.setScrollable(true);
            }
            if (this.mRecyclerView.canScrollVertically(1) || this.mRecyclerView.canScrollHorizontally(1)) {
                info.addAction(4096);
                info.setScrollable(true);
            }
            AccessibilityNodeInfoCompat.CollectionInfoCompat collectionInfo = AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)this.getRowCountForAccessibility(recycler, state), (int)this.getColumnCountForAccessibility(recycler, state), (boolean)this.isLayoutHierarchical(recycler, state), (int)this.getSelectionModeForAccessibility(recycler, state));
            info.setCollectionInfo((Object)collectionInfo);
        }

        public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
            this.onInitializeAccessibilityEvent(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, event);
        }

        public void onInitializeAccessibilityEvent(@NonNull Recycler recycler, @NonNull State state, @NonNull AccessibilityEvent event) {
            if (this.mRecyclerView == null || event == null) {
                return;
            }
            event.setScrollable(this.mRecyclerView.canScrollVertically(1) || this.mRecyclerView.canScrollVertically(-1) || this.mRecyclerView.canScrollHorizontally(-1) || this.mRecyclerView.canScrollHorizontally(1));
            if (this.mRecyclerView.mAdapter != null) {
                event.setItemCount(this.mRecyclerView.mAdapter.getItemCount());
            }
        }

        void onInitializeAccessibilityNodeInfoForItem(View host, AccessibilityNodeInfoCompat info) {
            ViewHolder vh = RecyclerView.getChildViewHolderInt(host);
            if (vh != null && !vh.isRemoved() && !this.mChildHelper.isHidden(vh.itemView)) {
                this.onInitializeAccessibilityNodeInfoForItem(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, host, info);
            }
        }

        public void onInitializeAccessibilityNodeInfoForItem(@NonNull Recycler recycler, @NonNull State state, @NonNull View host, @NonNull AccessibilityNodeInfoCompat info) {
        }

        public void requestSimpleAnimationsInNextLayout() {
            this.mRequestedSimpleAnimations = true;
        }

        public int getSelectionModeForAccessibility(@NonNull Recycler recycler, @NonNull State state) {
            return 0;
        }

        public int getRowCountForAccessibility(@NonNull Recycler recycler, @NonNull State state) {
            return -1;
        }

        public int getColumnCountForAccessibility(@NonNull Recycler recycler, @NonNull State state) {
            return -1;
        }

        public boolean isLayoutHierarchical(@NonNull Recycler recycler, @NonNull State state) {
            return false;
        }

        boolean performAccessibilityAction(int action, @Nullable Bundle args) {
            return this.performAccessibilityAction(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, action, args);
        }

        public boolean performAccessibilityAction(@NonNull Recycler recycler, @NonNull State state, int action, @Nullable Bundle args) {
            if (this.mRecyclerView == null) {
                return false;
            }
            int vScroll = 0;
            int hScroll = 0;
            int height = this.getHeight();
            int width = this.getWidth();
            Rect rect = new Rect();
            if (this.mRecyclerView.getMatrix().isIdentity() && this.mRecyclerView.getGlobalVisibleRect(rect)) {
                height = rect.height();
                width = rect.width();
            }
            switch (action) {
                case 8192: {
                    if (this.mRecyclerView.canScrollVertically(-1)) {
                        vScroll = -(height - this.getPaddingTop() - this.getPaddingBottom());
                    }
                    if (!this.mRecyclerView.canScrollHorizontally(-1)) break;
                    hScroll = -(width - this.getPaddingLeft() - this.getPaddingRight());
                    break;
                }
                case 4096: {
                    if (this.mRecyclerView.canScrollVertically(1)) {
                        vScroll = height - this.getPaddingTop() - this.getPaddingBottom();
                    }
                    if (!this.mRecyclerView.canScrollHorizontally(1)) break;
                    hScroll = width - this.getPaddingLeft() - this.getPaddingRight();
                }
            }
            if (vScroll == 0 && hScroll == 0) {
                return false;
            }
            this.mRecyclerView.smoothScrollBy(hScroll, vScroll, null, Integer.MIN_VALUE, true);
            return true;
        }

        boolean performAccessibilityActionForItem(@NonNull View view, int action, @Nullable Bundle args) {
            return this.performAccessibilityActionForItem(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, view, action, args);
        }

        public boolean performAccessibilityActionForItem(@NonNull Recycler recycler, @NonNull State state, @NonNull View view, int action, @Nullable Bundle args) {
            return false;
        }

        public static Properties getProperties(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            Properties properties = new Properties();
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RecyclerView, defStyleAttr, defStyleRes);
            properties.orientation = a.getInt(R.styleable.RecyclerView_android_orientation, 1);
            properties.spanCount = a.getInt(R.styleable.RecyclerView_spanCount, 1);
            properties.reverseLayout = a.getBoolean(R.styleable.RecyclerView_reverseLayout, false);
            properties.stackFromEnd = a.getBoolean(R.styleable.RecyclerView_stackFromEnd, false);
            a.recycle();
            return properties;
        }

        void setExactMeasureSpecsFrom(RecyclerView recyclerView) {
            this.setMeasureSpecs(View.MeasureSpec.makeMeasureSpec((int)recyclerView.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)recyclerView.getHeight(), (int)0x40000000));
        }

        boolean shouldMeasureTwice() {
            return false;
        }

        boolean hasFlexibleChildInBothOrientations() {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                if (lp.width >= 0 || lp.height >= 0) continue;
                return true;
            }
            return false;
        }

        public static class Properties {
            public int orientation;
            public int spanCount;
            public boolean reverseLayout;
            public boolean stackFromEnd;
        }

        public static interface LayoutPrefetchRegistry {
            public void addPosition(int var1, int var2);
        }
    }

    public static abstract class Adapter<VH extends ViewHolder> {
        private final AdapterDataObservable mObservable = new AdapterDataObservable();
        private boolean mHasStableIds = false;
        private StateRestorationPolicy mStateRestorationPolicy = StateRestorationPolicy.ALLOW;

        @NonNull
        public abstract VH onCreateViewHolder(@NonNull ViewGroup var1, int var2);

        public abstract void onBindViewHolder(@NonNull VH var1, int var2);

        public void onBindViewHolder(@NonNull VH holder, int position, @NonNull List<Object> payloads) {
            this.onBindViewHolder(holder, position);
        }

        public int findRelativeAdapterPositionIn(@NonNull Adapter<? extends ViewHolder> adapter, @NonNull ViewHolder viewHolder, int localPosition) {
            if (adapter == this) {
                return localPosition;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public final VH createViewHolder(@NonNull ViewGroup parent, int viewType) {
            try {
                TraceCompat.beginSection((String)RecyclerView.TRACE_CREATE_VIEW_TAG);
                VH holder = this.onCreateViewHolder(parent, viewType);
                if (((ViewHolder)holder).itemView.getParent() != null) {
                    throw new IllegalStateException("ViewHolder views must not be attached when created. Ensure that you are not passing 'true' to the attachToRoot parameter of LayoutInflater.inflate(..., boolean attachToRoot)");
                }
                ((ViewHolder)holder).mItemViewType = viewType;
                VH VH = holder;
                return VH;
            }
            finally {
                TraceCompat.endSection();
            }
        }

        public final void bindViewHolder(@NonNull VH holder, int position) {
            boolean rootBind;
            boolean bl = rootBind = ((ViewHolder)holder).mBindingAdapter == null;
            if (rootBind) {
                ((ViewHolder)holder).mPosition = position;
                if (this.hasStableIds()) {
                    ((ViewHolder)holder).mItemId = this.getItemId(position);
                }
                ((ViewHolder)holder).setFlags(1, 519);
                TraceCompat.beginSection((String)RecyclerView.TRACE_BIND_VIEW_TAG);
            }
            ((ViewHolder)holder).mBindingAdapter = this;
            this.onBindViewHolder(holder, position, ((ViewHolder)holder).getUnmodifiedPayloads());
            if (rootBind) {
                ((ViewHolder)holder).clearPayload();
                ViewGroup.LayoutParams layoutParams = ((ViewHolder)holder).itemView.getLayoutParams();
                if (layoutParams instanceof LayoutParams) {
                    ((LayoutParams)layoutParams).mInsetsDirty = true;
                }
                TraceCompat.endSection();
            }
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public void setHasStableIds(boolean hasStableIds) {
            if (this.hasObservers()) {
                throw new IllegalStateException("Cannot change whether this adapter has stable IDs while the adapter has registered observers.");
            }
            this.mHasStableIds = hasStableIds;
        }

        public long getItemId(int position) {
            return -1L;
        }

        public abstract int getItemCount();

        public final boolean hasStableIds() {
            return this.mHasStableIds;
        }

        public void onViewRecycled(@NonNull VH holder) {
        }

        public boolean onFailedToRecycleView(@NonNull VH holder) {
            return false;
        }

        public void onViewAttachedToWindow(@NonNull VH holder) {
        }

        public void onViewDetachedFromWindow(@NonNull VH holder) {
        }

        public final boolean hasObservers() {
            return this.mObservable.hasObservers();
        }

        public void registerAdapterDataObserver(@NonNull AdapterDataObserver observer) {
            this.mObservable.registerObserver(observer);
        }

        public void unregisterAdapterDataObserver(@NonNull AdapterDataObserver observer) {
            this.mObservable.unregisterObserver(observer);
        }

        public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        }

        public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        }

        public final void notifyDataSetChanged() {
            this.mObservable.notifyChanged();
        }

        public final void notifyItemChanged(int position) {
            this.mObservable.notifyItemRangeChanged(position, 1);
        }

        public final void notifyItemChanged(int position, @Nullable Object payload) {
            this.mObservable.notifyItemRangeChanged(position, 1, payload);
        }

        public final void notifyItemRangeChanged(int positionStart, int itemCount) {
            this.mObservable.notifyItemRangeChanged(positionStart, itemCount);
        }

        public final void notifyItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            this.mObservable.notifyItemRangeChanged(positionStart, itemCount, payload);
        }

        public final void notifyItemInserted(int position) {
            this.mObservable.notifyItemRangeInserted(position, 1);
        }

        public final void notifyItemMoved(int fromPosition, int toPosition) {
            this.mObservable.notifyItemMoved(fromPosition, toPosition);
        }

        public final void notifyItemRangeInserted(int positionStart, int itemCount) {
            this.mObservable.notifyItemRangeInserted(positionStart, itemCount);
        }

        public final void notifyItemRemoved(int position) {
            this.mObservable.notifyItemRangeRemoved(position, 1);
        }

        public final void notifyItemRangeRemoved(int positionStart, int itemCount) {
            this.mObservable.notifyItemRangeRemoved(positionStart, itemCount);
        }

        public void setStateRestorationPolicy(@NonNull StateRestorationPolicy strategy) {
            this.mStateRestorationPolicy = strategy;
            this.mObservable.notifyStateRestorationPolicyChanged();
        }

        @NonNull
        public final StateRestorationPolicy getStateRestorationPolicy() {
            return this.mStateRestorationPolicy;
        }

        boolean canRestoreState() {
            switch (this.mStateRestorationPolicy) {
                case PREVENT: {
                    return false;
                }
                case PREVENT_WHEN_EMPTY: {
                    return this.getItemCount() > 0;
                }
            }
            return true;
        }

        public static enum StateRestorationPolicy {
            ALLOW,
            PREVENT_WHEN_EMPTY,
            PREVENT;

        }
    }

    public static abstract class ViewCacheExtension {
        @Nullable
        public abstract View getViewForPositionAndType(@NonNull Recycler var1, int var2, int var3);
    }

    public final class Recycler {
        final ArrayList<ViewHolder> mAttachedScrap = new ArrayList();
        ArrayList<ViewHolder> mChangedScrap = null;
        final ArrayList<ViewHolder> mCachedViews = new ArrayList();
        private final List<ViewHolder> mUnmodifiableAttachedScrap = Collections.unmodifiableList(this.mAttachedScrap);
        private int mRequestedCacheMax = 2;
        int mViewCacheMax = 2;
        RecycledViewPool mRecyclerPool;
        private ViewCacheExtension mViewCacheExtension;
        static final int DEFAULT_CACHE_SIZE = 2;

        public void clear() {
            this.mAttachedScrap.clear();
            this.recycleAndClearCachedViews();
        }

        public void setViewCacheSize(int viewCount) {
            this.mRequestedCacheMax = viewCount;
            this.updateViewCacheSize();
        }

        void updateViewCacheSize() {
            int extraCache = RecyclerView.this.mLayout != null ? RecyclerView.this.mLayout.mPrefetchMaxCountObserved : 0;
            this.mViewCacheMax = this.mRequestedCacheMax + extraCache;
            for (int i = this.mCachedViews.size() - 1; i >= 0 && this.mCachedViews.size() > this.mViewCacheMax; --i) {
                this.recycleCachedViewAt(i);
            }
        }

        @NonNull
        public List<ViewHolder> getScrapList() {
            return this.mUnmodifiableAttachedScrap;
        }

        boolean validateViewHolderForOffsetPosition(ViewHolder holder) {
            int type;
            if (holder.isRemoved()) {
                return RecyclerView.this.mState.isPreLayout();
            }
            if (holder.mPosition < 0 || holder.mPosition >= RecyclerView.this.mAdapter.getItemCount()) {
                throw new IndexOutOfBoundsException("Inconsistency detected. Invalid view holder adapter position" + holder + RecyclerView.this.exceptionLabel());
            }
            if (!RecyclerView.this.mState.isPreLayout() && (type = RecyclerView.this.mAdapter.getItemViewType(holder.mPosition)) != holder.getItemViewType()) {
                return false;
            }
            if (RecyclerView.this.mAdapter.hasStableIds()) {
                return holder.getItemId() == RecyclerView.this.mAdapter.getItemId(holder.mPosition);
            }
            return true;
        }

        private boolean tryBindViewHolderByDeadline(@NonNull ViewHolder holder, int offsetPosition, int position, long deadlineNs) {
            holder.mBindingAdapter = null;
            holder.mOwnerRecyclerView = RecyclerView.this;
            int viewType = holder.getItemViewType();
            long startBindNs = RecyclerView.this.getNanoTime();
            if (deadlineNs != Long.MAX_VALUE && !this.mRecyclerPool.willBindInTime(viewType, startBindNs, deadlineNs)) {
                return false;
            }
            RecyclerView.this.mAdapter.bindViewHolder(holder, offsetPosition);
            long endBindNs = RecyclerView.this.getNanoTime();
            this.mRecyclerPool.factorInBindTime(holder.getItemViewType(), endBindNs - startBindNs);
            this.attachAccessibilityDelegateOnBind(holder);
            if (RecyclerView.this.mState.isPreLayout()) {
                holder.mPreLayoutPosition = position;
            }
            return true;
        }

        public void bindViewToPosition(@NonNull View view, int position) {
            LayoutParams rvLayoutParams;
            ViewHolder holder = RecyclerView.getChildViewHolderInt(view);
            if (holder == null) {
                throw new IllegalArgumentException("The view does not have a ViewHolder. You cannot pass arbitrary views to this method, they should be created by the Adapter" + RecyclerView.this.exceptionLabel());
            }
            int offsetPosition = RecyclerView.this.mAdapterHelper.findPositionOffset(position);
            if (offsetPosition < 0 || offsetPosition >= RecyclerView.this.mAdapter.getItemCount()) {
                throw new IndexOutOfBoundsException("Inconsistency detected. Invalid item position " + position + "(offset:" + offsetPosition + ").state:" + RecyclerView.this.mState.getItemCount() + RecyclerView.this.exceptionLabel());
            }
            this.tryBindViewHolderByDeadline(holder, offsetPosition, position, Long.MAX_VALUE);
            ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
            if (lp == null) {
                rvLayoutParams = (LayoutParams)RecyclerView.this.generateDefaultLayoutParams();
                holder.itemView.setLayoutParams((ViewGroup.LayoutParams)rvLayoutParams);
            } else if (!RecyclerView.this.checkLayoutParams(lp)) {
                rvLayoutParams = (LayoutParams)RecyclerView.this.generateLayoutParams(lp);
                holder.itemView.setLayoutParams((ViewGroup.LayoutParams)rvLayoutParams);
            } else {
                rvLayoutParams = (LayoutParams)lp;
            }
            rvLayoutParams.mInsetsDirty = true;
            rvLayoutParams.mViewHolder = holder;
            rvLayoutParams.mPendingInvalidate = holder.itemView.getParent() == null;
        }

        public int convertPreLayoutPositionToPostLayout(int position) {
            if (position < 0 || position >= RecyclerView.this.mState.getItemCount()) {
                throw new IndexOutOfBoundsException("invalid position " + position + ". State item count is " + RecyclerView.this.mState.getItemCount() + RecyclerView.this.exceptionLabel());
            }
            if (!RecyclerView.this.mState.isPreLayout()) {
                return position;
            }
            return RecyclerView.this.mAdapterHelper.findPositionOffset(position);
        }

        @NonNull
        public View getViewForPosition(int position) {
            return this.getViewForPosition(position, false);
        }

        View getViewForPosition(int position, boolean dryRun) {
            return this.tryGetViewHolderForPositionByDeadline((int)position, (boolean)dryRun, (long)Long.MAX_VALUE).itemView;
        }

        @Nullable
        ViewHolder tryGetViewHolderForPositionByDeadline(int position, boolean dryRun, long deadlineNs) {
            LayoutParams rvLayoutParams;
            if (position < 0 || position >= RecyclerView.this.mState.getItemCount()) {
                throw new IndexOutOfBoundsException("Invalid item position " + position + "(" + position + "). Item count:" + RecyclerView.this.mState.getItemCount() + RecyclerView.this.exceptionLabel());
            }
            boolean fromScrapOrHiddenOrCache = false;
            ViewHolder holder = null;
            if (RecyclerView.this.mState.isPreLayout()) {
                holder = this.getChangedScrapViewForPosition(position);
                boolean bl = fromScrapOrHiddenOrCache = holder != null;
            }
            if (holder == null && (holder = this.getScrapOrHiddenOrCachedHolderForPosition(position, dryRun)) != null) {
                if (!this.validateViewHolderForOffsetPosition(holder)) {
                    if (!dryRun) {
                        holder.addFlags(4);
                        if (holder.isScrap()) {
                            RecyclerView.this.removeDetachedView(holder.itemView, false);
                            holder.unScrap();
                        } else if (holder.wasReturnedFromScrap()) {
                            holder.clearReturnedFromScrapFlag();
                        }
                        this.recycleViewHolderInternal(holder);
                    }
                    holder = null;
                } else {
                    fromScrapOrHiddenOrCache = true;
                }
            }
            if (holder == null) {
                View view;
                int offsetPosition = RecyclerView.this.mAdapterHelper.findPositionOffset(position);
                if (offsetPosition < 0 || offsetPosition >= RecyclerView.this.mAdapter.getItemCount()) {
                    throw new IndexOutOfBoundsException("Inconsistency detected. Invalid item position " + position + "(offset:" + offsetPosition + ").state:" + RecyclerView.this.mState.getItemCount() + RecyclerView.this.exceptionLabel());
                }
                int type = RecyclerView.this.mAdapter.getItemViewType(offsetPosition);
                if (RecyclerView.this.mAdapter.hasStableIds() && (holder = this.getScrapOrCachedViewForId(RecyclerView.this.mAdapter.getItemId(offsetPosition), type, dryRun)) != null) {
                    holder.mPosition = offsetPosition;
                    fromScrapOrHiddenOrCache = true;
                }
                if (holder == null && this.mViewCacheExtension != null && (view = this.mViewCacheExtension.getViewForPositionAndType(this, position, type)) != null) {
                    holder = RecyclerView.this.getChildViewHolder(view);
                    if (holder == null) {
                        throw new IllegalArgumentException("getViewForPositionAndType returned a view which does not have a ViewHolder" + RecyclerView.this.exceptionLabel());
                    }
                    if (holder.shouldIgnore()) {
                        throw new IllegalArgumentException("getViewForPositionAndType returned a view that is ignored. You must call stopIgnoring before returning this view." + RecyclerView.this.exceptionLabel());
                    }
                }
                if (holder == null && (holder = this.getRecycledViewPool().getRecycledView(type)) != null) {
                    holder.resetInternal();
                    if (FORCE_INVALIDATE_DISPLAY_LIST) {
                        this.invalidateDisplayListInt(holder);
                    }
                }
                if (holder == null) {
                    RecyclerView innerView;
                    long start = RecyclerView.this.getNanoTime();
                    if (deadlineNs != Long.MAX_VALUE && !this.mRecyclerPool.willCreateInTime(type, start, deadlineNs)) {
                        return null;
                    }
                    holder = RecyclerView.this.mAdapter.createViewHolder(RecyclerView.this, type);
                    if (ALLOW_THREAD_GAP_WORK && (innerView = RecyclerView.findNestedRecyclerView(holder.itemView)) != null) {
                        holder.mNestedRecyclerView = new WeakReference<RecyclerView>(innerView);
                    }
                    long end = RecyclerView.this.getNanoTime();
                    this.mRecyclerPool.factorInCreateTime(type, end - start);
                }
            }
            if (fromScrapOrHiddenOrCache && !RecyclerView.this.mState.isPreLayout() && holder.hasAnyOfTheFlags(8192)) {
                holder.setFlags(0, 8192);
                if (RecyclerView.this.mState.mRunSimpleAnimations) {
                    int changeFlags = ItemAnimator.buildAdapterChangeFlagsForAnimations(holder);
                    ItemAnimator.ItemHolderInfo info = RecyclerView.this.mItemAnimator.recordPreLayoutInformation(RecyclerView.this.mState, holder, changeFlags |= 0x1000, holder.getUnmodifiedPayloads());
                    RecyclerView.this.recordAnimationInfoIfBouncedHiddenView(holder, info);
                }
            }
            boolean bound = false;
            if (RecyclerView.this.mState.isPreLayout() && holder.isBound()) {
                holder.mPreLayoutPosition = position;
            } else if (!holder.isBound() || holder.needsUpdate() || holder.isInvalid()) {
                int offsetPosition = RecyclerView.this.mAdapterHelper.findPositionOffset(position);
                bound = this.tryBindViewHolderByDeadline(holder, offsetPosition, position, deadlineNs);
            }
            ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
            if (lp == null) {
                rvLayoutParams = (LayoutParams)RecyclerView.this.generateDefaultLayoutParams();
                holder.itemView.setLayoutParams((ViewGroup.LayoutParams)rvLayoutParams);
            } else if (!RecyclerView.this.checkLayoutParams(lp)) {
                rvLayoutParams = (LayoutParams)RecyclerView.this.generateLayoutParams(lp);
                holder.itemView.setLayoutParams((ViewGroup.LayoutParams)rvLayoutParams);
            } else {
                rvLayoutParams = (LayoutParams)lp;
            }
            rvLayoutParams.mViewHolder = holder;
            rvLayoutParams.mPendingInvalidate = fromScrapOrHiddenOrCache && bound;
            return holder;
        }

        private void attachAccessibilityDelegateOnBind(ViewHolder holder) {
            if (RecyclerView.this.isAccessibilityEnabled()) {
                View itemView = holder.itemView;
                if (ViewCompat.getImportantForAccessibility((View)itemView) == 0) {
                    ViewCompat.setImportantForAccessibility((View)itemView, (int)1);
                }
                if (RecyclerView.this.mAccessibilityDelegate == null) {
                    return;
                }
                AccessibilityDelegateCompat itemDelegate = RecyclerView.this.mAccessibilityDelegate.getItemDelegate();
                if (itemDelegate instanceof RecyclerViewAccessibilityDelegate.ItemDelegate) {
                    ((RecyclerViewAccessibilityDelegate.ItemDelegate)itemDelegate).saveOriginalDelegate(itemView);
                }
                ViewCompat.setAccessibilityDelegate((View)itemView, (AccessibilityDelegateCompat)itemDelegate);
            }
        }

        private void invalidateDisplayListInt(ViewHolder holder) {
            if (holder.itemView instanceof ViewGroup) {
                this.invalidateDisplayListInt((ViewGroup)holder.itemView, false);
            }
        }

        private void invalidateDisplayListInt(ViewGroup viewGroup, boolean invalidateThis) {
            for (int i = viewGroup.getChildCount() - 1; i >= 0; --i) {
                View view = viewGroup.getChildAt(i);
                if (!(view instanceof ViewGroup)) continue;
                this.invalidateDisplayListInt((ViewGroup)view, true);
            }
            if (!invalidateThis) {
                return;
            }
            if (viewGroup.getVisibility() == 4) {
                viewGroup.setVisibility(0);
                viewGroup.setVisibility(4);
            } else {
                int visibility = viewGroup.getVisibility();
                viewGroup.setVisibility(4);
                viewGroup.setVisibility(visibility);
            }
        }

        public void recycleView(@NonNull View view) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(view);
            if (holder.isTmpDetached()) {
                RecyclerView.this.removeDetachedView(view, false);
            }
            if (holder.isScrap()) {
                holder.unScrap();
            } else if (holder.wasReturnedFromScrap()) {
                holder.clearReturnedFromScrapFlag();
            }
            this.recycleViewHolderInternal(holder);
            if (RecyclerView.this.mItemAnimator != null && !holder.isRecyclable()) {
                RecyclerView.this.mItemAnimator.endAnimation(holder);
            }
        }

        void recycleAndClearCachedViews() {
            int count = this.mCachedViews.size();
            for (int i = count - 1; i >= 0; --i) {
                this.recycleCachedViewAt(i);
            }
            this.mCachedViews.clear();
            if (ALLOW_THREAD_GAP_WORK) {
                RecyclerView.this.mPrefetchRegistry.clearPrefetchPositions();
            }
        }

        void recycleCachedViewAt(int cachedViewIndex) {
            ViewHolder viewHolder = this.mCachedViews.get(cachedViewIndex);
            this.addViewHolderToRecycledViewPool(viewHolder, true);
            this.mCachedViews.remove(cachedViewIndex);
        }

        void recycleViewHolderInternal(ViewHolder holder) {
            if (holder.isScrap() || holder.itemView.getParent() != null) {
                throw new IllegalArgumentException("Scrapped or attached views may not be recycled. isScrap:" + holder.isScrap() + " isAttached:" + (holder.itemView.getParent() != null) + RecyclerView.this.exceptionLabel());
            }
            if (holder.isTmpDetached()) {
                throw new IllegalArgumentException("Tmp detached view should be removed from RecyclerView before it can be recycled: " + holder + RecyclerView.this.exceptionLabel());
            }
            if (holder.shouldIgnore()) {
                throw new IllegalArgumentException("Trying to recycle an ignored view holder. You should first call stopIgnoringView(view) before calling recycle." + RecyclerView.this.exceptionLabel());
            }
            boolean transientStatePreventsRecycling = holder.doesTransientStatePreventRecycling();
            boolean forceRecycle = RecyclerView.this.mAdapter != null && transientStatePreventsRecycling && RecyclerView.this.mAdapter.onFailedToRecycleView(holder);
            boolean cached = false;
            boolean recycled = false;
            if (forceRecycle || holder.isRecyclable()) {
                if (this.mViewCacheMax > 0 && !holder.hasAnyOfTheFlags(526)) {
                    int cachedViewSize = this.mCachedViews.size();
                    if (cachedViewSize >= this.mViewCacheMax && cachedViewSize > 0) {
                        this.recycleCachedViewAt(0);
                        --cachedViewSize;
                    }
                    int targetCacheIndex = cachedViewSize;
                    if (ALLOW_THREAD_GAP_WORK && cachedViewSize > 0 && !RecyclerView.this.mPrefetchRegistry.lastPrefetchIncludedPosition(holder.mPosition)) {
                        int cachedPos;
                        int cacheIndex;
                        for (cacheIndex = cachedViewSize - 1; cacheIndex >= 0 && RecyclerView.this.mPrefetchRegistry.lastPrefetchIncludedPosition(cachedPos = this.mCachedViews.get((int)cacheIndex).mPosition); --cacheIndex) {
                        }
                        targetCacheIndex = cacheIndex + 1;
                    }
                    this.mCachedViews.add(targetCacheIndex, holder);
                    cached = true;
                }
                if (!cached) {
                    this.addViewHolderToRecycledViewPool(holder, true);
                    recycled = true;
                }
            }
            RecyclerView.this.mViewInfoStore.removeViewHolder(holder);
            if (!cached && !recycled && transientStatePreventsRecycling) {
                PoolingContainer.callPoolingContainerOnRelease((View)holder.itemView);
                holder.mBindingAdapter = null;
                holder.mOwnerRecyclerView = null;
            }
        }

        void addViewHolderToRecycledViewPool(@NonNull ViewHolder holder, boolean dispatchRecycled) {
            RecyclerView.clearNestedRecyclerViewIfNotNested(holder);
            View itemView = holder.itemView;
            if (RecyclerView.this.mAccessibilityDelegate != null) {
                AccessibilityDelegateCompat itemDelegate = RecyclerView.this.mAccessibilityDelegate.getItemDelegate();
                AccessibilityDelegateCompat originalDelegate = null;
                if (itemDelegate instanceof RecyclerViewAccessibilityDelegate.ItemDelegate) {
                    originalDelegate = ((RecyclerViewAccessibilityDelegate.ItemDelegate)itemDelegate).getAndRemoveOriginalDelegateForItem(itemView);
                }
                ViewCompat.setAccessibilityDelegate((View)itemView, originalDelegate);
            }
            if (dispatchRecycled) {
                this.dispatchViewRecycled(holder);
            }
            holder.mBindingAdapter = null;
            holder.mOwnerRecyclerView = null;
            this.getRecycledViewPool().putRecycledView(holder);
        }

        void quickRecycleScrapView(View view) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(view);
            holder.mScrapContainer = null;
            holder.mInChangeScrap = false;
            holder.clearReturnedFromScrapFlag();
            this.recycleViewHolderInternal(holder);
        }

        void scrapView(View view) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(view);
            if (holder.hasAnyOfTheFlags(12) || !holder.isUpdated() || RecyclerView.this.canReuseUpdatedViewHolder(holder)) {
                if (holder.isInvalid() && !holder.isRemoved() && !RecyclerView.this.mAdapter.hasStableIds()) {
                    throw new IllegalArgumentException("Called scrap view with an invalid view. Invalid views cannot be reused from scrap, they should rebound from recycler pool." + RecyclerView.this.exceptionLabel());
                }
                holder.setScrapContainer(this, false);
                this.mAttachedScrap.add(holder);
            } else {
                if (this.mChangedScrap == null) {
                    this.mChangedScrap = new ArrayList();
                }
                holder.setScrapContainer(this, true);
                this.mChangedScrap.add(holder);
            }
        }

        void unscrapView(ViewHolder holder) {
            if (holder.mInChangeScrap) {
                this.mChangedScrap.remove(holder);
            } else {
                this.mAttachedScrap.remove(holder);
            }
            holder.mScrapContainer = null;
            holder.mInChangeScrap = false;
            holder.clearReturnedFromScrapFlag();
        }

        int getScrapCount() {
            return this.mAttachedScrap.size();
        }

        View getScrapViewAt(int index) {
            return this.mAttachedScrap.get((int)index).itemView;
        }

        void clearScrap() {
            this.mAttachedScrap.clear();
            if (this.mChangedScrap != null) {
                this.mChangedScrap.clear();
            }
        }

        ViewHolder getChangedScrapViewForPosition(int position) {
            int offsetPosition;
            int changedScrapSize;
            if (this.mChangedScrap == null || (changedScrapSize = this.mChangedScrap.size()) == 0) {
                return null;
            }
            for (int i = 0; i < changedScrapSize; ++i) {
                ViewHolder holder = this.mChangedScrap.get(i);
                if (holder.wasReturnedFromScrap() || holder.getLayoutPosition() != position) continue;
                holder.addFlags(32);
                return holder;
            }
            if (RecyclerView.this.mAdapter.hasStableIds() && (offsetPosition = RecyclerView.this.mAdapterHelper.findPositionOffset(position)) > 0 && offsetPosition < RecyclerView.this.mAdapter.getItemCount()) {
                long id2 = RecyclerView.this.mAdapter.getItemId(offsetPosition);
                for (int i = 0; i < changedScrapSize; ++i) {
                    ViewHolder holder = this.mChangedScrap.get(i);
                    if (holder.wasReturnedFromScrap() || holder.getItemId() != id2) continue;
                    holder.addFlags(32);
                    return holder;
                }
            }
            return null;
        }

        ViewHolder getScrapOrHiddenOrCachedHolderForPosition(int position, boolean dryRun) {
            View view;
            int scrapCount = this.mAttachedScrap.size();
            for (int i = 0; i < scrapCount; ++i) {
                ViewHolder holder = this.mAttachedScrap.get(i);
                if (holder.wasReturnedFromScrap() || holder.getLayoutPosition() != position || holder.isInvalid() || !RecyclerView.this.mState.mInPreLayout && holder.isRemoved()) continue;
                holder.addFlags(32);
                return holder;
            }
            if (!dryRun && (view = RecyclerView.this.mChildHelper.findHiddenNonRemovedView(position)) != null) {
                ViewHolder vh = RecyclerView.getChildViewHolderInt(view);
                RecyclerView.this.mChildHelper.unhide(view);
                int layoutIndex = RecyclerView.this.mChildHelper.indexOfChild(view);
                if (layoutIndex == -1) {
                    throw new IllegalStateException("layout index should not be -1 after unhiding a view:" + vh + RecyclerView.this.exceptionLabel());
                }
                RecyclerView.this.mChildHelper.detachViewFromParent(layoutIndex);
                this.scrapView(view);
                vh.addFlags(8224);
                return vh;
            }
            int cacheSize = this.mCachedViews.size();
            for (int i = 0; i < cacheSize; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder.isInvalid() || holder.getLayoutPosition() != position || holder.isAttachedToTransitionOverlay()) continue;
                if (!dryRun) {
                    this.mCachedViews.remove(i);
                }
                return holder;
            }
            return null;
        }

        ViewHolder getScrapOrCachedViewForId(long id2, int type, boolean dryRun) {
            int count = this.mAttachedScrap.size();
            for (int i = count - 1; i >= 0; --i) {
                ViewHolder holder = this.mAttachedScrap.get(i);
                if (holder.getItemId() != id2 || holder.wasReturnedFromScrap()) continue;
                if (type == holder.getItemViewType()) {
                    holder.addFlags(32);
                    if (holder.isRemoved() && !RecyclerView.this.mState.isPreLayout()) {
                        holder.setFlags(2, 14);
                    }
                    return holder;
                }
                if (dryRun) continue;
                this.mAttachedScrap.remove(i);
                RecyclerView.this.removeDetachedView(holder.itemView, false);
                this.quickRecycleScrapView(holder.itemView);
            }
            int cacheSize = this.mCachedViews.size();
            for (int i = cacheSize - 1; i >= 0; --i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder.getItemId() != id2 || holder.isAttachedToTransitionOverlay()) continue;
                if (type == holder.getItemViewType()) {
                    if (!dryRun) {
                        this.mCachedViews.remove(i);
                    }
                    return holder;
                }
                if (dryRun) continue;
                this.recycleCachedViewAt(i);
                return null;
            }
            return null;
        }

        void dispatchViewRecycled(@NonNull ViewHolder holder) {
            if (RecyclerView.this.mRecyclerListener != null) {
                RecyclerView.this.mRecyclerListener.onViewRecycled(holder);
            }
            int listenerCount = RecyclerView.this.mRecyclerListeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                RecyclerView.this.mRecyclerListeners.get(i).onViewRecycled(holder);
            }
            if (RecyclerView.this.mAdapter != null) {
                RecyclerView.this.mAdapter.onViewRecycled(holder);
            }
            if (RecyclerView.this.mState != null) {
                RecyclerView.this.mViewInfoStore.removeViewHolder(holder);
            }
        }

        void onAdapterChanged(Adapter<?> oldAdapter, Adapter<?> newAdapter, boolean compatibleWithPrevious) {
            this.clear();
            this.poolingContainerDetach(oldAdapter, true);
            this.getRecycledViewPool().onAdapterChanged(oldAdapter, newAdapter, compatibleWithPrevious);
            this.maybeSendPoolingContainerAttach();
        }

        void offsetPositionRecordsForMove(int from, int to) {
            int inBetweenOffset;
            int end;
            int start;
            if (from < to) {
                start = from;
                end = to;
                inBetweenOffset = -1;
            } else {
                start = to;
                end = from;
                inBetweenOffset = 1;
            }
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null || holder.mPosition < start || holder.mPosition > end) continue;
                if (holder.mPosition == from) {
                    holder.offsetPosition(to - from, false);
                    continue;
                }
                holder.offsetPosition(inBetweenOffset, false);
            }
        }

        void offsetPositionRecordsForInsert(int insertedAt, int count) {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null || holder.mPosition < insertedAt) continue;
                holder.offsetPosition(count, false);
            }
        }

        void offsetPositionRecordsForRemove(int removedFrom, int count, boolean applyToPreLayout) {
            int removedEnd = removedFrom + count;
            int cachedCount = this.mCachedViews.size();
            for (int i = cachedCount - 1; i >= 0; --i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null) continue;
                if (holder.mPosition >= removedEnd) {
                    holder.offsetPosition(-count, applyToPreLayout);
                    continue;
                }
                if (holder.mPosition < removedFrom) continue;
                holder.addFlags(8);
                this.recycleCachedViewAt(i);
            }
        }

        void setViewCacheExtension(ViewCacheExtension extension) {
            this.mViewCacheExtension = extension;
        }

        void setRecycledViewPool(RecycledViewPool pool) {
            this.poolingContainerDetach(RecyclerView.this.mAdapter);
            if (this.mRecyclerPool != null) {
                this.mRecyclerPool.detach();
            }
            this.mRecyclerPool = pool;
            if (this.mRecyclerPool != null && RecyclerView.this.getAdapter() != null) {
                this.mRecyclerPool.attach();
            }
            this.maybeSendPoolingContainerAttach();
        }

        private void maybeSendPoolingContainerAttach() {
            if (this.mRecyclerPool != null && RecyclerView.this.mAdapter != null && RecyclerView.this.isAttachedToWindow()) {
                this.mRecyclerPool.attachForPoolingContainer(RecyclerView.this.mAdapter);
            }
        }

        private void poolingContainerDetach(Adapter<?> adapter) {
            this.poolingContainerDetach(adapter, false);
        }

        private void poolingContainerDetach(Adapter<?> adapter, boolean isBeingReplaced) {
            if (this.mRecyclerPool != null) {
                this.mRecyclerPool.detachForPoolingContainer(adapter, isBeingReplaced);
            }
        }

        void onAttachedToWindow() {
            this.maybeSendPoolingContainerAttach();
        }

        void onDetachedFromWindow() {
            for (int i = 0; i < this.mCachedViews.size(); ++i) {
                PoolingContainer.callPoolingContainerOnRelease((View)this.mCachedViews.get((int)i).itemView);
            }
            this.poolingContainerDetach(RecyclerView.this.mAdapter);
        }

        RecycledViewPool getRecycledViewPool() {
            if (this.mRecyclerPool == null) {
                this.mRecyclerPool = new RecycledViewPool();
                this.maybeSendPoolingContainerAttach();
            }
            return this.mRecyclerPool;
        }

        void viewRangeUpdate(int positionStart, int itemCount) {
            int positionEnd = positionStart + itemCount;
            int cachedCount = this.mCachedViews.size();
            for (int i = cachedCount - 1; i >= 0; --i) {
                int pos;
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null || (pos = holder.mPosition) < positionStart || pos >= positionEnd) continue;
                holder.addFlags(2);
                this.recycleCachedViewAt(i);
            }
        }

        void markKnownViewsInvalid() {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null) continue;
                holder.addFlags(6);
                holder.addChangePayload(null);
            }
            if (RecyclerView.this.mAdapter == null || !RecyclerView.this.mAdapter.hasStableIds()) {
                this.recycleAndClearCachedViews();
            }
        }

        void clearOldPositions() {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                holder.clearOldPosition();
            }
            int scrapCount = this.mAttachedScrap.size();
            for (int i = 0; i < scrapCount; ++i) {
                this.mAttachedScrap.get(i).clearOldPosition();
            }
            if (this.mChangedScrap != null) {
                int changedScrapCount = this.mChangedScrap.size();
                for (int i = 0; i < changedScrapCount; ++i) {
                    this.mChangedScrap.get(i).clearOldPosition();
                }
            }
        }

        void markItemDecorInsetsDirty() {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                LayoutParams layoutParams = (LayoutParams)holder.itemView.getLayoutParams();
                if (layoutParams == null) continue;
                layoutParams.mInsetsDirty = true;
            }
        }
    }

    public static class RecycledViewPool {
        private static final int DEFAULT_MAX_SCRAP = 5;
        SparseArray<ScrapData> mScrap = new SparseArray();
        int mAttachCountForClearing = 0;
        Set<Adapter<?>> mAttachedAdaptersForPoolingContainer = Collections.newSetFromMap(new IdentityHashMap());

        public void clear() {
            for (int i = 0; i < this.mScrap.size(); ++i) {
                ScrapData data = (ScrapData)this.mScrap.valueAt(i);
                for (ViewHolder scrap : data.mScrapHeap) {
                    PoolingContainer.callPoolingContainerOnRelease((View)scrap.itemView);
                }
                data.mScrapHeap.clear();
            }
        }

        public void setMaxRecycledViews(int viewType, int max) {
            ScrapData scrapData = this.getScrapDataForType(viewType);
            scrapData.mMaxScrap = max;
            ArrayList<ViewHolder> scrapHeap = scrapData.mScrapHeap;
            while (scrapHeap.size() > max) {
                scrapHeap.remove(scrapHeap.size() - 1);
            }
        }

        public int getRecycledViewCount(int viewType) {
            return this.getScrapDataForType((int)viewType).mScrapHeap.size();
        }

        @Nullable
        public ViewHolder getRecycledView(int viewType) {
            ScrapData scrapData = (ScrapData)this.mScrap.get(viewType);
            if (scrapData != null && !scrapData.mScrapHeap.isEmpty()) {
                ArrayList<ViewHolder> scrapHeap = scrapData.mScrapHeap;
                for (int i = scrapHeap.size() - 1; i >= 0; --i) {
                    if (scrapHeap.get(i).isAttachedToTransitionOverlay()) continue;
                    return scrapHeap.remove(i);
                }
            }
            return null;
        }

        int size() {
            int count = 0;
            for (int i = 0; i < this.mScrap.size(); ++i) {
                ArrayList<ViewHolder> viewHolders = ((ScrapData)this.mScrap.valueAt((int)i)).mScrapHeap;
                if (viewHolders == null) continue;
                count += viewHolders.size();
            }
            return count;
        }

        public void putRecycledView(ViewHolder scrap) {
            int viewType = scrap.getItemViewType();
            ArrayList<ViewHolder> scrapHeap = this.getScrapDataForType((int)viewType).mScrapHeap;
            if (((ScrapData)this.mScrap.get((int)viewType)).mMaxScrap <= scrapHeap.size()) {
                PoolingContainer.callPoolingContainerOnRelease((View)scrap.itemView);
                return;
            }
            scrap.resetInternal();
            scrapHeap.add(scrap);
        }

        long runningAverage(long oldAverage, long newValue) {
            if (oldAverage == 0L) {
                return newValue;
            }
            return oldAverage / 4L * 3L + newValue / 4L;
        }

        void factorInCreateTime(int viewType, long createTimeNs) {
            ScrapData scrapData = this.getScrapDataForType(viewType);
            scrapData.mCreateRunningAverageNs = this.runningAverage(scrapData.mCreateRunningAverageNs, createTimeNs);
        }

        void factorInBindTime(int viewType, long bindTimeNs) {
            ScrapData scrapData = this.getScrapDataForType(viewType);
            scrapData.mBindRunningAverageNs = this.runningAverage(scrapData.mBindRunningAverageNs, bindTimeNs);
        }

        boolean willCreateInTime(int viewType, long approxCurrentNs, long deadlineNs) {
            long expectedDurationNs = this.getScrapDataForType((int)viewType).mCreateRunningAverageNs;
            return expectedDurationNs == 0L || approxCurrentNs + expectedDurationNs < deadlineNs;
        }

        boolean willBindInTime(int viewType, long approxCurrentNs, long deadlineNs) {
            long expectedDurationNs = this.getScrapDataForType((int)viewType).mBindRunningAverageNs;
            return expectedDurationNs == 0L || approxCurrentNs + expectedDurationNs < deadlineNs;
        }

        void attach() {
            ++this.mAttachCountForClearing;
        }

        void detach() {
            --this.mAttachCountForClearing;
        }

        void attachForPoolingContainer(@NonNull Adapter<?> adapter) {
            this.mAttachedAdaptersForPoolingContainer.add(adapter);
        }

        void detachForPoolingContainer(@NonNull Adapter<?> adapter, boolean isBeingReplaced) {
            this.mAttachedAdaptersForPoolingContainer.remove(adapter);
            if (this.mAttachedAdaptersForPoolingContainer.size() == 0 && !isBeingReplaced) {
                for (int keyIndex = 0; keyIndex < this.mScrap.size(); ++keyIndex) {
                    ArrayList<ViewHolder> scrapHeap = ((ScrapData)this.mScrap.get((int)this.mScrap.keyAt((int)keyIndex))).mScrapHeap;
                    for (int i = 0; i < scrapHeap.size(); ++i) {
                        PoolingContainer.callPoolingContainerOnRelease((View)scrapHeap.get((int)i).itemView);
                    }
                }
            }
        }

        void onAdapterChanged(Adapter<?> oldAdapter, Adapter<?> newAdapter, boolean compatibleWithPrevious) {
            if (oldAdapter != null) {
                this.detach();
            }
            if (!compatibleWithPrevious && this.mAttachCountForClearing == 0) {
                this.clear();
            }
            if (newAdapter != null) {
                this.attach();
            }
        }

        private ScrapData getScrapDataForType(int viewType) {
            ScrapData scrapData = (ScrapData)this.mScrap.get(viewType);
            if (scrapData == null) {
                scrapData = new ScrapData();
                this.mScrap.put(viewType, (Object)scrapData);
            }
            return scrapData;
        }

        static class ScrapData {
            final ArrayList<ViewHolder> mScrapHeap = new ArrayList();
            int mMaxScrap = 5;
            long mCreateRunningAverageNs = 0L;
            long mBindRunningAverageNs = 0L;

            ScrapData() {
            }
        }
    }

    static class StretchEdgeEffectFactory
    extends EdgeEffectFactory {
        StretchEdgeEffectFactory() {
        }

        @Override
        @NonNull
        protected EdgeEffect createEdgeEffect(@NonNull RecyclerView view, int direction) {
            return new EdgeEffect(view.getContext());
        }
    }

    public static class EdgeEffectFactory {
        public static final int DIRECTION_LEFT = 0;
        public static final int DIRECTION_TOP = 1;
        public static final int DIRECTION_RIGHT = 2;
        public static final int DIRECTION_BOTTOM = 3;

        @NonNull
        protected EdgeEffect createEdgeEffect(@NonNull RecyclerView view, int direction) {
            return new EdgeEffect(view.getContext());
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface EdgeDirection {
        }
    }

    private class RecyclerViewDataObserver
    extends AdapterDataObserver {
        RecyclerViewDataObserver() {
        }

        @Override
        public void onChanged() {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            RecyclerView.this.mState.mStructureChanged = true;
            RecyclerView.this.processDataSetCompletelyChanged(true);
            if (!RecyclerView.this.mAdapterHelper.hasPendingUpdates()) {
                RecyclerView.this.requestLayout();
            }
        }

        @Override
        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.onItemRangeChanged(positionStart, itemCount, payload)) {
                this.triggerUpdateProcessor();
            }
        }

        @Override
        public void onItemRangeInserted(int positionStart, int itemCount) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.onItemRangeInserted(positionStart, itemCount)) {
                this.triggerUpdateProcessor();
            }
        }

        @Override
        public void onItemRangeRemoved(int positionStart, int itemCount) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.onItemRangeRemoved(positionStart, itemCount)) {
                this.triggerUpdateProcessor();
            }
        }

        @Override
        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.onItemRangeMoved(fromPosition, toPosition, itemCount)) {
                this.triggerUpdateProcessor();
            }
        }

        void triggerUpdateProcessor() {
            if (POST_UPDATES_ON_ANIMATION && RecyclerView.this.mHasFixedSize && RecyclerView.this.mIsAttached) {
                ViewCompat.postOnAnimation((View)RecyclerView.this, (Runnable)RecyclerView.this.mUpdateChildViewsRunnable);
            } else {
                RecyclerView.this.mAdapterUpdateDuringMeasure = true;
                RecyclerView.this.requestLayout();
            }
        }

        @Override
        public void onStateRestorationPolicyChanged() {
            if (RecyclerView.this.mPendingSavedState == null) {
                return;
            }
            Adapter adapter = RecyclerView.this.mAdapter;
            if (adapter != null && adapter.canRestoreState()) {
                RecyclerView.this.requestLayout();
            }
        }
    }

    class ViewFlinger
    implements Runnable {
        private int mLastFlingX;
        private int mLastFlingY;
        OverScroller mOverScroller;
        Interpolator mInterpolator = sQuinticInterpolator;
        private boolean mEatRunOnAnimationRequest = false;
        private boolean mReSchedulePostAnimationCallback = false;

        ViewFlinger() {
            this.mOverScroller = new OverScroller(RecyclerView.this.getContext(), sQuinticInterpolator);
        }

        @Override
        public void run() {
            SmoothScroller smoothScroller;
            if (RecyclerView.this.mLayout == null) {
                this.stop();
                return;
            }
            this.mReSchedulePostAnimationCallback = false;
            this.mEatRunOnAnimationRequest = true;
            RecyclerView.this.consumePendingUpdateOperations();
            OverScroller scroller = this.mOverScroller;
            if (scroller.computeScrollOffset()) {
                boolean smoothScrollerPending;
                int x = scroller.getCurrX();
                int y = scroller.getCurrY();
                int unconsumedX = x - this.mLastFlingX;
                int unconsumedY = y - this.mLastFlingY;
                this.mLastFlingX = x;
                this.mLastFlingY = y;
                unconsumedX = RecyclerView.this.consumeFlingInHorizontalStretch(unconsumedX);
                unconsumedY = RecyclerView.this.consumeFlingInVerticalStretch(unconsumedY);
                int consumedX = 0;
                int consumedY = 0;
                RecyclerView.this.mReusableIntPair[0] = 0;
                RecyclerView.this.mReusableIntPair[1] = 0;
                if (RecyclerView.this.dispatchNestedPreScroll(unconsumedX, unconsumedY, RecyclerView.this.mReusableIntPair, null, 1)) {
                    unconsumedX -= RecyclerView.this.mReusableIntPair[0];
                    unconsumedY -= RecyclerView.this.mReusableIntPair[1];
                }
                if (RecyclerView.this.getOverScrollMode() != 2) {
                    RecyclerView.this.considerReleasingGlowsOnScroll(unconsumedX, unconsumedY);
                }
                if (RecyclerView.this.mAdapter != null) {
                    RecyclerView.this.mReusableIntPair[0] = 0;
                    RecyclerView.this.mReusableIntPair[1] = 0;
                    RecyclerView.this.scrollStep(unconsumedX, unconsumedY, RecyclerView.this.mReusableIntPair);
                    consumedX = RecyclerView.this.mReusableIntPair[0];
                    consumedY = RecyclerView.this.mReusableIntPair[1];
                    unconsumedX -= consumedX;
                    unconsumedY -= consumedY;
                    SmoothScroller smoothScroller2 = RecyclerView.this.mLayout.mSmoothScroller;
                    if (smoothScroller2 != null && !smoothScroller2.isPendingInitialRun() && smoothScroller2.isRunning()) {
                        int adapterSize = RecyclerView.this.mState.getItemCount();
                        if (adapterSize == 0) {
                            smoothScroller2.stop();
                        } else if (smoothScroller2.getTargetPosition() >= adapterSize) {
                            smoothScroller2.setTargetPosition(adapterSize - 1);
                            smoothScroller2.onAnimation(consumedX, consumedY);
                        } else {
                            smoothScroller2.onAnimation(consumedX, consumedY);
                        }
                    }
                }
                if (!RecyclerView.this.mItemDecorations.isEmpty()) {
                    RecyclerView.this.invalidate();
                }
                RecyclerView.this.mReusableIntPair[0] = 0;
                RecyclerView.this.mReusableIntPair[1] = 0;
                RecyclerView.this.dispatchNestedScroll(consumedX, consumedY, unconsumedX, unconsumedY, null, 1, RecyclerView.this.mReusableIntPair);
                unconsumedX -= RecyclerView.this.mReusableIntPair[0];
                unconsumedY -= RecyclerView.this.mReusableIntPair[1];
                if (consumedX != 0 || consumedY != 0) {
                    RecyclerView.this.dispatchOnScrolled(consumedX, consumedY);
                }
                if (!RecyclerView.this.awakenScrollBars()) {
                    RecyclerView.this.invalidate();
                }
                boolean scrollerFinishedX = scroller.getCurrX() == scroller.getFinalX();
                boolean scrollerFinishedY = scroller.getCurrY() == scroller.getFinalY();
                boolean doneScrolling = scroller.isFinished() || (scrollerFinishedX || unconsumedX != 0) && (scrollerFinishedY || unconsumedY != 0);
                SmoothScroller smoothScroller3 = RecyclerView.this.mLayout.mSmoothScroller;
                boolean bl = smoothScrollerPending = smoothScroller3 != null && smoothScroller3.isPendingInitialRun();
                if (!smoothScrollerPending && doneScrolling) {
                    if (RecyclerView.this.getOverScrollMode() != 2) {
                        int velX;
                        int vel = (int)scroller.getCurrVelocity();
                        int n = unconsumedX < 0 ? -vel : (velX = unconsumedX > 0 ? vel : 0);
                        int velY = unconsumedY < 0 ? -vel : (unconsumedY > 0 ? vel : 0);
                        RecyclerView.this.absorbGlows(velX, velY);
                    }
                    if (ALLOW_THREAD_GAP_WORK) {
                        RecyclerView.this.mPrefetchRegistry.clearPrefetchPositions();
                    }
                } else {
                    this.postOnAnimation();
                    if (RecyclerView.this.mGapWorker != null) {
                        RecyclerView.this.mGapWorker.postFromTraversal(RecyclerView.this, consumedX, consumedY);
                    }
                }
            }
            if ((smoothScroller = RecyclerView.this.mLayout.mSmoothScroller) != null && smoothScroller.isPendingInitialRun()) {
                smoothScroller.onAnimation(0, 0);
            }
            this.mEatRunOnAnimationRequest = false;
            if (this.mReSchedulePostAnimationCallback) {
                this.internalPostOnAnimation();
            } else {
                RecyclerView.this.setScrollState(0);
                RecyclerView.this.stopNestedScroll(1);
            }
        }

        void postOnAnimation() {
            if (this.mEatRunOnAnimationRequest) {
                this.mReSchedulePostAnimationCallback = true;
            } else {
                this.internalPostOnAnimation();
            }
        }

        private void internalPostOnAnimation() {
            RecyclerView.this.removeCallbacks(this);
            ViewCompat.postOnAnimation((View)RecyclerView.this, (Runnable)this);
        }

        public void fling(int velocityX, int velocityY) {
            RecyclerView.this.setScrollState(2);
            this.mLastFlingY = 0;
            this.mLastFlingX = 0;
            if (this.mInterpolator != sQuinticInterpolator) {
                this.mInterpolator = sQuinticInterpolator;
                this.mOverScroller = new OverScroller(RecyclerView.this.getContext(), sQuinticInterpolator);
            }
            this.mOverScroller.fling(0, 0, velocityX, velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.postOnAnimation();
        }

        public void smoothScrollBy(int dx, int dy, int duration, @Nullable Interpolator interpolator) {
            if (duration == Integer.MIN_VALUE) {
                duration = this.computeScrollDuration(dx, dy);
            }
            if (interpolator == null) {
                interpolator = sQuinticInterpolator;
            }
            if (this.mInterpolator != interpolator) {
                this.mInterpolator = interpolator;
                this.mOverScroller = new OverScroller(RecyclerView.this.getContext(), interpolator);
            }
            this.mLastFlingY = 0;
            this.mLastFlingX = 0;
            RecyclerView.this.setScrollState(2);
            this.mOverScroller.startScroll(0, 0, dx, dy, duration);
            if (Build.VERSION.SDK_INT < 23) {
                this.mOverScroller.computeScrollOffset();
            }
            this.postOnAnimation();
        }

        private int computeScrollDuration(int dx, int dy) {
            int absDy;
            int absDx = Math.abs(dx);
            boolean horizontal = absDx > (absDy = Math.abs(dy));
            int containerSize = horizontal ? RecyclerView.this.getWidth() : RecyclerView.this.getHeight();
            float absDelta = horizontal ? absDx : absDy;
            int duration = (int)((absDelta / (float)containerSize + 1.0f) * 300.0f);
            return Math.min(duration, 2000);
        }

        public void stop() {
            RecyclerView.this.removeCallbacks(this);
            this.mOverScroller.abortAnimation();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface Orientation {
    }
}

